/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.action;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.PreviewPanel;
import com.jpexs.decompiler.flash.gui.TimelinedMaker;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.timeline.Timelined;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AddScriptDialog
extends AppDialog {
    private final JButton okButton = new JButton(this.translate("button.ok"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private JTextField frameTextField;
    private JTextField spriteFrameTextField;
    private PreviewPanel framePreviewPanel;
    private PreviewPanel spriteFramePreviewPanel;
    private PreviewPanel spriteInitPreviewPanel;
    private PreviewPanel buttonPreviewPanel;
    private PreviewPanel instancePreviewPanel;
    private JList<DefineSpriteTag> spriteInitList;
    private JTextField classNameTextField;
    private JTree instanceTree;
    private JTree spriteFrameTree;
    private JList<DefineButton2Tag> buttonList;
    private JList<MyFrame> frameList;
    private int frame = -1;
    private int result = -1;
    private final JPanel centerPanel;
    public static final int TYPE_FRAME = 0;
    public static final int TYPE_SPRITE_FRAME = 1;
    public static final int TYPE_SPRITE_INIT = 2;
    public static final int TYPE_BUTTON_EVENT = 3;
    public static final int TYPE_INSTANCE_EVENT = 4;
    public static final int TYPE_CLASS = 5;
    private final SWF swf;
    private final JComboBox<String> typeComboBox;
    private List<String> existingClasses = new ArrayList<String>();
    private List<Integer> spriteIdsWithDoInitAction;
    private boolean createClassSet = false;
    private final JPanel classPanel;
    private final JPanel topPanel;

    public AddScriptDialog(Window owner, SWF swf) {
        super(owner);
        this.setDefaultCloseOperation(1);
        this.setTitle(this.translate("dialog.title"));
        this.swf = swf;
        ReadOnlyTagList tags = swf.getTags();
        String PACKAGES = "__Packages.";
        for (Tag t : tags) {
            if (!(t instanceof ExportAssetsTag)) continue;
            ExportAssetsTag ea = (ExportAssetsTag)t;
            for (String n : ea.names) {
                if (!n.startsWith("__Packages.")) continue;
                this.existingClasses.add(n.substring("__Packages.".length()));
            }
        }
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JPanel panButtons = new JPanel(new FlowLayout());
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        panButtons.add(this.okButton);
        panButtons.add(this.cancelButton);
        this.topPanel = new JPanel(new FlowLayout(0));
        JLabel typeLabel = new JLabel(this.translate("type"));
        this.typeComboBox = new JComboBox<String>(new String[]{this.translate("type.frame"), this.translate("type.sprite.frame"), this.translate("type.sprite.init"), this.translate("type.button.event"), this.translate("type.instance.event"), this.translate("type.class")});
        this.typeComboBox.addActionListener(this::typeChangedActionPerformed);
        typeLabel.setLabelFor(this.typeComboBox);
        this.topPanel.add(typeLabel);
        this.topPanel.add(this.typeComboBox);
        cnt.add((Component)this.topPanel, "North");
        DocumentListener checkEnabledDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddScriptDialog.this.updateFrames();
                AddScriptDialog.this.checkEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddScriptDialog.this.updateFrames();
                AddScriptDialog.this.checkEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddScriptDialog.this.updateFrames();
                AddScriptDialog.this.checkEnabled();
            }
        };
        this.centerPanel = new JPanel(new CardLayout());
        this.centerPanel.add((Component)this.createFramePanel(checkEnabledDocumentListener), "0");
        this.centerPanel.add((Component)this.createSpriteFramePanel(checkEnabledDocumentListener), "1");
        this.centerPanel.add((Component)this.createSpriteInitPanel(), "2");
        this.centerPanel.add((Component)this.createButtonPanel(), "3");
        this.centerPanel.add((Component)this.createInstancePanel(), "4");
        this.classPanel = this.createClassPanel();
        this.centerPanel.add((Component)this.classPanel, "5");
        cnt.add((Component)this.centerPanel, "Center");
        cnt.add((Component)panButtons, "South");
        this.setSize(900, 600);
        this.setModal(true);
        this.setResizable(true);
        View.setWindowIcon(this, "scriptadd");
        View.centerScreen(this);
        this.checkEnabled();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (AddScriptDialog.this.createClassSet) {
                    AddScriptDialog.this.classNameTextField.requestFocusInWindow();
                }
            }
        });
    }

    public void setCreateClassOnly(String prefillClassName) {
        this.setTitle(this.translate("dialog.title.combined").replace("%title%", this.translate("dialog.title")).replace("%type%", this.translate("type.class")));
        this.typeComboBox.setSelectedIndex(5);
        this.centerPanel.removeAll();
        this.centerPanel.add((Component)this.classPanel, "5");
        ((CardLayout)this.centerPanel.getLayout()).show(this.centerPanel, "5");
        this.topPanel.setVisible(false);
        this.pack();
        this.classNameTextField.setText(prefillClassName);
        this.classNameTextField.setSelectionStart(prefillClassName.length());
        this.createClassSet = true;
        this.checkEnabled();
        View.centerScreen(this);
    }

    private JPanel createFramePanel(DocumentListener checkEnabledDocumentListener) {
        JPanel frameNumPanel = new JPanel(new FlowLayout(0));
        JLabel frameLabel = new JLabel(this.translate("framenum"));
        this.frameTextField = new JTextField(4);
        this.frameTextField.addActionListener(this::okButtonActionPerformed);
        this.frameTextField.getDocument().addDocumentListener(checkEnabledDocumentListener);
        frameLabel.setLabelFor(this.frameTextField);
        frameNumPanel.add(frameLabel);
        frameNumPanel.add(this.frameTextField);
        ArrayList<MyFrame> frames = new ArrayList<MyFrame>();
        int f = 1;
        boolean hasScript = false;
        for (Tag t : this.swf.getTags()) {
            if (t instanceof DoActionTag) {
                // empty if block
            }
            if (!(t instanceof ShowFrameTag)) continue;
            MyFrame myf = new MyFrame(f);
            myf.setInvalid(hasScript);
            frames.add(myf);
            ++f;
            hasScript = false;
        }
        MyFrame[] framesArr = frames.toArray(new MyFrame[frames.size()]);
        this.frameList = new JList<MyFrame>(framesArr);
        final ImageIcon frameIcon = View.getIcon("frame16");
        final ImageIcon frameInvalidIcon = View.getIcon("frameinvalid16");
        if (View.isOceanic()) {
            this.frameList.setBackground(Color.white);
        }
        this.frameList.setCellRenderer(new DefaultListCellRenderer(this){
            final /* synthetic */ AddScriptDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (renderer instanceof JLabel) {
                    if (((MyFrame)value).isInvalid()) {
                        ((JLabel)renderer).setIcon(frameInvalidIcon);
                    } else {
                        ((JLabel)renderer).setIcon(frameIcon);
                    }
                }
                return renderer;
            }
        });
        this.frameList.addListSelectionListener(this::frameValueChanged);
        this.frameList.getSelectionModel().setSelectionMode(0);
        this.framePreviewPanel = new PreviewPanel(Main.getMainFrame().getPanel());
        this.framePreviewPanel.setReadOnly(true);
        this.framePreviewPanel.setPreferredSize(new Dimension(300, 1));
        this.framePreviewPanel.showEmpty();
        JPanel framePanel = new JPanel(new BorderLayout());
        FasterScrollPane frameListScrollPane = new FasterScrollPane(this.frameList);
        frameListScrollPane.setMinimumSize(new Dimension(400, 1));
        JSplitPane frameSplitPane = new JSplitPane(1, frameListScrollPane, this.framePreviewPanel);
        frameSplitPane.setDividerLocation(400);
        framePanel.add((Component)frameSplitPane, "Center");
        framePanel.add((Component)frameNumPanel, "North");
        return framePanel;
    }

    private void populateSpriteNodes(MyTreeNode root, Timelined tim) {
        for (Tag t : tim.getTags()) {
            if (!(t instanceof DefineSpriteTag)) continue;
            MyTreeNode sprite = new MyTreeNode();
            sprite.setParent(root);
            sprite.setData(t);
            DefineSpriteTag s = (DefineSpriteTag)t;
            int f = 1;
            boolean hasScript = false;
            for (Tag t2 : s.getTags()) {
                if (t2 instanceof DoActionTag) {
                    // empty if block
                }
                if (!(t2 instanceof ShowFrameTag)) continue;
                MyTreeNode frameNode = new MyTreeNode();
                MyFrame myf = new MyFrame(f);
                myf.setInvalid(hasScript);
                frameNode.setData(myf);
                frameNode.setParent(sprite);
                sprite.addChild(frameNode);
                ++f;
                hasScript = false;
            }
            if (sprite.getChildCount() <= 0) continue;
            root.addChild(sprite);
        }
    }

    private JPanel createSpriteInitPanel() {
        this.spriteInitPreviewPanel = new PreviewPanel(Main.getMainFrame().getPanel());
        this.spriteInitPreviewPanel.setReadOnly(true);
        this.spriteInitPreviewPanel.setPreferredSize(new Dimension(300, 1));
        this.spriteInitPreviewPanel.showEmpty();
        this.spriteInitPreviewPanel.setParametersPanelVisible(false);
        ArrayList<DefineSpriteTag> sprites = new ArrayList<DefineSpriteTag>();
        ReadOnlyTagList tags = this.swf.getTags();
        this.spriteIdsWithDoInitAction = new ArrayList<Integer>();
        for (Tag t : tags) {
            if (t instanceof DoInitActionTag) {
                this.spriteIdsWithDoInitAction.add(((DoInitActionTag)t).spriteId);
            }
            if (!(t instanceof DefineSpriteTag)) continue;
            sprites.add((DefineSpriteTag)t);
        }
        this.spriteInitList = new JList<DefineSpriteTag>(sprites.toArray(new DefineSpriteTag[sprites.size()]));
        final ImageIcon spriteIcon = View.getIcon("sprite16");
        final ImageIcon spriteInvalidIcon = View.getIcon("spriteinvalid16");
        if (View.isOceanic()) {
            this.spriteInitList.setBackground(Color.white);
        }
        this.spriteInitList.setCellRenderer(new DefaultListCellRenderer(this){
            final /* synthetic */ AddScriptDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (renderer instanceof JLabel) {
                    if (this.this$0.spriteIdsWithDoInitAction.contains(((DefineSpriteTag)value).spriteId)) {
                        ((JLabel)renderer).setIcon(spriteInvalidIcon);
                    } else {
                        ((JLabel)renderer).setIcon(spriteIcon);
                    }
                }
                return renderer;
            }
        });
        this.spriteInitList.addListSelectionListener(this::spriteInitValueChanged);
        FasterScrollPane spriteInitListScrollPane = new FasterScrollPane(this.spriteInitList);
        JSplitPane spriteInitSplitPane = new JSplitPane(1, spriteInitListScrollPane, this.spriteInitPreviewPanel);
        spriteInitSplitPane.setDividerLocation(400);
        JPanel spriteInitPanel = new JPanel(new BorderLayout());
        spriteInitPanel.add((Component)spriteInitSplitPane, "Center");
        return spriteInitPanel;
    }

    private JPanel createSpriteFramePanel(DocumentListener documentListener) {
        JPanel spriteFramePanel = new JPanel(new BorderLayout());
        JLabel spriteFrameLabel = new JLabel(this.translate("framenum"));
        this.spriteFrameTextField = new JTextField(4);
        this.spriteFrameTextField.addActionListener(this::okButtonActionPerformed);
        this.spriteFrameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AddScriptDialog.this.checkEnabled();
            }
        });
        this.spriteFrameTextField.getDocument().addDocumentListener(documentListener);
        MyTreeNode root = new MyTreeNode();
        root.setData("root");
        this.populateSpriteNodes(root, (Timelined)this.swf);
        this.spriteFrameTree = new JTree(root);
        final ImageIcon spriteIcon = View.getIcon("sprite16");
        final ImageIcon frameIcon = View.getIcon("frame16");
        final ImageIcon frameInvalidIcon = View.getIcon("frameinvalid16");
        this.spriteFrameTree.setCellRenderer(new DefaultTreeCellRenderer(this){
            final /* synthetic */ AddScriptDialog this$0;
            {
                this.this$0 = this$0;
                if (View.isOceanic()) {
                    this.setUI(new BasicLabelUI());
                    this.setOpaque(false);
                    this.setBackgroundNonSelectionColor(Color.white);
                }
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component renderer = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (renderer instanceof JLabel) {
                    JLabel lab = (JLabel)renderer;
                    Object subValue = value;
                    if (value instanceof MyTreeNode) {
                        subValue = ((MyTreeNode)value).getData();
                    }
                    if (subValue instanceof DefineSpriteTag) {
                        lab.setIcon(spriteIcon);
                    } else if (subValue instanceof MyFrame) {
                        if (((MyFrame)subValue).isInvalid()) {
                            lab.setIcon(frameInvalidIcon);
                        } else {
                            lab.setIcon(frameIcon);
                        }
                    }
                }
                return renderer;
            }
        });
        if (View.isOceanic()) {
            this.spriteFrameTree.setBackground(Color.white);
        }
        this.spriteFrameTree.setRootVisible(false);
        this.spriteFrameTree.setShowsRootHandles(true);
        this.spriteFrameTree.getSelectionModel().setSelectionMode(1);
        this.spriteFrameTree.addTreeSelectionListener(this::spriteValueChanged);
        spriteFrameLabel.setLabelFor(this.spriteFrameTextField);
        JPanel spriteFrameTopPanel = new JPanel(new FlowLayout(0));
        spriteFrameTopPanel.add(spriteFrameLabel);
        spriteFrameTopPanel.add(this.spriteFrameTextField);
        spriteFramePanel.add((Component)spriteFrameTopPanel, "North");
        this.spriteFramePreviewPanel = new PreviewPanel(Main.getMainFrame().getPanel());
        this.spriteFramePreviewPanel.setReadOnly(true);
        this.spriteFramePreviewPanel.setPreferredSize(new Dimension(300, 1));
        this.spriteFramePreviewPanel.showEmpty();
        this.spriteFramePreviewPanel.setParametersPanelVisible(false);
        FasterScrollPane spriteFrameTreeScrollPane = new FasterScrollPane(this.spriteFrameTree);
        JSplitPane spriteFrameSplitPane = new JSplitPane(1, spriteFrameTreeScrollPane, this.spriteFramePreviewPanel);
        spriteFrameSplitPane.setDividerLocation(400);
        spriteFramePanel.add((Component)spriteFrameSplitPane, "Center");
        return spriteFramePanel;
    }

    private JPanel createButtonPanel() {
        ArrayList<DefineButton2Tag> buttons = new ArrayList<DefineButton2Tag>();
        for (Tag t : this.swf.getTags()) {
            if (!(t instanceof DefineButton2Tag)) continue;
            buttons.add((DefineButton2Tag)t);
        }
        this.buttonList = new JList<DefineButton2Tag>(buttons.toArray(new DefineButton2Tag[buttons.size()]));
        final ImageIcon buttonIcon = View.getIcon("button16");
        if (View.isOceanic()) {
            this.buttonList.setBackground(Color.white);
        }
        this.buttonList.setCellRenderer(new DefaultListCellRenderer(this){
            final /* synthetic */ AddScriptDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (renderer instanceof JLabel) {
                    ((JLabel)renderer).setIcon(buttonIcon);
                }
                return renderer;
            }
        });
        this.buttonList.addListSelectionListener(this::buttonValueChanged);
        this.buttonList.getSelectionModel().setSelectionMode(0);
        this.buttonPreviewPanel = new PreviewPanel(Main.getMainFrame().getPanel());
        this.buttonPreviewPanel.setReadOnly(true);
        this.buttonPreviewPanel.setPreferredSize(new Dimension(300, 1));
        this.buttonPreviewPanel.showEmpty();
        JPanel buttonPanel = new JPanel(new BorderLayout());
        FasterScrollPane buttonListScrollPane = new FasterScrollPane(this.buttonList);
        buttonListScrollPane.setMinimumSize(new Dimension(400, 1));
        JSplitPane buttonSplitPane = new JSplitPane(1, buttonListScrollPane, this.buttonPreviewPanel);
        buttonSplitPane.setDividerLocation(400);
        buttonPanel.add((Component)buttonSplitPane, "Center");
        return buttonPanel;
    }

    private void populateInstanceNodes(MyTreeNode root, Timelined tim) {
        int f = 1;
        ArrayList<MyTreeNode> currentFramePlaces = new ArrayList<MyTreeNode>();
        for (Tag t : tim.getTags()) {
            if (!(t instanceof DefineSpriteTag)) continue;
            MyTreeNode sprite = new MyTreeNode();
            sprite.setParent(root);
            sprite.setData(t);
            this.populateInstanceNodes(sprite, (Timelined)((DefineSpriteTag)t));
            if (sprite.getChildCount() <= 0) continue;
            root.addChild(sprite);
        }
        for (Tag t : tim.getTags()) {
            if (t instanceof ShowFrameTag) {
                if (!currentFramePlaces.isEmpty()) {
                    MyTreeNode frameNode = new MyTreeNode();
                    frameNode.setData(new MyFrame(f));
                    frameNode.setParent(root);
                    for (MyTreeNode p : currentFramePlaces) {
                        p.setParent(frameNode);
                        frameNode.addChild(p);
                    }
                    root.addChild(frameNode);
                    currentFramePlaces.clear();
                }
                ++f;
            }
            if (!(t instanceof PlaceObjectTypeTag)) continue;
            MyTreeNode place = new MyTreeNode();
            place.setData(t);
            currentFramePlaces.add(place);
        }
    }

    private JPanel createInstancePanel() {
        MyTreeNode root = new MyTreeNode();
        root.setData("root");
        this.populateInstanceNodes(root, (Timelined)this.swf);
        this.instanceTree = new JTree(root);
        this.instanceTree.setRootVisible(false);
        this.instanceTree.setShowsRootHandles(true);
        this.instanceTree.getSelectionModel().setSelectionMode(1);
        final ImageIcon placeIcon = View.getIcon("placeobject16");
        final ImageIcon spriteIcon = View.getIcon("sprite16");
        final ImageIcon frameIcon = View.getIcon("frame16");
        this.instanceTree.setCellRenderer(new DefaultTreeCellRenderer(this){
            final /* synthetic */ AddScriptDialog this$0;
            {
                this.this$0 = this$0;
                if (View.isOceanic()) {
                    this.setUI(new BasicLabelUI());
                    this.setOpaque(false);
                    this.setBackgroundNonSelectionColor(Color.white);
                }
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component renderer = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (renderer instanceof JLabel) {
                    JLabel lab = (JLabel)renderer;
                    Object subValue = value;
                    if (value instanceof MyTreeNode) {
                        subValue = ((MyTreeNode)value).getData();
                    }
                    if (subValue instanceof PlaceObjectTypeTag) {
                        lab.setIcon(placeIcon);
                    } else if (subValue instanceof DefineSpriteTag) {
                        lab.setIcon(spriteIcon);
                    } else if (subValue instanceof MyFrame) {
                        lab.setIcon(frameIcon);
                    }
                }
                return renderer;
            }
        });
        this.instanceTree.addTreeSelectionListener(this::instanceValueChanged);
        if (View.isOceanic()) {
            this.instanceTree.setBackground(Color.white);
        }
        this.instancePreviewPanel = new PreviewPanel(Main.getMainFrame().getPanel());
        this.instancePreviewPanel.setReadOnly(true);
        this.instancePreviewPanel.setPreferredSize(new Dimension(300, 1));
        this.instancePreviewPanel.showEmpty();
        this.instancePreviewPanel.setParametersPanelVisible(false);
        JPanel instancePanel = new JPanel(new BorderLayout());
        FasterScrollPane instanceTreeScrollPane = new FasterScrollPane(this.instanceTree);
        instanceTreeScrollPane.setMinimumSize(new Dimension(400, 1));
        JSplitPane instanceSplitPane = new JSplitPane(1, instanceTreeScrollPane, this.instancePreviewPanel);
        instanceSplitPane.setDividerLocation(400);
        instancePanel.add((Component)instanceSplitPane, "Center");
        return instancePanel;
    }

    private JPanel createClassPanel() {
        JPanel classPanel = new JPanel();
        classPanel.setLayout(new BoxLayout(classPanel, 1));
        JPanel classCenterPanel = new JPanel(new FlowLayout());
        JLabel classNameLabel = new JLabel(this.translate("classname"));
        this.classNameTextField = new JTextField(40);
        this.classNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddScriptDialog.this.checkEnabled();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddScriptDialog.this.checkEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddScriptDialog.this.checkEnabled();
            }
        });
        this.classNameTextField.addActionListener(this::okButtonActionPerformed);
        classNameLabel.setLabelFor(this.classNameTextField);
        classCenterPanel.add(classNameLabel);
        classCenterPanel.add(this.classNameTextField);
        classPanel.add(Box.createVerticalGlue());
        classPanel.add(classCenterPanel);
        classPanel.add(Box.createVerticalGlue());
        return classPanel;
    }

    private void instanceValueChanged(TreeSelectionEvent e) {
        TreePath selection = this.instanceTree.getSelectionPath();
        if (selection == null) {
            this.instancePreviewPanel.showEmpty();
            this.checkEnabled();
            return;
        }
        MyTreeNode tnode = (MyTreeNode)selection.getLastPathComponent();
        if (tnode.getData() instanceof PlaceObjectTypeTag) {
            PlaceObjectTypeTag place = (PlaceObjectTypeTag)tnode.getData();
            this.instancePreviewPanel.selectImageDepth(place.getDepth());
            int f = ((MyFrame)((MyTreeNode)tnode.getParent()).getData()).frame;
            Object parent = ((MyTreeNode)tnode.getParent().getParent()).getData();
            if (parent instanceof DefineSpriteTag) {
                this.instancePreviewPanel.showImagePanel((Timelined)((DefineSpriteTag)parent), this.swf, f - 1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
            } else {
                this.instancePreviewPanel.showImagePanel((Timelined)this.swf, this.swf, f - 1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
            }
        } else if (tnode.getData() instanceof DefineSpriteTag) {
            this.instancePreviewPanel.selectImageDepth(-1);
            this.instancePreviewPanel.showImagePanel((Timelined)((DefineSpriteTag)tnode.getData()), this.swf, -1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
        } else if (tnode.getData() instanceof MyFrame) {
            this.instancePreviewPanel.selectImageDepth(-1);
            int f = ((MyFrame)tnode.getData()).frame;
            Object parent = ((MyTreeNode)tnode.getParent()).getData();
            if (parent instanceof DefineSpriteTag) {
                this.instancePreviewPanel.showImagePanel((Timelined)((DefineSpriteTag)parent), this.swf, f - 1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
            } else {
                this.instancePreviewPanel.showImagePanel((Timelined)this.swf, this.swf, f - 1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
            }
        }
        this.checkEnabled();
    }

    private void spriteInitValueChanged(ListSelectionEvent e) {
        this.spriteInitPreviewPanel.showEmpty();
        int selectedIndex = this.spriteInitList.getSelectedIndex();
        if (selectedIndex == -1) {
            this.spriteInitPreviewPanel.showEmpty();
            this.checkEnabled();
            return;
        }
        this.spriteInitPreviewPanel.showImagePanel((Timelined)this.spriteInitList.getSelectedValue(), this.swf, -1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
        this.checkEnabled();
    }

    private void frameValueChanged(ListSelectionEvent e) {
        this.framePreviewPanel.showEmpty();
        int selectedIndex = this.frameList.getSelectedIndex();
        if (selectedIndex == -1) {
            this.framePreviewPanel.showEmpty();
            this.checkEnabled();
            return;
        }
        this.framePreviewPanel.showImagePanel((Timelined)this.swf, this.swf, selectedIndex, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
        int f = selectedIndex + 1;
        if (!this.frameTextField.getText().equals("" + f)) {
            this.frameTextField.setText("" + f);
        }
        this.checkEnabled();
    }

    private void buttonValueChanged(ListSelectionEvent e) {
        this.buttonPreviewPanel.showEmpty();
        if (this.buttonList.getSelectedIndex() >= 0) {
            this.buttonPreviewPanel.showImagePanel(TimelinedMaker.makeTimelined((Tag)this.buttonList.getSelectedValue()), this.swf, -1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
        }
        this.checkEnabled();
    }

    private void spriteValueChanged(TreeSelectionEvent e) {
        TreePath selection = this.spriteFrameTree.getSelectionPath();
        if (selection == null) {
            this.spriteFramePreviewPanel.showEmpty();
            this.checkEnabled();
            return;
        }
        MyTreeNode tnode = (MyTreeNode)selection.getLastPathComponent();
        if (tnode.getData() instanceof DefineSpriteTag) {
            this.spriteFramePreviewPanel.showImagePanel((Timelined)((DefineSpriteTag)tnode.getData()), this.swf, -1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
        } else if (tnode.getData() instanceof MyFrame) {
            int f = ((MyFrame)tnode.getData()).frame;
            Object parent = ((MyTreeNode)tnode.getParent()).getData();
            if (parent instanceof DefineSpriteTag) {
                this.spriteFramePreviewPanel.showImagePanel((Timelined)((DefineSpriteTag)parent), this.swf, f - 1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
            } else {
                this.spriteFramePreviewPanel.showImagePanel((Timelined)this.swf, this.swf, f - 1, true, (Boolean)Configuration.autoPlayPreviews.get(), (Boolean)Configuration.animateSubsprites.get() == false, false, (Boolean)Configuration.playFrameSounds.get() == false, true, false, true, false, false);
            }
            if (!this.spriteFrameTextField.getText().equals("" + f)) {
                this.spriteFrameTextField.setText("" + f);
            }
        }
        this.checkEnabled();
    }

    private void typeChangedActionPerformed(ActionEvent evt) {
        int selectedType = ((JComboBox)evt.getSource()).getSelectedIndex();
        ((CardLayout)this.centerPanel.getLayout()).show(this.centerPanel, "" + selectedType);
        this.checkEnabled();
    }

    private void updateFrames() {
        TreePath selection;
        int type = this.typeComboBox.getSelectedIndex();
        if (type == 0) {
            int f = -1;
            boolean invalid = false;
            try {
                f = Integer.parseInt(this.frameTextField.getText());
                if (f <= 0) {
                    invalid = true;
                }
            }
            catch (NumberFormatException nfe) {
                invalid = true;
            }
            if (!invalid) {
                if (f > this.frameList.getModel().getSize()) {
                    this.frameList.setSelectedIndices(new int[0]);
                } else {
                    this.frameList.setSelectedIndex(f - 1);
                    this.frameList.ensureIndexIsVisible(f - 1);
                }
            }
        }
        if (type == 1 && (selection = this.spriteFrameTree.getSelectionPath()) != null) {
            int f = -1;
            boolean invalid = false;
            try {
                f = Integer.parseInt(this.spriteFrameTextField.getText());
                if (f <= 0) {
                    invalid = true;
                }
            }
            catch (NumberFormatException nfe) {
                invalid = true;
            }
            if (invalid) {
                return;
            }
            MyTreeNode node = (MyTreeNode)selection.getLastPathComponent();
            if (node.getData() instanceof MyFrame) {
                node = (MyTreeNode)node.getParent();
                TreePath spritePath = selection.getParentPath();
                if (this.spriteFrameTree.isExpanded(spritePath)) {
                    boolean found = false;
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        if (((MyFrame)((MyTreeNode)node.getChildAt(i)).data).frame != f) continue;
                        TreePath framePath = spritePath.pathByAddingChild(node.getChildAt(i));
                        this.spriteFrameTree.setSelectionPath(framePath);
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.spriteFrameTree.setSelectionPath(spritePath);
                    }
                }
            }
        }
    }

    private void checkEnabled() {
        this.okButton.setEnabled(true);
        int type = this.typeComboBox.getSelectedIndex();
        if (type == 1) {
            boolean invalid = false;
            try {
                this.frame = Integer.parseInt(this.spriteFrameTextField.getText());
                if (this.frame <= 0) {
                    invalid = true;
                }
            }
            catch (NumberFormatException nfe) {
                invalid = true;
            }
            if (invalid) {
                this.okButton.setEnabled(false);
            }
            if (this.spriteFrameTree.getSelectionPath() == null) {
                this.okButton.setEnabled(false);
            } else {
                MyTreeNode node = (MyTreeNode)this.spriteFrameTree.getSelectionPath().getLastPathComponent();
                if (node.getData() instanceof MyFrame && ((MyFrame)node.getData()).isInvalid()) {
                    this.okButton.setEnabled(false);
                }
            }
        }
        if (type == 2) {
            DefineSpriteTag sprite = this.spriteInitList.getSelectedValue();
            if (sprite == null) {
                this.okButton.setEnabled(false);
            } else if (this.spriteIdsWithDoInitAction.contains(sprite.spriteId)) {
                this.okButton.setEnabled(false);
            }
        }
        if (type == 0) {
            boolean invalid = false;
            try {
                this.frame = Integer.parseInt(this.frameTextField.getText());
                if (this.frame <= 0) {
                    invalid = true;
                }
            }
            catch (NumberFormatException nfe) {
                invalid = true;
            }
            if (invalid) {
                this.okButton.setEnabled(false);
            } else {
                MyFrame myf = this.frameList.getSelectedValue();
                if (myf != null && myf.isInvalid()) {
                    this.okButton.setEnabled(false);
                }
            }
        }
        if (type == 3 && this.buttonList.getSelectedIndex() < 0) {
            this.okButton.setEnabled(false);
        }
        if (type == 4) {
            TreePath selection = this.instanceTree.getSelectionPath();
            if (selection == null) {
                this.okButton.setEnabled(false);
                return;
            }
            MyTreeNode tnode = (MyTreeNode)selection.getLastPathComponent();
            this.okButton.setEnabled(false);
            if (tnode.getData() instanceof PlaceObjectTypeTag) {
                this.okButton.setEnabled(true);
            }
        }
        if (type == 5) {
            if (this.classNameTextField.getText().trim().endsWith(".")) {
                this.okButton.setEnabled(false);
            }
            if (this.classNameTextField.getText().trim().isEmpty()) {
                this.okButton.setEnabled(false);
            }
            if (this.existingClasses.contains(this.classNameTextField.getText().trim())) {
                this.okButton.setEnabled(false);
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int type = this.getScriptType();
        this.frame = -1;
        if (type == 0) {
            this.frame = Integer.parseInt(this.frameTextField.getText());
        } else if (type == 1) {
            this.frame = Integer.parseInt(this.spriteFrameTextField.getText());
        } else if (type == 4) {
            MyTreeNode placeNode = (MyTreeNode)this.instanceTree.getSelectionPath().getLastPathComponent();
            this.frame = ((MyFrame)((MyTreeNode)placeNode.getParent()).getData()).frame;
        }
        this.result = 0;
        this.setVisible(false);
    }

    public int getFrame() {
        return this.frame;
    }

    public String getClassName() {
        if (this.getScriptType() == 5) {
            return this.classNameTextField.getText().trim();
        }
        return null;
    }

    public int getScriptType() {
        return this.typeComboBox.getSelectedIndex();
    }

    public DefineSpriteTag getSprite() {
        if (this.getScriptType() == 1) {
            MyTreeNode tnode = (MyTreeNode)this.spriteFrameTree.getSelectionPath().getLastPathComponent();
            if (tnode.getData() instanceof DefineSpriteTag) {
                return (DefineSpriteTag)tnode.getData();
            }
            return (DefineSpriteTag)((MyTreeNode)tnode.parent).getData();
        }
        if (this.getScriptType() == 4) {
            MyTreeNode tnode = (MyTreeNode)this.instanceTree.getSelectionPath().getLastPathComponent();
            Object parent = ((MyTreeNode)tnode.getParent().getParent()).getData();
            if (parent instanceof DefineSpriteTag) {
                return (DefineSpriteTag)parent;
            }
            return null;
        }
        if (this.getScriptType() == 2) {
            return this.spriteInitList.getSelectedValue();
        }
        return null;
    }

    public PlaceObjectTypeTag getPlaceObject() {
        if (this.getScriptType() == 4) {
            return (PlaceObjectTypeTag)((MyTreeNode)this.instanceTree.getSelectionPath().getLastPathComponent()).getData();
        }
        return null;
    }

    public DefineButton2Tag getButton() {
        if (this.getScriptType() == 3) {
            return this.buttonList.getSelectedValue();
        }
        return null;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }

    private static class MyFrame {
        private final int frame;
        private boolean invalid;

        public MyFrame(int frame) {
            this.frame = frame;
        }

        public int getFrame() {
            return this.frame;
        }

        public void setInvalid(boolean invalid) {
            this.invalid = invalid;
        }

        public boolean isInvalid() {
            return this.invalid;
        }

        public String toString() {
            return "frame " + this.frame;
        }
    }

    private static class MyTreeNode
    implements TreeNode {
        private final List<TreeNode> children = new ArrayList<TreeNode>();
        private TreeNode parent;
        private Object data;

        private MyTreeNode() {
        }

        public String toString() {
            return this.data.toString();
        }

        public void setData(Object data) {
            this.data = data;
        }

        public Object getData() {
            return this.data;
        }

        public void addChild(TreeNode node) {
            this.children.add(node);
        }

        public void setParent(TreeNode parent) {
            this.parent = parent;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.children.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        @Override
        public Enumeration<? extends TreeNode> children() {
            return Collections.enumeration(this.children);
        }
    }
}

