/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.colordialog;

import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.colordialog.MyRecentSwatchPanel;
import com.jpexs.decompiler.flash.gui.colordialog.MySwatchChooserPanel;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class MyColorChooserDialog
extends JDialog {
    private JColorChooser chooserPane;
    private MyRecentSwatchPanel recentSwatchPanel;
    private Color color = null;

    public MyColorChooserDialog(Component parentComponent, final Color initialColor, boolean colorTransparencySelectionEnabled) {
        boolean supportsWindowDecorations;
        this.setTitle(AppStrings.translate("com.jpexs.decompiler.flash.gui.locales.ColorChooserDialog", "dialog.title"));
        JColorChooser chooser = new JColorChooser(initialColor);
        ArrayList<AbstractColorChooserPanel> choosers = new ArrayList<AbstractColorChooserPanel>(Arrays.asList(chooser.getChooserPanels()));
        choosers.set(0, new MySwatchChooserPanel());
        if (!colorTransparencySelectionEnabled) {
            if (Helper.getJavaVersion() >= 9) {
                for (AbstractColorChooserPanel ccPanel : choosers) {
                    try {
                        Method m = AbstractColorChooserPanel.class.getDeclaredMethod("setColorTransparencySelectionEnabled", Boolean.TYPE);
                        m.invoke((Object)ccPanel, colorTransparencySelectionEnabled);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
                }
            } else {
                for (int i = 1; i < choosers.size(); ++i) {
                    AbstractColorChooserPanel cp = (AbstractColorChooserPanel)choosers.get(i);
                    try {
                        Field f = cp.getClass().getDeclaredField("panel");
                        f.setAccessible(true);
                        Object colorPanel = f.get(cp);
                        Field f2 = colorPanel.getClass().getDeclaredField("spinners");
                        f2.setAccessible(true);
                        Object spinners = f2.get(colorPanel);
                        Object transpSlispinner = Array.get(spinners, 3);
                        if (i == choosers.size() - 1) {
                            transpSlispinner = Array.get(spinners, 4);
                        }
                        Field f3 = transpSlispinner.getClass().getDeclaredField("slider");
                        f3.setAccessible(true);
                        JSlider slider = (JSlider)f3.get(transpSlispinner);
                        slider.setEnabled(false);
                        Field f4 = transpSlispinner.getClass().getDeclaredField("spinner");
                        f4.setAccessible(true);
                        JSpinner spinner = (JSpinner)f4.get(transpSlispinner);
                        spinner.setEnabled(false);
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException colorPanel) {
                        // empty catch block
                    }
                }
            }
        }
        chooser.setChooserPanels(choosers.toArray(new AbstractColorChooserPanel[0]));
        this.chooserPane = chooser;
        Locale locale = this.getLocale();
        String okString = UIManager.getString((Object)"ColorChooser.okText", locale);
        String cancelString = UIManager.getString((Object)"ColorChooser.cancelText", locale);
        String resetString = UIManager.getString((Object)"ColorChooser.resetText", locale);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.chooserPane, "Center");
        this.recentSwatchPanel = new MyRecentSwatchPanel();
        RecentSwatchListener recentSwatchListener = new RecentSwatchListener();
        RecentSwatchKeyListener recentSwatchKeyListener = new RecentSwatchKeyListener();
        this.recentSwatchPanel.addMouseListener(recentSwatchListener);
        this.recentSwatchPanel.addKeyListener(recentSwatchKeyListener);
        JLabel recentLabel = new JLabel(UIManager.getString((Object)"ColorChooser.swatchesRecentText", this.getLocale()));
        JButton recentAddButton = new JButton(AppStrings.translate("com.jpexs.decompiler.flash.gui.locales.ColorChooserDialog", "recent.add"));
        recentAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyColorChooserDialog.this.recentSwatchPanel.setMostRecentColor(MyColorChooserDialog.this.chooserPane.getColor());
            }
        });
        this.recentSwatchPanel.setMaximumSize(this.recentSwatchPanel.getPreferredSize());
        recentLabel.setAlignmentX(0.5f);
        this.recentSwatchPanel.setAlignmentX(0.5f);
        recentAddButton.setAlignmentX(0.5f);
        JPanel recentPanel = new JPanel();
        recentPanel.setLayout(new BoxLayout(recentPanel, 1));
        recentPanel.add(Box.createVerticalStrut(20));
        recentPanel.add(recentLabel);
        recentPanel.add(this.recentSwatchPanel);
        recentPanel.add(Box.createVerticalStrut(5));
        recentPanel.add(recentAddButton);
        recentPanel.add(Box.createVerticalGlue());
        recentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)recentPanel, "East");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        JButton okButton = new JButton(okString);
        this.getRootPane().setDefaultButton(okButton);
        okButton.getAccessibleContext().setAccessibleDescription(okString);
        okButton.setActionCommand("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyColorChooserDialog.this.color = MyColorChooserDialog.this.chooserPane.getColor();
                MyColorChooserDialog.this.recentSwatchPanel.setMostRecentColor(MyColorChooserDialog.this.color);
                MyColorChooserDialog.this.setVisible(false);
            }
        });
        buttonPane.add(okButton);
        JButton cancelButton = new JButton(cancelString);
        cancelButton.getAccessibleContext().setAccessibleDescription(cancelString);
        AbstractAction cancelKeyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyColorChooserDialog.this.setVisible(false);
            }
        };
        KeyStroke cancelKeyStroke = KeyStroke.getKeyStroke(27, 0);
        InputMap inputMap = cancelButton.getInputMap(2);
        ActionMap actionMap = cancelButton.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(cancelKeyStroke, "cancel");
            actionMap.put("cancel", cancelKeyAction);
        }
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyColorChooserDialog.this.setVisible(false);
            }
        });
        buttonPane.add(cancelButton);
        JButton resetButton = new JButton(resetString);
        resetButton.getAccessibleContext().setAccessibleDescription(resetString);
        resetButton.addActionListener(new ActionListener(){
            final /* synthetic */ MyColorChooserDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.chooserPane.setColor(initialColor);
            }
        });
        Object mnemonic = UIManager.get("ColorChooser.resetMnemonic", locale);
        if (mnemonic instanceof Integer) {
            resetButton.setMnemonic((Integer)mnemonic);
        }
        buttonPane.add(resetButton);
        contentPane.add((Component)buttonPane, "South");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.getRootPane().setWindowDecorationStyle(5);
        }
        this.applyComponentOrientation((parentComponent == null ? this.getRootPane() : parentComponent).getComponentOrientation());
        this.pack();
        this.setLocationRelativeTo(parentComponent);
        this.setDefaultCloseOperation(1);
        this.setModal(true);
    }

    public Color getColor() {
        return this.color;
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (MyColorChooserDialog.this.isEnabled()) {
                Color color = MyColorChooserDialog.this.recentSwatchPanel.getColorForLocation(e.getX(), e.getY());
                MyColorChooserDialog.this.recentSwatchPanel.setSelectedColorFromLocation(e.getX(), e.getY());
                MyColorChooserDialog.this.chooserPane.setColor(color);
                MyColorChooserDialog.this.recentSwatchPanel.requestFocusInWindow();
            }
        }
    }

    private class RecentSwatchKeyListener
    extends KeyAdapter {
        private RecentSwatchKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (32 == e.getKeyCode()) {
                Color color = MyColorChooserDialog.this.recentSwatchPanel.getSelectedColor();
                MyColorChooserDialog.this.chooserPane.setColor(color);
            }
        }
    }
}

