/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.colordialog;

import com.jpexs.decompiler.flash.gui.colordialog.MainSwatchPanel;
import com.jpexs.decompiler.flash.gui.colordialog.MySwatchPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;

public class MySwatchChooserPanel
extends AbstractColorChooserPanel {
    MySwatchPanel swatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    private KeyListener mainSwatchKeyListener;
    private KeyListener recentSwatchKeyListener;

    public MySwatchChooserPanel() {
        this.setInheritsPopupMenu(true);
    }

    void setSelectedColor(Color color) {
        ColorSelectionModel model = this.getColorSelectionModel();
        if (model != null) {
            model.setSelectedColor(color);
        }
    }

    int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key, this.getLocale());
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString((Object)"ColorChooser.swatchesNameText", this.getLocale());
    }

    @Override
    public int getMnemonic() {
        return this.getInt("ColorChooser.swatchesMnemonic", -1);
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return this.getInt("ColorChooser.swatchesDisplayedMnemonicIndex", -1);
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        String recentStr = UIManager.getString((Object)"ColorChooser.swatchesRecentText", this.getLocale());
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel superHolder = new JPanel(gb);
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.putClientProperty("AccessibleName", this.getDisplayName());
        this.swatchPanel.setInheritsPopupMenu(true);
        this.mainSwatchKeyListener = new MainSwatchKeyListener();
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.swatchPanel.addKeyListener(this.mainSwatchKeyListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchKeyListener = new RecentSwatchKeyListener();
        JPanel mainHolder = new JPanel(new BorderLayout());
        CompoundBorder border = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        mainHolder.setBorder(border);
        mainHolder.add((Component)this.swatchPanel, "Center");
        gbc.anchor = 25;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        Insets oldInsets = gbc.insets;
        gbc.insets = new Insets(0, 0, 0, 10);
        superHolder.add((Component)mainHolder, gbc);
        gbc.insets = oldInsets;
        JPanel recentHolder = new JPanel(new BorderLayout());
        recentHolder.setBorder(border);
        recentHolder.setInheritsPopupMenu(true);
        JLabel l = new JLabel(recentStr);
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 0;
        gbc.insets = new Insets(0, 0, 0, 2);
        superHolder.setInheritsPopupMenu(true);
        this.add(superHolder);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.swatchPanel.removeKeyListener(this.mainSwatchKeyListener);
        this.swatchPanel = null;
        this.mainSwatchListener = null;
        this.mainSwatchKeyListener = null;
        this.recentSwatchListener = null;
        this.recentSwatchKeyListener = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    private class MainSwatchKeyListener
    extends KeyAdapter {
        private MainSwatchKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (32 == e.getKeyCode()) {
                Color color = MySwatchChooserPanel.this.swatchPanel.getSelectedColor();
                MySwatchChooserPanel.this.setSelectedColor(color);
            }
        }
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (MySwatchChooserPanel.this.isEnabled()) {
                Color color = MySwatchChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
                MySwatchChooserPanel.this.setSelectedColor(color);
                MySwatchChooserPanel.this.swatchPanel.setSelectedColorFromLocation(e.getX(), e.getY());
                MySwatchChooserPanel.this.swatchPanel.requestFocusInWindow();
            }
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (MySwatchChooserPanel.this.isEnabled()) {
                // empty if block
            }
        }
    }

    private class RecentSwatchKeyListener
    extends KeyAdapter {
        private RecentSwatchKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (32 == e.getKeyCode()) {
                // empty if block
            }
        }
    }
}

