/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.dumpview;

import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSwfNode;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.MyTextField;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.dumpview.DumpTree;
import com.jpexs.decompiler.flash.gui.dumpview.DumpTreeModel;
import com.jpexs.decompiler.flash.gui.hexview.HexView;
import com.jpexs.decompiler.flash.gui.hexview.HexViewListener;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreePath;

public class DumpViewPanel
extends JPanel {
    private final JLabel selectedByteInfo;
    private final JLabel dumpViewLabel;
    private final HexView dumpViewHexTable;
    private JTextField filterField = new MyTextField("");
    private JPanel searchPanel;
    private final DumpTree dumpTree;
    private DumpInfo selectedDumpInfo;
    private boolean skipNextScroll;
    private boolean skipValueChange;

    public DumpViewPanel(final DumpTree dumpTree) {
        super(new BorderLayout());
        this.dumpTree = dumpTree;
        this.selectedByteInfo = new JLabel();
        this.selectedByteInfo.setMinimumSize(new Dimension(100, 20));
        this.selectedByteInfo.setText("-");
        this.add((Component)this.selectedByteInfo, "North");
        this.dumpViewLabel = new JLabel();
        this.dumpViewLabel.setMinimumSize(new Dimension(100, 20));
        this.dumpViewLabel.setText("-");
        this.add((Component)this.dumpViewLabel, "South");
        this.dumpViewHexTable = new HexView();
        this.dumpViewHexTable.addListener(new HexViewListener(){
            private int lastAddressUnderCursor = -1;
            final /* synthetic */ DumpViewPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void byteValueChanged(int address, byte b) {
                if (this.this$0.skipValueChange) {
                    return;
                }
                if (address != -1) {
                    DumpTreeModel model = dumpTree.getModel();
                    DumpInfoSwfNode di = DumpInfoSwfNode.getSwfNode((DumpInfo)this.this$0.selectedDumpInfo);
                    while (model.getChildCount(di) > 0) {
                        boolean found = false;
                        for (DumpInfo child : di.getChildInfos()) {
                            if (child.startByte > (long)address) break;
                            if (child.getEndByte() < (long)address) continue;
                            di = child;
                            found = true;
                        }
                        if (found) continue;
                        break;
                    }
                    ArrayList<Object> path = new ArrayList<Object>();
                    while (di != null) {
                        path.add(0, di);
                        di = di.parent;
                    }
                    path.add(0, model.getRoot());
                    TreePath tp = new TreePath(path.toArray());
                    this.this$0.skipNextScroll = true;
                    dumpTree.setSelectionPath(tp);
                    dumpTree.scrollPathToVisible(tp);
                }
                byte[] data = this.this$0.dumpViewHexTable.getData();
                this.byteMouseMoved(this.lastAddressUnderCursor, this.lastAddressUnderCursor == -1 ? (byte)0 : data[this.lastAddressUnderCursor]);
            }

            @Override
            public void byteMouseMoved(int address, byte b) {
                this.lastAddressUnderCursor = address;
                if (address == -1 && (address = this.this$0.dumpViewHexTable.getFocusedByteIdx()) != -1) {
                    byte[] data = this.this$0.dumpViewHexTable.getData();
                    b = data[address];
                }
                if (address != -1) {
                    int b2 = b & 0xFF;
                    this.this$0.selectedByteInfo.setText("Addr: " + String.format("%08X", address) + " Hex: " + String.format("%02X", b) + " Dec: " + b2 + " Bin: " + Helper.padZeros((String)Integer.toBinaryString(b2), (int)8) + " Ascii: " + (char)b2);
                } else {
                    this.this$0.selectedByteInfo.setText("-");
                }
            }
        });
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout(new BorderLayout());
        this.searchPanel.add((Component)this.filterField, "Center");
        this.searchPanel.add((Component)new JLabel(View.getIcon("search16")), "West");
        JLabel closeSearchButton = new JLabel(View.getIcon("cancel16"));
        closeSearchButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DumpViewPanel.this.closeDumpViewSearch();
            }
        });
        this.searchPanel.add((Component)closeSearchButton, "East");
        this.searchPanel.setVisible(false);
        this.dumpViewHexTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 70 && e.isControlDown()) {
                    DumpViewPanel.this.searchPanel.setVisible(true);
                    DumpViewPanel.this.filterField.requestFocusInWindow();
                }
            }
        });
        this.filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.warn();
            }

            public void warn() {
                DumpViewPanel.this.doSearch();
            }
        });
        JPanel hexPanel = new JPanel(new BorderLayout());
        hexPanel.add((Component)new FasterScrollPane(this.dumpViewHexTable), "Center");
        hexPanel.add((Component)this.searchPanel, "South");
        this.add((Component)hexPanel, "Center");
    }

    public void closeDumpViewSearch() {
        this.filterField.setText("");
        this.doSearch();
        this.searchPanel.setVisible(false);
    }

    private void doSearch() {
        int hexPos;
        String text;
        if (View.isOceanic()) {
            this.filterField.setBackground(Color.white);
        }
        if ((text = this.filterField.getText()).length() == 0) {
            this.dumpViewHexTable.clearSelectedBytes();
            return;
        }
        byte[] data = this.dumpViewHexTable.getData();
        byte[] textBytes = Utf8Helper.getBytes((String)text);
        byte[] hex = this.getAsHex(text);
        byte[] foundArray = textBytes;
        int pos = textBytes == null ? -1 : this.findHex(data, textBytes, 0, data.length);
        int n = hexPos = hex == null ? -1 : this.findHex(data, hex, 0, data.length);
        if (pos == -1 || hexPos != -1 && hexPos < pos) {
            pos = hexPos;
            foundArray = hex;
        }
        if (pos != -1) {
            this.dumpViewHexTable.selectBytes(pos, foundArray.length);
        } else {
            this.dumpViewHexTable.clearSelectedBytes();
            this.filterField.setBackground(Color.red);
        }
    }

    private int findHex(byte[] data, byte[] searchData, int from, int to) {
        for (int i = from; i < to; ++i) {
            if (!this.isMatch(data, searchData, i)) continue;
            return i;
        }
        return -1;
    }

    private boolean isMatch(byte[] data, byte[] searchData, int pos) {
        if (pos + searchData.length > data.length) {
            return false;
        }
        for (int i = 0; i < searchData.length; ++i) {
            if (data[pos + i] == searchData[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] getAsHex(String text) {
        int charCount = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = Character.toUpperCase(text.charAt(i));
            boolean whiteSpace = Character.isWhitespace(ch);
            if (!(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || whiteSpace)) {
                return null;
            }
            if (whiteSpace) continue;
            ++charCount;
        }
        if (charCount % 2 == 1) {
            return null;
        }
        byte[] result = new byte[charCount / 2];
        int cnt = 0;
        int v0 = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = Character.toUpperCase(text.charAt(i));
            if (Character.isWhitespace(ch)) continue;
            int v = Integer.parseInt(Character.toString(ch), 16);
            if (cnt % 2 == 1) {
                result[cnt / 2] = (byte)(v0 * 16 + v);
            } else {
                v0 = v;
            }
            ++cnt;
        }
        return result;
    }

    public void clear() {
        this.selectedDumpInfo = null;
    }

    public void setSelectedNode(DumpInfo dumpInfo) {
        if (this.selectedDumpInfo == dumpInfo) {
            this.skipNextScroll = false;
            return;
        }
        this.selectedDumpInfo = dumpInfo;
        byte[] data = DumpInfoSwfNode.getSwfNode((DumpInfo)dumpInfo).getSwf().originalUncompressedData;
        ArrayList<DumpInfo> dumpInfos = new ArrayList<DumpInfo>();
        DumpInfo di = dumpInfo;
        while (di.parent != null) {
            dumpInfos.add(di);
            di = di.parent;
        }
        long[] highlightStarts = new long[dumpInfos.size()];
        long[] highlightEnds = new long[dumpInfos.size()];
        for (int i = 0; i < dumpInfos.size(); ++i) {
            DumpInfo di2 = (DumpInfo)dumpInfos.get(highlightStarts.length - i - 1);
            highlightStarts[i] = di2.startByte;
            highlightEnds[i] = di2.getEndByte();
        }
        this.dumpViewHexTable.setData(data, highlightStarts, highlightEnds);
        this.dumpViewHexTable.revalidate();
        if (dumpInfo.lengthBytes != 0L || dumpInfo.lengthBits != 0) {
            int selectionStart = (int)dumpInfo.startByte;
            int selectionEnd = (int)dumpInfo.getEndByte();
            if (!this.skipNextScroll) {
                this.skipValueChange = true;
                this.dumpViewHexTable.scrollToByte(highlightStarts, highlightEnds);
                this.skipValueChange = false;
            }
            this.setLabelText("startByte: " + dumpInfo.startByte + " startBit: " + dumpInfo.startBit + " lengthBytes: " + dumpInfo.lengthBytes + " lengthBits: " + dumpInfo.lengthBits + " selectionStart: " + selectionStart + " selectionEnd: " + selectionEnd);
        }
        this.skipNextScroll = false;
        this.repaint();
    }

    public void setLabelText(String text) {
        this.dumpViewLabel.setText(text);
    }
}

