/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ValueNormalizer;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReflectionTools;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class BinaryDataEditor
extends JPanel
implements GenericTagEditor {
    private final MainPanel mainPanel;
    private final JButton replaceButton;
    private final JButton exportButton;
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private final String fieldName;
    private Object value;

    public BinaryDataEditor(MainPanel mainPanel, String fieldName, Object obj, Field field, int index, Class<?> type) {
        this.mainPanel = mainPanel;
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.fieldName = fieldName;
        this.exportButton = new JButton(AppStrings.translate("button.export"));
        this.replaceButton = new JButton(AppStrings.translate("button.replace"));
        this.setLayout(new FlowLayout());
        this.add(this.exportButton);
        this.add(this.replaceButton);
        this.exportButton.addActionListener(this::exportActionPerformed);
        this.replaceButton.addActionListener(this::replaceActionPerformed);
        this.reset();
    }

    @Override
    public void validateValue() {
    }

    @Override
    public void reset() {
        try {
            Object val = ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            if (val instanceof byte[]) {
                byte[] ba = (byte[])val;
                this.setToolTipText(ba.length + " bytes");
            } else if (val instanceof ByteArrayRange) {
                ByteArrayRange bar = (ByteArrayRange)val;
                this.setToolTipText(bar.getLength() + " bytes");
            }
            this.value = val;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    private void exportActionPerformed(ActionEvent evt) {
        if (this.value == null) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File((String)Configuration.lastExportDir.get()));
        if (fc.showSaveDialog(this) == 0) {
            File selfile = Helper.fixDialogFile((File)fc.getSelectedFile());
            ByteArrayRange br = (ByteArrayRange)this.value;
            try (FileOutputStream fos = new FileOutputStream(selfile);){
                fos.write(br.getArray(), br.getPos(), br.getLength());
            }
            catch (IOException ex) {
                ViewMessages.showMessageDialog(this.mainPanel, ex.getMessage(), AppStrings.translate("error"), 0);
            }
        }
    }

    private void replaceActionPerformed(ActionEvent evt) {
        File selectedFile = this.mainPanel.showImportFileChooser("", false, "importbinarydata");
        if (selectedFile != null) {
            File selfile = Helper.fixDialogFile((File)selectedFile);
            byte[] data = Helper.readFile((String[])new String[]{selfile.getAbsolutePath()});
            this.setToolTipText(data.length + " bytes");
            Class<?> type = this.field.getType();
            if (type.equals(byte[].class)) {
                this.value = data;
            } else if (type.equals(ByteArrayRange.class)) {
                this.value = new ByteArrayRange(data);
            }
        }
    }

    @Override
    public boolean save() {
        try {
            Object oldValue = ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            Object newValue = this.value;
            if (Objects.equals(oldValue, newValue)) {
                return false;
            }
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final BinaryDataEditor t = this;
        this.replaceButton.addActionListener(new ActionListener(){
            final /* synthetic */ BinaryDataEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public Object getChangedValue() {
        return this.value;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return this.getChangedValue().toString();
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public int getBaseline(int width, int height) {
        return 0;
    }

    @Override
    public void added() {
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public void setValueNormalizer(ValueNormalizer normalizer) {
    }
}

