/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ValueNormalizer;
import com.jpexs.decompiler.flash.types.annotations.DottedIdentifier;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReflectionTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import java.util.Objects;
import javax.swing.JTextArea;

public class StringEditor
extends JTextArea
implements GenericTagEditor {
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private String fieldName;
    private boolean multiline;
    private final SWF swf;

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        ret.width = 300;
        return ret;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public int getBaseline(int width, int height) {
        return 0;
    }

    public StringEditor(String fieldName, Object obj, Field field, int index, Class<?> type, boolean multiline, SWF swf) {
        this.setLineWrap(true);
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.fieldName = fieldName;
        this.multiline = multiline;
        this.swf = swf;
        if (multiline) {
            Dimension d = new Dimension(500, 200);
            this.setPreferredSize(d);
            this.setSize(d);
        }
        this.reset();
    }

    @Override
    public void reset() {
        try {
            String newValue = (String)ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            DottedIdentifier di = this.field.getAnnotation(DottedIdentifier.class);
            if (di != null) {
                newValue = di.exportName() ? Helper.escapeExportname((SWF)this.swf, (String)newValue, (boolean)false) : Helper.escapePCodeString((String)newValue);
            }
            this.setText(newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    @Override
    public boolean save() {
        try {
            String oldValue = (String)ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            String newValue = this.getText();
            DottedIdentifier di = this.field.getAnnotation(DottedIdentifier.class);
            if (di != null) {
                newValue = di.exportName() ? Helper.unescapeExportname((SWF)this.swf, (String)newValue) : Helper.unescapePCodeString((String)newValue);
            }
            if (Objects.equals(oldValue, newValue)) {
                return false;
            }
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final StringEditor t = this;
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ StringEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void focusLost(FocusEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public Object getChangedValue() {
        return this.getText();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return Helper.escapeHTML((String)this.getChangedValue().toString());
    }

    @Override
    public void added() {
    }

    @Override
    public void validateValue() {
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public void setValueNormalizer(ValueNormalizer normalizer) {
    }
}

