/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.generictageditors;

import com.jpexs.decompiler.flash.gui.generictageditors.ChangeListener;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ValueNormalizer;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.ReflectionTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Field;
import java.util.Objects;
import javax.swing.JTextField;

public class UUIDEditor
extends JTextField
implements GenericTagEditor {
    private final Object obj;
    private final Field field;
    private final int index;
    private final Class<?> type;
    private String fieldName;

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ret = super.getPreferredSize();
        ret.width = 300;
        return ret;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public int getBaseline(int width, int height) {
        return 0;
    }

    public UUIDEditor(String fieldName, Object obj, Field field, int index, Class<?> type) {
        super(36);
        this.obj = obj;
        this.field = field;
        this.index = index;
        this.type = type;
        this.fieldName = fieldName;
        this.reset();
    }

    @Override
    public void reset() {
        try {
            byte[] val = (byte[])ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < val.length; ++i) {
                String h = Integer.toHexString(val[i] & 0xFF);
                if (h.length() == 1) {
                    h = "0" + h;
                }
                sb.append(h);
                if (i != 3 && i != 5 && i != 7 && i != 9) continue;
                sb.append("-");
            }
            this.setText(sb.toString());
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    @Override
    public boolean save() {
        try {
            byte[] oldValue = (byte[])ReflectionTools.getValue((Object)this.obj, (Field)this.field, (int)this.index);
            String text = this.getText();
            text = text.replace("-", "").trim();
            if (!text.matches("[a-fA-F0-9]{32}")) {
                return false;
            }
            byte[] newValue = new byte[16];
            for (int i = 0; i < 16; ++i) {
                String ch = text.substring(i * 2, i * 2 + 2);
                newValue[i] = (byte)Integer.parseInt(ch, 16);
            }
            if (Objects.equals(oldValue, newValue)) {
                return false;
            }
            ReflectionTools.setValue((Object)this.obj, (Field)this.field, (int)this.index, (Object)newValue);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void addChangeListener(final ChangeListener l) {
        final UUIDEditor t = this;
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ UUIDEditor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void focusLost(FocusEvent e) {
                l.change(t);
            }
        });
    }

    @Override
    public Object getChangedValue() {
        return this.getText();
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getReadOnlyValue() {
        return Helper.escapeHTML((String)this.getChangedValue().toString());
    }

    @Override
    public void added() {
    }

    @Override
    public void validateValue() {
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public void setValueNormalizer(ValueNormalizer normalizer) {
    }
}

