/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.hexview;

import javax.swing.table.AbstractTableModel;

public class HexViewTableModel
extends AbstractTableModel {
    private byte[] data;
    private final int bytesInRow;

    public HexViewTableModel(int bytesInRow) {
        this.bytesInRow = bytesInRow;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        int byteCount = this.data.length;
        int rowCount = (int)Math.ceil((double)byteCount / (double)this.bytesInRow);
        return rowCount;
    }

    @Override
    public int getColumnCount() {
        return 2 * this.bytesInRow + 1 + 1;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Address";
        }
        if (column <= this.bytesInRow) {
            return String.format("%01X", column - 1);
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return String.format("%08X", (long)row * (long)this.bytesInRow);
        }
        if (column <= this.bytesInRow) {
            int pos = row * this.bytesInRow + column - 1;
            if (pos < this.data.length) {
                return String.format("%02X", this.data[pos]);
            }
            return null;
        }
        if (column == 1 + this.bytesInRow) {
            return null;
        }
        int pos = row * this.bytesInRow + column - this.bytesInRow - 1 - 1;
        if (pos < this.data.length) {
            return Character.valueOf((char)(this.data[pos] & 0xFF));
        }
        return null;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.fireTableDataChanged();
    }

    @Override
    public void fireTableCellUpdated(int row, int column) {
        super.fireTableCellUpdated(row, column);
    }
}

