/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.soleditor;

import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.soleditor.CookiesChangedListener;
import com.jpexs.decompiler.flash.gui.soleditor.FlashPlayerApi;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SharedObjectsStorage {
    public static boolean watchingPaused = false;
    public static Map<WatchKey, File> watchedCookieDirectories = new HashMap<WatchKey, File>();
    private static Map<File, List<CookiesChangedListener>> swfFileToListeners = Collections.synchronizedMap(new LinkedHashMap());

    public static void addChangedListener(File file, CookiesChangedListener listener) {
        if (!swfFileToListeners.containsKey(file)) {
            swfFileToListeners.put(file, new ArrayList());
        }
        swfFileToListeners.get(file).add(listener);
        File solDir = SharedObjectsStorage.getSolDirectoryForLocalFile(file);
        if (solDir == null) {
            return;
        }
        while (!solDir.exists()) {
            solDir = solDir.getParentFile();
        }
        if (!watchedCookieDirectories.containsValue(solDir)) {
            SharedObjectsStorage.watchDir(solDir);
        }
    }

    public static void removeChangedListener(File file, CookiesChangedListener listener) {
        if (!swfFileToListeners.containsKey(file)) {
            return;
        }
        swfFileToListeners.get(file).remove(listener);
    }

    private static void watchDir(File dir) {
        try {
            WatchKey key = dir.toPath().register(Main.getWatcher(), StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            watchedCookieDirectories.put(key, dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static OSId getOSId() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (OS.contains("mac") || OS.contains("darwin")) {
            return OSId.OSX;
        }
        if (OS.contains("win")) {
            return OSId.WINDOWS;
        }
        return OSId.UNIX;
    }

    public static List<File> getSolFilesForLocalFile(File file) {
        File solDirectory = SharedObjectsStorage.getSolDirectoryForLocalFile(file);
        if (solDirectory == null) {
            return new ArrayList<File>();
        }
        if (!solDirectory.exists()) {
            return new ArrayList<File>();
        }
        File[] retArr = solDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".sol");
            }
        });
        return Arrays.asList(retArr);
    }

    public static List<File> getSolFilesForUrl(String url, FlashPlayerApi api) {
        File solDirectory = SharedObjectsStorage.getSolDirectoryForUrl(url, api);
        if (solDirectory == null) {
            return new ArrayList<File>();
        }
        File[] retArr = solDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().toLowerCase(Locale.ENGLISH).endsWith(".sol");
            }
        });
        return Arrays.asList(retArr);
    }

    public static File getSolDirectoryForLocalFile(File file) {
        File parentDir = SharedObjectsStorage.getDirectory();
        if (parentDir == null) {
            return null;
        }
        String absPath = file.getAbsolutePath();
        if ((absPath = absPath.replace("\\", "/")).startsWith("//?/") || absPath.startsWith("//./")) {
            absPath = absPath.substring(4);
        } else if (absPath.matches("^[a-zA-Z]:/.*")) {
            absPath = absPath.substring(3);
        } else if (absPath.startsWith("/")) {
            absPath = absPath.substring(1);
        }
        absPath = absPath.replace("/", File.separator);
        return new File(parentDir, "localhost" + File.separator + SharedObjectsStorage.encodeLocalPath(absPath));
    }

    private static String encodeUrl(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c > '\u007f') {
                byte[] bytes = Utf8Helper.getBytes((String)("" + c));
                for (int b = 0; b < bytes.length; ++b) {
                    int d = bytes[b] & 0xFF;
                    String hex = String.format("%02X", d);
                    sb.append("%").append(hex);
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String encodeLocalPath(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c > '\u007f') {
                byte[] bytes = Utf8Helper.getBytes((String)("" + c));
                for (int b = 0; b < bytes.length; ++b) {
                    int d = bytes[b] & 0xFF;
                    String hex = String.format("%02X", d);
                    hex = hex.charAt(0) + "#" + hex.charAt(1);
                    sb.append(hex);
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static File getSolDirectoryForUrl(String url, FlashPlayerApi api) {
        File parentDir = SharedObjectsStorage.getDirectory(api);
        if (parentDir == null) {
            return null;
        }
        Pattern urlPattern = Pattern.compile("^https?://(?<host>[^/]+)/(?<path>[^?#]+)(\\?.*)?(#.*)?$");
        Matcher m = urlPattern.matcher(url);
        if (!m.matches()) {
            throw new IllegalArgumentException("Not a valid URL: " + url);
        }
        String host = m.group("host");
        String path = m.group("path");
        path = path.replace("/", File.separator);
        if (host.equals("localhost")) {
            host = "#" + host;
        }
        return new File(parentDir, host + File.separator + SharedObjectsStorage.encodeUrl(path));
    }

    public static File getDirectory() {
        return SharedObjectsStorage.getDirectory(FlashPlayerApi.NPAPI);
    }

    public static File getDirectory(FlashPlayerApi api) {
        switch (api) {
            case NPAPI: {
                return SharedObjectsStorage.getNpApiDirectory();
            }
            case PPAPI: {
                return SharedObjectsStorage.getPpApiDirectory();
            }
        }
        return null;
    }

    public static File getPpApiDirectory() {
        String userHome = null;
        try {
            userHome = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        File sharedObjectsDir = null;
        switch (SharedObjectsStorage.getOSId().ordinal()) {
            case 0: {
                File winLocalAppDataDir = null;
                try {
                    String appDataEV = System.getenv("LOCALAPPDATA");
                    if (appDataEV != null && appDataEV.length() > 0) {
                        winLocalAppDataDir = new File(appDataEV);
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (winLocalAppDataDir == null) {
                    return null;
                }
                sharedObjectsDir = new File(winLocalAppDataDir, "Google\\Chrome\\User Data\\Default\\Pepper Data\\Shockwave Flash\\WritableRoot\\#SharedObjects");
                break;
            }
            case 1: {
                if (userHome == null) {
                    return null;
                }
                sharedObjectsDir = new File(userHome, "Library/Application Support/Google/Chrome/Default/Pepper Data/Shockwave Flash/WritableRoot/#SharedObjects");
                break;
            }
            case 2: {
                if (userHome == null) {
                    return null;
                }
                sharedObjectsDir = new File(userHome, ".config/google-chrome/Default/Pepper Data/Shockwave Flash/WritableRoot/#SharedObjects");
            }
        }
        if (sharedObjectsDir == null) {
            return null;
        }
        if (!sharedObjectsDir.exists()) {
            return null;
        }
        File[] subDirs = sharedObjectsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (subDirs.length == 0) {
            return null;
        }
        return subDirs[0];
    }

    public static File getNpApiDirectory() {
        String userHome = null;
        try {
            userHome = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        File sharedObjectsDir = null;
        switch (SharedObjectsStorage.getOSId().ordinal()) {
            case 0: {
                File winAppDataDir = null;
                try {
                    String appDataEV = System.getenv("APPDATA");
                    if (appDataEV != null && appDataEV.length() > 0) {
                        winAppDataDir = new File(appDataEV);
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (winAppDataDir != null && winAppDataDir.isDirectory()) {
                    sharedObjectsDir = new File(winAppDataDir, "Macromedia\\Flash Player\\#SharedObjects");
                    break;
                }
                if (userHome == null) {
                    return null;
                }
                sharedObjectsDir = new File(userHome, "Application Data\\Macromedia\\Flash Player\\#SharedObjects");
                break;
            }
            case 1: {
                if (userHome == null) {
                    return null;
                }
                sharedObjectsDir = new File(userHome, "Library/Preferences/Macromedia/Flash Player/#SharedObjects");
                break;
            }
            case 2: {
                if (userHome == null) {
                    return null;
                }
                sharedObjectsDir = new File(userHome, ".macromedia/Flash_Player/#SharedObjects");
            }
        }
        if (sharedObjectsDir == null) {
            return null;
        }
        if (!sharedObjectsDir.exists()) {
            return null;
        }
        File[] subDirs = sharedObjectsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (subDirs.length == 0) {
            return null;
        }
        return subDirs[0];
    }

    public static void watchedDirectoryChanged(File file) {
        if (watchingPaused) {
            return;
        }
        ArrayList<File> swfFiles = new ArrayList<File>(swfFileToListeners.keySet());
        for (File swfFile : swfFiles) {
            File solDir = SharedObjectsStorage.getSolDirectoryForLocalFile(swfFile);
            if (file.equals(solDir) || file.getParentFile().equals(solDir)) {
                SharedObjectsStorage.fireChanged(swfFile, SharedObjectsStorage.getSolFilesForLocalFile(swfFile));
                continue;
            }
            if (solDir.exists()) continue;
            while (!solDir.exists()) {
                solDir = solDir.getParentFile();
            }
            if (!solDir.equals(file) || watchedCookieDirectories.containsValue(file)) continue;
            SharedObjectsStorage.watchDir(file);
        }
    }

    private static void fireChanged(File swfFile, List<File> files) {
        List<CookiesChangedListener> listeners = swfFileToListeners.get(swfFile);
        if (listeners != null) {
            listeners = new ArrayList<CookiesChangedListener>(listeners);
            for (CookiesChangedListener l : listeners) {
                l.cookiesChanged(swfFile, files);
            }
        }
    }

    private static enum OSId {
        WINDOWS,
        OSX,
        UNIX;

    }
}

