/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui.taglistview;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.taglistview.TagListTreeCellRenderer;
import com.jpexs.decompiler.flash.gui.taglistview.TagListTreeModel;
import com.jpexs.decompiler.flash.gui.tagtree.AbstractTagTree;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.Openable;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class TagListTree
extends AbstractTagTree {
    public TagListTree(TagListTreeModel model, MainPanel mainPanel) {
        super(model, mainPanel);
        this.setCellRenderer(new TagListTreeCellRenderer());
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setTransferHandler(new TreeTransferHandler(mainPanel));
    }

    @Override
    public List<TreeItem> getSelection(Openable openable) {
        return TagListTree.getSelection(openable, this.getAllSelected());
    }

    @Override
    public TagListTreeModel getFullModel() {
        return (TagListTreeModel)super.getFullModel();
    }

    class TreeTransferHandler
    extends TransferHandler {
        DataFlavor nodesFlavor;
        DataFlavor[] flavors = new DataFlavor[1];
        JTree.DropLocation dropLocation = null;
        MainPanel mainPanel;

        public TreeTransferHandler(MainPanel mainPanel) {
            this.mainPanel = mainPanel;
            try {
                String mimeType = "application/x-java-jvm-local-objectref;class=\"" + Tag[].class.getName() + "\"";
                this.flavors[0] = this.nodesFlavor = new DataFlavor(mimeType);
            }
            catch (ClassNotFoundException e) {
                System.err.println("ClassNotFound: " + e.getMessage());
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            support.setShowDropLocation(true);
            if (!support.isDataFlavorSupported(this.nodesFlavor)) {
                return false;
            }
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            if (dl.getPath().getLastPathComponent() instanceof Tag && !(dl.getPath().getLastPathComponent() instanceof DefineSpriteTag) && dl.getChildIndex() == -1) {
                return false;
            }
            if (dl.getPath().getLastPathComponent() instanceof SWF && dl.getChildIndex() == 0) {
                return false;
            }
            AbstractTagTree tree = (AbstractTagTree)support.getComponent();
            List<TreeItem> selected = tree.getSelected();
            TreePath destPath = dl.getPath();
            ArrayList<TreeItem> parents = new ArrayList<TreeItem>();
            for (int i = 0; i < destPath.getPathCount(); ++i) {
                parents.add((TreeItem)destPath.getPathComponent(i));
            }
            for (TreeItem item : selected) {
                if (!parents.contains(item)) continue;
                return false;
            }
            int dropRow = tree.getRowForPath(dl.getPath());
            int[] selRows = tree.getSelectionRows();
            for (int i = 0; i < selRows.length; ++i) {
                if (selRows[i] != dropRow) continue;
                return false;
            }
            return true;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            AbstractTagTree tree = (AbstractTagTree)c;
            this.dropLocation = null;
            if (!((Boolean)Configuration.allowDragAndDropInTagListTree.get()).booleanValue()) {
                return null;
            }
            TreePath[] paths = tree.getSelectionPaths();
            if (paths == null) {
                return null;
            }
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (TreePath path : paths) {
                if (!(path.getLastPathComponent() instanceof Tag)) {
                    return null;
                }
                tags.add((Tag)path.getLastPathComponent());
            }
            Tag[] tagArr = tags.toArray(new Tag[tags.size()]);
            return new TagsTransferable(tagArr);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            Tag position;
            Timelined timelined;
            AbstractTagTree tree = (AbstractTagTree)source;
            if (this.dropLocation == null) {
                return;
            }
            int childIndex = this.dropLocation.getChildIndex();
            TreeItem dest = (TreeItem)this.dropLocation.getPath().getLastPathComponent();
            LinkedHashSet<TreeItem> sourceItems = new LinkedHashSet<TreeItem>(tree.getSelected());
            if (childIndex == -1) {
                if (dest instanceof DefineSpriteTag) {
                    timelined = (Timelined)dest;
                    position = null;
                } else if (dest instanceof Tag) {
                    timelined = ((Tag)dest).getTimelined();
                    position = (Tag)dest;
                } else if (dest instanceof Frame) {
                    Frame frame = (Frame)dest;
                    position = (Tag)frame.allInnerTags.get(frame.allInnerTags.size() - 1);
                    timelined = frame.timeline.timelined;
                } else {
                    timelined = (Timelined)dest;
                    position = null;
                }
            } else if (dest instanceof Frame) {
                Frame frame = (Frame)dest;
                timelined = frame.timeline.timelined;
                position = childIndex == frame.allInnerTags.size() ? null : (Tag)frame.allInnerTags.get(childIndex);
            } else if (dest instanceof SWF) {
                SWF swf = (SWF)dest;
                timelined = swf;
                int frameIndex = childIndex - 1 - 1;
                if (frameIndex == -1) {
                    frameIndex = 0;
                }
                Frame frame = swf.getTimeline().getFrame(frameIndex);
                position = (Tag)frame.allInnerTags.get(0);
            } else if (dest instanceof DefineSpriteTag) {
                DefineSpriteTag sprite = (DefineSpriteTag)dest;
                timelined = sprite;
                int frameIndex = childIndex - 1;
                if (frameIndex == -1) {
                    frameIndex = 0;
                }
                Frame frame = sprite.getTimeline().getFrame(frameIndex);
                position = (Tag)frame.allInnerTags.get(0);
            } else if (dest instanceof Tag) {
                timelined = ((Tag)dest).getTimelined();
                position = (Tag)dest;
            } else {
                int childCount = tree.getFullModel().getChildCount(dest);
                TreeItem child = childIndex >= childCount ? tree.getFullModel().getChild(dest, childCount - 1) : tree.getFullModel().getChild(dest, childIndex);
                if (child instanceof SWF) {
                    SWF swf = (SWF)child;
                    timelined = swf;
                    position = null;
                } else {
                    return;
                }
            }
            this.mainPanel.getContextPopupMenu().copyOrMoveTags(sourceItems, (action & 2) == 2, timelined, position);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable t = support.getTransferable();
            Tag[] tags = null;
            try {
                tags = (Tag[])t.getTransferData(this.nodesFlavor);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                Logger.getLogger(TreeTransferHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.dropLocation = (JTree.DropLocation)support.getDropLocation();
            return true;
        }

        public class TagsTransferable
        implements Transferable {
            Tag[] nodes;

            public TagsTransferable(Tag[] nodes) {
                this.nodes = nodes;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                return this.nodes;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return TreeTransferHandler.this.flavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return TreeTransferHandler.this.nodesFlavor.equals(flavor);
            }
        }
    }
}

