/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.coloreffects;

import com.jpexs.flash.fla.converter.coloreffects.ColorEffectInterface;
import java.awt.Color;

public class TintColorEffect
implements ColorEffectInterface {
    private final double tintMultiplier;
    private final Color tintColor;

    public TintColorEffect(double tintMultiplier, Color tintColor) {
        this.tintMultiplier = tintMultiplier;
        this.tintColor = tintColor;
    }

    public int getMultiplier() {
        return (int)Math.round((1.0 - this.tintMultiplier) * 256.0);
    }

    @Override
    public int getRedMultiplier() {
        return this.getMultiplier();
    }

    @Override
    public int getGreenMultiplier() {
        return this.getMultiplier();
    }

    @Override
    public int getBlueMultiplier() {
        return this.getMultiplier();
    }

    @Override
    public int getAlphaMultiplier() {
        return 256;
    }

    @Override
    public int getRedOffset() {
        return (int)Math.round((double)this.tintColor.getRed() * this.tintMultiplier);
    }

    @Override
    public int getGreenOffset() {
        return (int)Math.round((double)this.tintColor.getGreen() * this.tintMultiplier);
    }

    @Override
    public int getBlueOffset() {
        return (int)Math.round((double)this.tintColor.getBlue() * this.tintMultiplier);
    }

    @Override
    public int getAlphaOffset() {
        return 0;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public int getValuePercent() {
        return (int)Math.round(this.tintMultiplier * 100.0);
    }

    @Override
    public Color getValueColor() {
        return this.tintColor;
    }
}

