/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.debug;

import com.jpexs.flash.fla.converter.FlaFormatVersion;
import com.jpexs.flash.fla.converter.FlaWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class EdgeReader {
    private static float readShort(InputStream is) throws IOException {
        int v1 = is.read();
        int v2 = is.read();
        int v = (v2 << 8) + v1;
        v = v << 16 >> 16;
        return (float)v / 2.0f;
    }

    private static float readByte(InputStream is) throws IOException {
        int fract = is.read();
        int integer = is.read();
        integer = integer << 24 >> 24;
        return (float)integer + (float)fract / 256.0f;
    }

    private static float readFloat(InputStream is) throws IOException {
        int fract = is.read();
        int v1 = is.read();
        int v2 = is.read();
        int v3 = is.read();
        int v = (v3 << 16) + (v2 << 8) + v1;
        v = v << 8 >> 8;
        return (float)v + (float)fract / 256.0f;
    }

    private static String doubleToStr(double v) {
        String s = "" + v;
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    public static void readEdge(InputStream fis, FlaFormatVersion flaFormatVersion) throws IOException {
        boolean hasSelection;
        int flags = fis.read();
        boolean bl = hasSelection = (flags & FlaWriter.FLAG_EDGE_NO_SELECTION) != FlaWriter.FLAG_EDGE_NO_SELECTION;
        if ((flags & FlaWriter.FLAG_EDGE_HAS_STYLES) == FlaWriter.FLAG_EDGE_HAS_STYLES) {
            fis.read();
            if (hasSelection) {
                fis.read();
            }
            fis.read();
            if (hasSelection) {
                fis.read();
            }
            fis.read();
            if (hasSelection) {
                fis.read();
            }
        }
        if ((flags & FlaWriter.FLAG_EDGE_FROM_SHORT) == FlaWriter.FLAG_EDGE_FROM_SHORT) {
            EdgeReader.readShort(fis);
            EdgeReader.readShort(fis);
        } else if ((flags & FlaWriter.FLAG_EDGE_FROM_BYTE) == FlaWriter.FLAG_EDGE_FROM_BYTE) {
            EdgeReader.readByte(fis);
            EdgeReader.readByte(fis);
        } else if ((flags & FlaWriter.FLAG_EDGE_FROM_FLOAT) == FlaWriter.FLAG_EDGE_FROM_FLOAT) {
            EdgeReader.readFloat(fis);
            EdgeReader.readFloat(fis);
        }
        boolean hasControl = false;
        if ((flags & FlaWriter.FLAG_EDGE_CONTROL_SHORT) == FlaWriter.FLAG_EDGE_CONTROL_SHORT) {
            EdgeReader.readShort(fis);
            EdgeReader.readShort(fis);
            hasControl = true;
        } else if ((flags & FlaWriter.FLAG_EDGE_CONTROL_BYTE) == FlaWriter.FLAG_EDGE_CONTROL_BYTE) {
            EdgeReader.readByte(fis);
            EdgeReader.readByte(fis);
            hasControl = true;
        } else if ((flags & FlaWriter.FLAG_EDGE_CONTROL_FLOAT) == FlaWriter.FLAG_EDGE_CONTROL_FLOAT) {
            EdgeReader.readFloat(fis);
            EdgeReader.readFloat(fis);
            hasControl = true;
        }
        if ((flags & FlaWriter.FLAG_EDGE_TO_SHORT) == FlaWriter.FLAG_EDGE_TO_SHORT) {
            EdgeReader.readShort(fis);
            EdgeReader.readShort(fis);
        } else if ((flags & FlaWriter.FLAG_EDGE_TO_BYTE) == FlaWriter.FLAG_EDGE_TO_BYTE) {
            EdgeReader.readByte(fis);
            EdgeReader.readByte(fis);
        } else if ((flags & FlaWriter.FLAG_EDGE_TO_FLOAT) == FlaWriter.FLAG_EDGE_TO_FLOAT) {
            EdgeReader.readFloat(fis);
            EdgeReader.readFloat(fis);
        }
        if (flaFormatVersion.ordinal() >= FlaFormatVersion.CS3.ordinal() && !hasControl) {
            fis.read();
        }
    }

    public static void main(String[] args) throws IOException {
        File file = new File("testdata\\fla\\cs3\\0003_fills\\P 2 1726169870");
        FileInputStream fis = new FileInputStream(file);
        fis.skip(515L);
        double x = 0.0;
        double y = 0.0;
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> edges = new ArrayList<String>();
        while (fis.available() > 0) {
            int generalLineFlag;
            int flags = fis.read();
            if ((flags & FlaWriter.FLAG_EDGE_NO_SELECTION) == FlaWriter.FLAG_EDGE_NO_SELECTION) {
                int stroke = fis.read();
                int fs0 = fis.read();
                int fs1 = fis.read();
                if (!first) {
                    for (String e : edges) {
                        System.out.print(e);
                    }
                    edges.clear();
                    System.out.println("\"/>");
                }
                sb = new StringBuilder();
                first = false;
                System.out.print("<Edge ");
                if (fs0 != 0) {
                    System.out.print("fillStyle0=\"" + fs0 + "\" ");
                }
                if (fs1 != 0) {
                    System.out.print("fillStyle1=\"" + fs1 + "\" ");
                }
                if (stroke != 0) {
                    System.out.print("strokeStyle=\"" + stroke + "\" ");
                }
                System.out.print("edges=\"");
            }
            sb.append("0x").append(Integer.toHexString(flags)).append(" ");
            if ((flags & FlaWriter.FLAG_EDGE_FROM_SHORT) == FlaWriter.FLAG_EDGE_FROM_SHORT) {
                sb.append(" from short ").append(EdgeReader.doubleToStr(x += (double)EdgeReader.readShort(fis))).append(" ").append(EdgeReader.doubleToStr(y += (double)EdgeReader.readShort(fis)));
            } else if ((flags & FlaWriter.FLAG_EDGE_FROM_BYTE) == FlaWriter.FLAG_EDGE_FROM_BYTE) {
                sb.append(" from byte ").append(EdgeReader.doubleToStr(x += (double)EdgeReader.readByte(fis))).append(" ").append(EdgeReader.doubleToStr(y += (double)EdgeReader.readByte(fis)));
            } else if ((flags & FlaWriter.FLAG_EDGE_FROM_FLOAT) == FlaWriter.FLAG_EDGE_FROM_FLOAT) {
                sb.append(" from float ").append(EdgeReader.doubleToStr(x += (double)EdgeReader.readFloat(fis))).append(" ").append(EdgeReader.doubleToStr(y += (double)EdgeReader.readFloat(fis)));
            } else {
                sb.append(" from none");
            }
            edges.add("!" + EdgeReader.doubleToStr(x) + " " + EdgeReader.doubleToStr(y));
            boolean hasControl = false;
            if ((flags & FlaWriter.FLAG_EDGE_CONTROL_SHORT) == FlaWriter.FLAG_EDGE_CONTROL_SHORT) {
                double cx = x + (double)EdgeReader.readShort(fis);
                double cy = y + (double)EdgeReader.readShort(fis);
                edges.add("[" + EdgeReader.doubleToStr(cx) + " " + EdgeReader.doubleToStr(cy));
                hasControl = true;
                sb.append(" control short ").append(EdgeReader.doubleToStr(cx)).append(" ").append(EdgeReader.doubleToStr(cy));
            } else if ((flags & FlaWriter.FLAG_EDGE_CONTROL_BYTE) == FlaWriter.FLAG_EDGE_CONTROL_BYTE) {
                double cx = x + (double)EdgeReader.readByte(fis);
                double cy = y + (double)EdgeReader.readByte(fis);
                edges.add("[" + EdgeReader.doubleToStr(cx) + " " + EdgeReader.doubleToStr(cy));
                hasControl = true;
                sb.append(" control byte ").append(EdgeReader.doubleToStr(cx)).append(" ").append(EdgeReader.doubleToStr(cy));
            } else if ((flags & FlaWriter.FLAG_EDGE_CONTROL_FLOAT) == FlaWriter.FLAG_EDGE_CONTROL_FLOAT) {
                double cx = x + (double)EdgeReader.readFloat(fis);
                double cy = y + (double)EdgeReader.readFloat(fis);
                edges.add("[" + EdgeReader.doubleToStr(cx) + " " + EdgeReader.doubleToStr(cy));
                hasControl = true;
                sb.append(" control float ").append(EdgeReader.doubleToStr(cx)).append(" ").append(EdgeReader.doubleToStr(cy));
            } else {
                sb.append(" control none");
            }
            if ((flags & FlaWriter.FLAG_EDGE_TO_SHORT) == FlaWriter.FLAG_EDGE_TO_SHORT) {
                x += (double)EdgeReader.readShort(fis);
                y += (double)EdgeReader.readShort(fis);
                String prefix = "";
                if (!hasControl) {
                    prefix = "|";
                }
                edges.add(prefix + EdgeReader.doubleToStr(x) + " " + EdgeReader.doubleToStr(y));
                sb.append(" to short ").append(EdgeReader.doubleToStr(x)).append(" ").append(EdgeReader.doubleToStr(y));
            } else if ((flags & FlaWriter.FLAG_EDGE_TO_BYTE) == FlaWriter.FLAG_EDGE_TO_BYTE) {
                x += (double)EdgeReader.readByte(fis);
                y += (double)EdgeReader.readByte(fis);
                String prefix = "";
                if (!hasControl) {
                    prefix = "|";
                }
                edges.add(prefix + EdgeReader.doubleToStr(x) + " " + EdgeReader.doubleToStr(y));
                sb.append(" to byte ").append(EdgeReader.doubleToStr(x)).append(" ").append(EdgeReader.doubleToStr(y));
            } else if ((flags & FlaWriter.FLAG_EDGE_TO_FLOAT) == FlaWriter.FLAG_EDGE_TO_FLOAT) {
                x += (double)EdgeReader.readFloat(fis);
                y += (double)EdgeReader.readFloat(fis);
                String prefix = "";
                if (!hasControl) {
                    prefix = "|";
                }
                edges.add(prefix + EdgeReader.doubleToStr(x) + " " + EdgeReader.doubleToStr(y));
                sb.append(" to float ").append(EdgeReader.doubleToStr(x)).append(" ").append(EdgeReader.doubleToStr(y));
            } else {
                sb.append(" to none");
            }
            sb.append(";");
            if (hasControl || (generalLineFlag = fis.read()) != 1 || edges.isEmpty()) continue;
            String e = (String)edges.get(edges.size() - 1);
            e = "/" + e.substring(1);
            edges.set(edges.size() - 1, e);
        }
        fis.close();
    }
}

