/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.filters;

import com.jpexs.flash.fla.converter.FlaWriter;
import com.jpexs.flash.fla.converter.filters.FilterInterface;
import java.awt.Color;
import java.io.IOException;

public class GlowFilter
implements FilterInterface {
    private float blurX = 5.0f;
    private float blurY = 5.0f;
    private Color color = Color.red;
    private boolean inner = false;
    private boolean knockout = false;
    private int quality = 1;
    private float strength = 1.0f;
    private boolean enabled = true;

    public GlowFilter() {
    }

    public GlowFilter(float blurX, float blurY, Color color, boolean inner, boolean knockout, int quality, float strenght, boolean enabled) {
        this.blurX = blurX;
        this.blurY = blurY;
        this.color = color;
        this.inner = inner;
        this.knockout = knockout;
        this.quality = quality;
        this.strength = strenght;
        this.enabled = enabled;
    }

    public float getBlurX() {
        return this.blurX;
    }

    public float getBlurY() {
        return this.blurY;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isInner() {
        return this.inner;
    }

    public boolean isKnockout() {
        return this.knockout;
    }

    public int getQuality() {
        return this.quality;
    }

    public float getStrenght() {
        return this.strength;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void write(FlaWriter os) throws IOException {
        os.write(new byte[]{2, 3, 4, 1, (byte)(this.enabled ? 1 : 0), 0, 0, 0, (byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)this.color.getAlpha(), 0, 0, -96, 64});
        os.writeFloat(this.blurX);
        os.writeFloat(this.blurY);
        int strengthPercent = Math.round(this.strength * 100.0f);
        os.write(new byte[]{-37, 15, 73, 63, (byte)(this.inner ? 1 : 0), 0, 0, 0, (byte)(this.knockout ? 1 : 0), 0, 0, 0, (byte)this.quality, 0, 0, 0, (byte)(strengthPercent & 0xFF), (byte)(strengthPercent >> 8 & 0xFF), 0, 0, 0, 0, 0, 0});
    }
}

