/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.flash.fla.converter.streams;

import com.jpexs.flash.fla.converter.streams.InputStorageInterface;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZippedInputStorage
implements InputStorageInterface {
    private final ZipFile zipFile;

    public ZippedInputStorage(File flaFile) throws IOException {
        this.zipFile = new ZipFile(flaFile);
    }

    @Override
    public InputStream readFile(String fileName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        if (entry.isDirectory()) {
            return null;
        }
        return this.zipFile.getInputStream(entry);
    }

    @Override
    public boolean fileExists(String fileName) {
        ZipEntry entry = this.zipFile.getEntry(fileName);
        if (entry == null) {
            return false;
        }
        return !entry.isDirectory();
    }

    @Override
    public void close() throws Exception {
        this.zipFile.close();
    }
}

