/*
 * Decompiled with CFR 0.152.
 */
package fontastic;

import fontastic.FContour;
import fontastic.FPoint;
import java.util.ArrayList;
import java.util.List;

public class FGlyph {
    private final char glyphChar;
    private final List<FContour> contours;
    private int advanceWidth = 512;

    FGlyph(char c) {
        this.glyphChar = c;
        this.contours = new ArrayList<FContour>();
    }

    public void addContour() {
        this.contours.add(new FContour());
    }

    public void addContour(FPoint[] points) {
        this.contours.add(new FContour(points));
    }

    public void addContour(FPoint[] points, FPoint[] controlPoints) {
        this.contours.add(new FContour(points, controlPoints));
    }

    public void addContour(FContour contour) {
        this.contours.add(contour);
    }

    public void setAdvanceWidth(int advanceWidth) {
        this.advanceWidth = advanceWidth;
    }

    public char getGlyphChar() {
        return this.glyphChar;
    }

    public int getAdvanceWidth() {
        return this.advanceWidth;
    }

    public List<FContour> getContours() {
        return this.contours;
    }

    public FContour[] getContoursArray() {
        FContour[] contoursArray = this.contours.toArray(new FContour[this.contours.size()]);
        return contoursArray;
    }

    public FContour getContour(int index) {
        return this.contours.get(index);
    }

    public int getContourCount() {
        return this.contours.size();
    }

    public void setContour(int index, FPoint[] points) {
        this.contours.set(index, new FContour(points));
    }

    public void setContour(int index, FContour contour) {
        this.contours.set(index, contour);
    }

    public void clearContours() {
        this.contours.clear();
    }
}

