/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.truetype;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.doubletype.ossa.truetype.CmapWriter;
import org.doubletype.ossa.truetype.FontFormatWriter;
import org.doubletype.ossa.truetype.GlyfWriter;
import org.doubletype.ossa.truetype.HdmxWriter;
import org.doubletype.ossa.truetype.HeadWriter;
import org.doubletype.ossa.truetype.HheaWriter;
import org.doubletype.ossa.truetype.HmtxWriter;
import org.doubletype.ossa.truetype.LocaWriter;
import org.doubletype.ossa.truetype.MaxpWriter;
import org.doubletype.ossa.truetype.NameWriter;
import org.doubletype.ossa.truetype.OS2Writer;
import org.doubletype.ossa.truetype.PostWriter;
import org.doubletype.ossa.truetype.TTGlyph;
import org.doubletype.ossa.truetype.TTUnicodeRange;

public class FontFileWriter
extends FontFormatWriter {
    private CmapWriter m_cmap;
    private GlyfWriter m_glyf;
    private LocaWriter m_loca;
    private HeadWriter m_head;
    private HdmxWriter m_hdmx;
    private HheaWriter m_hhea;
    private HmtxWriter m_hmtx;
    private MaxpWriter m_maxp;
    private NameWriter m_name;
    private PostWriter m_post;
    private OS2Writer m_os2;
    protected RandomAccessFile m_file;
    private ArrayList<FontFormatWriter> m_tables = new ArrayList();

    public FontFileWriter(RandomAccessFile a_file) {
        this.m_file = a_file;
        this.m_loca = new LocaWriter();
        this.m_maxp = new MaxpWriter();
        this.m_head = new HeadWriter();
        this.m_hdmx = new HdmxWriter();
        this.m_os2 = new OS2Writer(this.m_head);
        this.m_cmap = new CmapWriter(this.m_os2);
        this.m_glyf = new GlyfWriter(this.m_loca, this.m_maxp, this.m_head, this.m_hdmx);
        this.m_hhea = new HheaWriter(this.m_glyf, this.m_head);
        this.m_hmtx = new HmtxWriter(this.m_glyf, this.m_hhea);
        this.m_name = new NameWriter();
        this.m_post = new PostWriter();
        this.m_tables.add(this.m_head);
        this.m_tables.add(this.m_hhea);
        this.m_tables.add(this.m_maxp);
        this.m_tables.add(this.m_os2);
        this.m_tables.add(this.m_name);
        this.m_tables.add(this.m_cmap);
        this.m_tables.add(this.m_loca);
        this.m_tables.add(this.m_hmtx);
        this.m_tables.add(this.m_hdmx);
        this.m_tables.add(this.m_glyf);
        this.m_tables.add(this.m_post);
    }

    @Override
    public void write() throws IOException {
        this.m_cmap.write();
        this.m_hmtx.write();
        this.m_hhea.write();
        this.m_glyf.write();
        this.m_loca.write();
        this.m_head.setCheckSumAdjustment(0L);
        this.m_head.write();
        this.m_maxp.write();
        this.m_hdmx.write();
        this.m_name.write();
        this.m_post.write();
        this.m_os2.write();
        this.writeTableDirectory();
        byte[] tableDir = this.toByteArray();
        for (FontFormatWriter table : this.m_tables) {
            this.m_buffer.write(table.toByteArray());
        }
        long checkSum = -1313820742L - (0xFFFFFFFFFFFFFFFFL & this.getCheckSum());
        this.m_head.setCheckSumAdjustment(checkSum);
        this.m_head.reset();
        this.m_head.write();
        this.reset();
        this.m_buffer.write(tableDir);
        for (FontFormatWriter table : this.m_tables) {
            this.m_buffer.write(table.toByteArray());
        }
        this.m_file.write(this.toByteArray());
        this.m_file.close();
    }

    public void setAscent(int a_value) {
        this.m_os2.setTypoAscender(a_value);
        this.m_os2.setCapHeight(a_value);
    }

    public void setDescent(int a_value) {
        this.m_os2.setTypoDescender(-a_value);
    }

    public void setXHeight(int a_value) {
        this.m_os2.setXHeight(a_value);
    }

    public void setLineGap(int a_value) {
        this.m_os2.setTypoLineGap(a_value);
        this.m_hhea.setLineGap(a_value);
    }

    public void setFontFamilyName(String a_name) {
        this.m_name.m_familyName = a_name;
    }

    public void setCopyrightYear(String a_year) {
        this.m_name.m_year = a_year;
    }

    public void setManufacturer(String a_manufacturer) {
        this.m_name.m_manufacturer = a_manufacturer;
    }

    public void setFontVersion(String a_version) {
        this.m_name.m_version = a_version;
    }

    public void addUnicodeRange(TTUnicodeRange a_range) {
        this.m_cmap.addUnicodeRange(a_range);
    }

    public void setCodeRangeFlag(int a_codeRange) {
        this.m_os2.setCodePageRangeFlag(a_codeRange);
    }

    public int addGlyph(TTGlyph a_glyph) {
        return this.m_glyf.add(a_glyph);
    }

    public TTGlyph getGlyph(int a_index) {
        return this.m_glyf.getGlyph(a_index);
    }

    public void setCreationDate(Date a_date) {
        this.m_head.setCreationDate(a_date);
    }

    public void setModificationDate(Date a_date) {
        this.m_head.setModificationDate(a_date);
    }

    public void addCharacterMapping(long a_unicode, long a_glyfIndex) {
        this.m_cmap.addMapping(a_unicode, a_glyfIndex);
    }

    public long getCharacterMapping(long a_unicode) {
        return this.m_cmap.getGlyfIndex(new Long(a_unicode));
    }

    private void writeTableDirectory() throws IOException {
        int headerLength;
        int tableOffset = headerLength = this.m_tables.size() * 16 + 16;
        for (FontFormatWriter table : this.m_tables) {
            table.setOffset(tableOffset);
            tableOffset += table.size();
        }
        ArrayList tables = (ArrayList)this.m_tables.clone();
        Collections.sort(tables, new Comparator<FontFormatWriter>(){

            @Override
            public int compare(FontFormatWriter a_lhs, FontFormatWriter a_rhs) {
                return a_lhs.getTag().compareTo(a_rhs.getTag());
            }

            @Override
            public boolean equals(Object a_value) {
                return false;
            }
        });
        this.writeFixed32(1.0);
        int numOfTables = tables.size();
        this.writeUInt16(numOfTables);
        int searchRange = this.getSearchRange(numOfTables);
        this.writeUInt16(searchRange);
        int entrySelector = this.getEntrySelector(numOfTables);
        this.writeUInt16(entrySelector);
        this.writeUInt16(numOfTables * 16 - searchRange);
        for (FontFormatWriter table : tables) {
            this.writeTag(table.getTag());
            this.writeUInt32(table.getCheckSum());
            this.writeUInt32(table.getOffset());
            this.writeUInt32(table.size());
        }
        for (int i = 0; i < 4; ++i) {
            this.writeUInt8(0);
        }
    }

    private int getSearchRange(int a_value) {
        int retval = (int)Math.pow(2.0, Math.floor(Math.log(a_value) / Math.log(2.0)));
        return 16 * retval;
    }

    private int getEntrySelector(int a_value) {
        int retval = (int)Math.floor(Math.log(a_value) / Math.log(2.0));
        return retval;
    }
}

