/*
 * Decompiled with CFR 0.152.
 */
package dev.matrixlab.webp4j.animation;

import dev.matrixlab.webp4j.gif.GifToWebPConfig;
import dev.matrixlab.webp4j.internal.NativeWebP;
import dev.matrixlab.webp4j.internal.PixelConverter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class AnimatedWebPEncoder {
    private AnimatedWebPEncoder() {
        throw new AssertionError((Object)"Cannot instantiate utility class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encode(List<BufferedImage> frames, int[] delays, GifToWebPConfig config) throws IOException {
        if (frames == null || frames.isEmpty()) {
            throw new IllegalArgumentException("Frames list cannot be null or empty");
        }
        if (delays == null || delays.length != frames.size()) {
            throw new IllegalArgumentException("Delays array length must match frame count");
        }
        if (config == null) {
            config = new GifToWebPConfig();
        }
        BufferedImage firstFrame = frames.get(0);
        int width = firstFrame.getWidth();
        int height = firstFrame.getHeight();
        byte[][] frameData = new byte[frames.size()][];
        try {
            for (int i = 0; i < frames.size(); ++i) {
                BufferedImage frame = frames.get(i);
                if (frame.getWidth() != width || frame.getHeight() != height) {
                    throw new IllegalArgumentException(String.format("Frame %d dimensions (%dx%d) don't match canvas (%dx%d)", i, frame.getWidth(), frame.getHeight(), width, height));
                }
                frameData[i] = PixelConverter.toBytes(frame);
            }
            byte[] result = NativeWebP.encodeAnimatedWebP(frameData, delays, width, height, config.getQuality(), config.isLossless(), config.getCompressionMethod(), config.getLoopCount() == -1 ? 0 : config.getLoopCount(), config.getKmin(), config.getKmax(), config.isMinimizeSize(), config.isAllowMixed());
            if (result == null || result.length == 0) {
                throw new IOException("Animated WebP encoding failed");
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            for (byte[] frame : frameData) {
                if (frame == null) continue;
                Arrays.fill(frame, (byte)0);
            }
        }
    }

    public static byte[] encode(List<BufferedImage> frames, int delay, GifToWebPConfig config) throws IOException {
        if (frames == null || frames.isEmpty()) {
            throw new IllegalArgumentException("Frames list cannot be null or empty");
        }
        int[] delays = new int[frames.size()];
        Arrays.fill(delays, delay);
        return AnimatedWebPEncoder.encode(frames, delays, config);
    }
}

