/*
 * Decompiled with CFR 0.152.
 */
package dev.matrixlab.webp4j.animation;

import dev.matrixlab.webp4j.model.FitMode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public final class FrameNormalizer {
    private FrameNormalizer() {
        throw new AssertionError((Object)"Cannot instantiate utility class.");
    }

    public static List<BufferedImage> normalize(List<BufferedImage> frames) {
        return FrameNormalizer.normalize(frames, null, null, FitMode.CONTAIN, false, new Color(0, 0, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BufferedImage> normalize(List<BufferedImage> frames, Integer targetWidth, Integer targetHeight, FitMode fitMode, boolean allowUpscale, Color background) {
        int canvasH;
        if (frames == null || frames.isEmpty()) {
            throw new IllegalArgumentException("Frames list cannot be null or empty");
        }
        if (fitMode == null) {
            fitMode = FitMode.CONTAIN;
        }
        if (background == null) {
            background = new Color(0, 0, 0, 0);
        }
        int minW = Integer.MAX_VALUE;
        int minH = Integer.MAX_VALUE;
        boolean needMinDimensions = targetWidth == null || targetWidth <= 0 || targetHeight == null || targetHeight <= 0;
        for (BufferedImage img : frames) {
            if (img == null) {
                throw new IllegalArgumentException("Frame image cannot be null");
            }
            if (!needMinDimensions) continue;
            minW = Math.min(minW, img.getWidth());
            minH = Math.min(minH, img.getHeight());
        }
        int canvasW = targetWidth != null && targetWidth > 0 ? targetWidth : minW;
        int n = canvasH = targetHeight != null && targetHeight > 0 ? targetHeight : minH;
        if (canvasW <= 0 || canvasH <= 0) {
            throw new IllegalArgumentException("Invalid target canvas size");
        }
        ArrayList<BufferedImage> out = new ArrayList<BufferedImage>(frames.size());
        for (BufferedImage src : frames) {
            Graphics2D g2d;
            int sw = src.getWidth();
            int sh = src.getHeight();
            if (sw == canvasW && sh == canvasH && fitMode != FitMode.COVER) {
                BufferedImage copy = new BufferedImage(canvasW, canvasH, 2);
                g2d = copy.createGraphics();
                try {
                    g2d.drawImage((Image)src, 0, 0, null);
                }
                finally {
                    g2d.dispose();
                }
                out.add(copy);
                continue;
            }
            BufferedImage canvas = new BufferedImage(canvasW, canvasH, 2);
            g2d = canvas.createGraphics();
            try {
                int dy;
                int dx;
                int dh;
                int dw;
                g2d.setComposite(AlphaComposite.Src);
                g2d.setColor(background);
                g2d.fillRect(0, 0, canvasW, canvasH);
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                switch (fitMode) {
                    case COVER: {
                        double scale = Math.max((double)canvasW / (double)sw, (double)canvasH / (double)sh);
                        if (!allowUpscale) {
                            scale = Math.min(1.0, scale);
                        }
                        dw = Math.max(1, (int)Math.round((double)sw * scale));
                        dh = Math.max(1, (int)Math.round((double)sh * scale));
                        dx = (canvasW - dw) / 2;
                        dy = (canvasH - dh) / 2;
                        break;
                    }
                    case STRETCH: {
                        if (allowUpscale) {
                            dw = canvasW;
                            dh = canvasH;
                            dx = 0;
                            dy = 0;
                            break;
                        }
                        dw = Math.min(canvasW, sw);
                        dh = Math.min(canvasH, sh);
                        dx = (canvasW - dw) / 2;
                        dy = (canvasH - dh) / 2;
                        break;
                    }
                    default: {
                        double scale = Math.min((double)canvasW / (double)sw, (double)canvasH / (double)sh);
                        if (!allowUpscale) {
                            scale = Math.min(1.0, scale);
                        }
                        dw = Math.max(1, (int)Math.round((double)sw * scale));
                        dh = Math.max(1, (int)Math.round((double)sh * scale));
                        dx = (canvasW - dw) / 2;
                        dy = (canvasH - dh) / 2;
                        break;
                    }
                }
                g2d.drawImage(src, dx, dy, dw, dh, null);
            }
            finally {
                g2d.dispose();
            }
            out.add(canvas);
        }
        return out;
    }
}

