/*
 * Decompiled with CFR 0.152.
 */
package dev.matrixlab.webp4j.gif;

import dev.matrixlab.webp4j.gif.GifDecoderJava;
import dev.matrixlab.webp4j.gif.GifToWebPConfig;
import dev.matrixlab.webp4j.internal.NativeWebP;
import dev.matrixlab.webp4j.internal.PixelConverter;
import dev.matrixlab.webp4j.model.AnimationInfo;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Supplier;

public final class GifToWebPConverter {
    private GifToWebPConverter() {
        throw new AssertionError((Object)"Cannot instantiate utility class.");
    }

    public static AnimationInfo getInfo(byte[] gifData) throws IOException {
        boolean success2;
        if (gifData == null || gifData.length == 0) {
            throw new IllegalArgumentException("GIF data cannot be null or empty");
        }
        AnimationInfo info = new AnimationInfo();
        try {
            success2 = NativeWebP.getGifInfo(gifData, info);
            if (success2) {
                return info;
            }
        }
        catch (UnsatisfiedLinkError success2) {
            // empty catch block
        }
        success2 = GifDecoderJava.getGifInfo(gifData, info);
        if (!success2) {
            throw new IOException("Failed to read GIF information");
        }
        return info;
    }

    public static byte[] convert(byte[] gifData) throws IOException {
        return GifToWebPConverter.convert(gifData, new GifToWebPConfig());
    }

    public static byte[] convert(byte[] gifData, GifToWebPConfig config) throws IOException {
        if (gifData == null || gifData.length == 0) {
            throw new IllegalArgumentException("GIF data cannot be null or empty");
        }
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        byte[] result = null;
        try {
            result = NativeWebP.encodeGifToWebP(gifData, config.getQuality(), config.isLossless(), config.getCompressionMethod(), config.isExtractFirstFrameOnly(), config.getLoopCount() == -1 ? ((Supplier<Integer>)() -> {
                try {
                    return GifToWebPConverter.getInfo(gifData).getLoopCount();
                }
                catch (Exception e) {
                    return 0;
                }
            }).get().intValue() : config.getLoopCount(), config.getKmin(), config.getKmax(), config.isMinimizeSize(), config.isAllowMixed());
            if (result != null && result.length > 0) {
                return result;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        if (result == null) {
            return GifToWebPConverter.convertUsingJavaImageIO(gifData, config);
        }
        throw new IOException("Native GIF encoding returned empty result");
    }

    public static byte[] convertLossless(byte[] gifData) throws IOException {
        return GifToWebPConverter.convert(gifData, GifToWebPConfig.createLosslessConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertUsingJavaImageIO(byte[] gifData, GifToWebPConfig config) throws IOException {
        GifDecoderJava.GifData gif = GifDecoderJava.decodeGif(gifData);
        if (config.isExtractFirstFrameOnly() || gif.frames.size() == 1) {
            BufferedImage firstFrame = gif.frames.get((int)0).image;
            return GifToWebPConverter.encodeSingleFrame(firstFrame, config.getQuality(), config.isLossless());
        }
        byte[][] frameData = new byte[gif.frames.size()][];
        int[] delays = new int[gif.frames.size()];
        BufferedImage canvas = new BufferedImage(gif.width, gif.height, 2);
        BufferedImage previousFrame = null;
        try {
            for (int i = 0; i < gif.frames.size(); ++i) {
                previousFrame = GifToWebPConverter.composeFrame(gif, i, canvas, previousFrame);
                frameData[i] = PixelConverter.toBytes(canvas);
                delays[i] = gif.frames.get((int)i).delayMs;
            }
            byte[] result = NativeWebP.encodeAnimatedWebP(frameData, delays, gif.width, gif.height, config.getQuality(), config.isLossless(), config.getCompressionMethod(), config.getLoopCount() == -1 ? gif.loopCount : config.getLoopCount(), config.getKmin(), config.getKmax(), config.isMinimizeSize(), config.isAllowMixed());
            if (result == null || result.length == 0) {
                throw new IOException("Animated WebP encoding failed");
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            for (byte[] frame : frameData) {
                if (frame == null) continue;
                Arrays.fill(frame, (byte)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] encodeSingleFrame(BufferedImage image, float quality, boolean lossless) throws IOException {
        byte[] imageBytes = PixelConverter.toBytes(image);
        if (imageBytes.length == 0) {
            throw new IOException("Failed to convert BufferedImage to a byte array.");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        boolean hasAlpha = image.getColorModel().hasAlpha();
        int stride = width * (hasAlpha ? 4 : 3);
        try {
            byte[] result;
            if (lossless) {
                result = hasAlpha ? NativeWebP.encodeLosslessRGBA(imageBytes, width, height, stride) : NativeWebP.encodeLosslessRGB(imageBytes, width, height, stride);
            } else {
                byte[] byArray = result = hasAlpha ? NativeWebP.encodeRGBA(imageBytes, width, height, stride, quality) : NativeWebP.encodeRGB(imageBytes, width, height, stride, quality);
            }
            if (result == null || result.length == 0) {
                throw new IOException("WebP encoding failed.");
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            Arrays.fill(imageBytes, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage composeFrame(GifDecoderJava.GifData gif, int frameIndex, BufferedImage canvas, BufferedImage previousFrame) {
        Graphics2D g2d;
        Graphics2D g2d2;
        GifDecoderJava.GifFrame frame = gif.frames.get(frameIndex);
        if (frameIndex > 0 && gif.frames.get((int)(frameIndex - 1)).disposeMethod == 2) {
            g2d2 = canvas.createGraphics();
            try {
                g2d2.setComposite(AlphaComposite.Clear);
                GifDecoderJava.GifFrame prevFrame = gif.frames.get(frameIndex - 1);
                g2d2.fillRect(prevFrame.leftOffset, prevFrame.topOffset, prevFrame.image.getWidth(), prevFrame.image.getHeight());
            }
            finally {
                g2d2.dispose();
            }
        }
        if (frameIndex > 0 && gif.frames.get((int)(frameIndex - 1)).disposeMethod == 3 && previousFrame != null) {
            g2d2 = canvas.createGraphics();
            try {
                g2d2.setComposite(AlphaComposite.Src);
                g2d2.drawImage((Image)previousFrame, 0, 0, null);
            }
            finally {
                g2d2.dispose();
            }
        }
        BufferedImage updatedPreviousFrame = previousFrame;
        if (frameIndex < gif.frames.size() - 1 && frame.disposeMethod == 3) {
            updatedPreviousFrame = new BufferedImage(gif.width, gif.height, 2);
            g2d = updatedPreviousFrame.createGraphics();
            try {
                g2d.drawImage((Image)canvas, 0, 0, null);
            }
            finally {
                g2d.dispose();
            }
        }
        g2d = canvas.createGraphics();
        try {
            g2d.setComposite(AlphaComposite.SrcOver);
            g2d.drawImage((Image)frame.image, frame.leftOffset, frame.topOffset, null);
        }
        finally {
            g2d.dispose();
        }
        return updatedPreviousFrame;
    }
}

