/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash;

import com.jpexs.debugger.flash.DebugConnectionListener;
import com.jpexs.debugger.flash.DebugMessageListener;
import com.jpexs.debugger.flash.DebuggerCommands;
import com.jpexs.debugger.flash.DebuggerConnection;
import com.jpexs.debugger.flash.messages.in.InAskBreakpoints;
import com.jpexs.debugger.flash.messages.in.InBreakAt;
import com.jpexs.debugger.flash.messages.in.InBreakReason;
import com.jpexs.debugger.flash.messages.in.InNumScript;
import com.jpexs.debugger.flash.messages.in.InScript;
import com.jpexs.debugger.flash.messages.in.InSwfInfo;
import com.jpexs.debugger.flash.messages.out.OutGetBreakReason;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Debugger {
    private final List<DebuggerConnection> connections;
    public static final int DEBUG_PORT = 7935;
    private ServerSocket ssock;
    private boolean stopped = true;
    private Thread thread;
    private List<DebugConnectionListener> listeners = new ArrayList<DebugConnectionListener>();

    public void addConnectionListener(DebugConnectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionListener(DebugConnectionListener listener) {
        this.listeners.remove(listener);
    }

    private void initThread() {
        this.thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Debugger debugger = Debugger.this;
                    synchronized (debugger) {
                        Debugger.this.ssock = new ServerSocket(7935, 0, InetAddress.getByName("localhost"));
                    }
                    while (!Debugger.this.isStopped() && !this.isInterrupted()) {
                        Logger.getLogger(Debugger.class.getName()).log(Level.FINE, "Waiting for a client...");
                        Socket s = Debugger.this.ssock.accept();
                        Logger.getLogger(Debugger.class.getName()).log(Level.FINE, "New client connected");
                        s.setTcpNoDelay(true);
                        DebuggerConnection dc = new DebuggerConnection(s);
                        Debugger.this.connections.add(dc);
                        dc.start();
                        for (DebugConnectionListener listener : Debugger.this.listeners) {
                            listener.connected(dc);
                        }
                    }
                }
                catch (IOException ex) {
                    if (!Debugger.this.isStopped()) {
                        Logger.getLogger(Debugger.class.getName()).log(Level.FINE, "Cannot listen: " + ex.getMessage());
                        Debugger.this.stopDebugger();
                        for (DebugConnectionListener listener : Debugger.this.listeners) {
                            listener.failedListen(ex);
                        }
                    }
                    return;
                }
            }
        };
    }

    public Debugger() throws IOException {
        this.connections = new ArrayList<DebuggerConnection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDebugger() {
        if (!this.isStopped()) {
            this.stopDebugger();
        }
        Logger.getLogger(Debugger.class.getName()).log(Level.FINE, "Starting server");
        this.initThread();
        this.thread.start();
        Debugger debugger = this;
        synchronized (debugger) {
            this.stopped = false;
        }
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDebugger() {
        boolean stopNow = false;
        Debugger debugger = this;
        synchronized (debugger) {
            if (!this.stopped) {
                stopNow = true;
            }
            this.stopped = true;
        }
        if (stopNow && this.ssock != null) {
            try {
                this.ssock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ssock = null;
        }
        this.thread = null;
    }

    public static void main(String[] args) throws IOException {
        Level level = Level.FINEST;
        Logger rootLog = Logger.getLogger("");
        rootLog.setLevel(level);
        rootLog.getHandlers()[0].setLevel(level);
        Debugger d = new Debugger();
        d.addConnectionListener(new DebugConnectionListener(){

            @Override
            public void failedListen(IOException ex) {
            }

            @Override
            public void connected(final DebuggerConnection con) {
                final DebuggerCommands dc = new DebuggerCommands(con);
                try {
                    dc.stopWarning();
                    dc.setStopOnFault();
                    dc.setEnumerateOverride();
                    dc.setNotifyFailure();
                    dc.setInvokeSetters();
                    dc.setSwfLoadNotify();
                    dc.setGetterTimeout(1500);
                    dc.setSetterTimeout(5000);
                    dc.squelch(true);
                    List<InSwfInfo.SwfInfo> swfs = dc.getSwfInfo(1);
                    final HashMap moduleNames = new HashMap();
                    con.addMessageListener(new DebugMessageListener<InNumScript>(){

                        @Override
                        public void message(InNumScript message) {
                        }
                    });
                    con.addMessageListener(new DebugMessageListener<InScript>(){

                        @Override
                        public void message(InScript sc) {
                            moduleNames.put(sc.module, sc.name);
                        }
                    });
                    con.addMessageListener(new DebugMessageListener<InAskBreakpoints>(){

                        @Override
                        public void message(InAskBreakpoints message) {
                            con.dropMessage(message);
                        }
                    });
                    con.addMessageListener(new DebugMessageListener<InBreakAt>(){

                        @Override
                        public void message(InBreakAt bra) {
                            try {
                                InBreakReason ibr = con.sendMessage(new OutGetBreakReason(con), InBreakReason.class);
                                if (ibr.reason != InBreakReason.REASON_SCRIPT_LOADED) {
                                    if (moduleNames.containsKey(bra.file)) {
                                        System.out.println((String)moduleNames.get(bra.file) + ":" + bra.line);
                                    } else {
                                        System.out.println("unknown:" + bra.line);
                                    }
                                }
                                dc.stepInto();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (IOException ex) {
                    System.err.println("FAILED to communicate");
                }
            }
        });
        d.startDebugger();
    }
}

