import{j as jsxRuntimeExports,d as dayjs}from"./greenbone-ui-lib-BNbcIzcW.js";import{f as createDisplay,g as DataTableDisplay,r as registerDisplay,p as percent,H as ordinal,n as DataDisplay,m as linear,h as Dashboard}from"./utils-CV5w5LU4.js";import{a4 as Filter,cD as TICKETS_FILTER_FILTER,_ as _l,k as Theme,m as _,cE as getTranslatableTicketStatus,cF as TICKET_STATUS}from"./index-Gbh6LuHL.js";import{C as CreatedDisplay}from"./CreatedDisplay-BmxgucIc.js";import{L as Loader,l as loadFunc,a as loaderPropTypes}from"./loader-C4J74YJn.js";import{f as formattedUserSettingShortDate}from"./user-setting-time-date-formatters-BGF34wEN.js";import{S as StatusDisplay}from"./StatusDisplay-DFc8xS-W.js";import{B as BubbleChart}from"./Bubble-C8ovpaHJ.js";const DEFAULT_FILTER=Filter.fromString("sort-reverse=modified"),ticketsListLoader=loadFunc((({gmp:gmp,filter:filter=DEFAULT_FILTER})=>gmp.tickets.getAll({filter:filter}).then((r=>r.data))),"tickets-list"),TicketsListLoader=({children:children,filter:filter})=>jsxRuntimeExports.jsx(Loader,{dataId:"tickets-list",filter:filter,load:ticketsListLoader,subscriptions:["tickets.timer","tickets.changed"],children:children});TicketsListLoader.propTypes=loaderPropTypes;const transfromCreated=(tickets=[])=>{const dates=tickets.reduce(((prev,ticket)=>{const timestamp=+ticket.creationTime.startOf("day"),count=prev[timestamp]||0;return prev[timestamp]=count+1,prev}),{});let sum=0;return Object.entries(dates).sort(((a,b)=>a[0]-b[0])).map((([timestamp,count])=>(sum+=count,{x:dayjs(+timestamp),y:count,y2:sum})))},TicketsCreatedDisplay=createDisplay({dataTransform:transfromCreated,displayId:"tickets-by-created",displayName:"TicketsCreatedDisplay",displayComponent:CreatedDisplay,filtersFilter:TICKETS_FILTER_FILTER,loaderComponent:TicketsListLoader,title:()=>_("Tickets by Creation Time"),yAxisLabel:_l("# of created Tickets"),y2AxisLabel:_l("Total Tickets"),xAxisLabel:_l("Time"),yLine:{color:Theme.darkGreenTransparent,label:_l("Created Tickets")},y2Line:{color:Theme.darkGreenTransparent,dashArray:"3, 2",label:_l("Total Tickets")}}),TicketsCreatedTableDisplay=createDisplay({dataRow:row=>[row.y,row.y2,formattedUserSettingShortDate(row.x)],dataTitles:[_l("Created Tickets"),_l("Total Tickets"),_l("Time")],dataTransform:transfromCreated,displayComponent:DataTableDisplay,displayId:"tickets-by-created-table",displayName:"TicketsCreatedTableDisplay",filtersFilter:TICKETS_FILTER_FILTER,loaderComponent:TicketsListLoader,title:({data:tdata={}})=>_("Tickets by Creation Time (Total: {{count}})",{count:tdata.total})});registerDisplay(TicketsCreatedDisplay.displayId,TicketsCreatedDisplay,{title:_l("Chart: Tickets by Creation Time")}),registerDisplay(TicketsCreatedTableDisplay.displayId,TicketsCreatedTableDisplay,{title:_l("Table: Tickets by Creation Time")});const ticketStatusColorScale=ordinal().domain(Object.values(TICKET_STATUS).sort()).range([Theme.lightGray,"#f0a519","#2ca02c",Theme.warningRed]),transformStatusData=(tickets=[])=>{const groups=tickets.reduce(((prev,ticket)=>{const count=prev[ticket.status]||0;return prev[ticket.status]=count+1,prev}),{}),tdata=Object.entries(groups).map((([value,count])=>{const perc=percent(count,tickets.length),label=getTranslatableTicketStatus(value);return{value:count,label:label,toolTip:"".concat(label,": ").concat(perc,"% (").concat(count,")"),color:ticketStatusColorScale(value),filterValue:value}}));return tdata.total=tickets.length,tdata},TicketsStatusDisplay=createDisplay({dataTransform:transformStatusData,displayComponent:StatusDisplay,displayId:"tickets-by-status",title:({data:tdata})=>_("Tickets by Status (Total: {{count}})",{count:tdata.total}),filtersFilter:TICKETS_FILTER_FILTER,loaderComponent:TicketsListLoader}),TicketsStatusTableDisplay=createDisplay({dataRow:row=>[row.label,row.value],dataTitles:[_l("Status"),_l("# of Tickets")],dataTransform:transformStatusData,displayComponent:DataTableDisplay,displayId:"tickets-by-status-table",displayName:"TicketsStatusTableDisplay",filtersFilter:TICKETS_FILTER_FILTER,loaderComponent:TicketsListLoader,title:({data:tdata={}})=>_("Tickets by Status (Total: {{count}})",{count:tdata.total})});registerDisplay(TicketsStatusDisplay.displayId,TicketsStatusDisplay,{title:_l("Chart: Tickets by Status")}),registerDisplay(TicketsStatusTableDisplay.displayId,TicketsStatusTableDisplay,{title:_l("Table: Tickets by Status")});const assignedUserColorScale=linear().domain([0,.05,.25,.5,.75,.95,1]).range(["#008644","#55B200","#94D800","#E6E600","#EDBA00","#EC6E00","#D63900"]),transformUserAssignedData=(tickets=[])=>{const groups=tickets.reduce(((prev,ticket)=>{const username=ticket.assignedTo.name,count=prev[username]||0;return prev[username]=count+1,prev}),{}),tdata=Object.entries(groups).map((([value,count])=>({value:count,label:value,toolTip:"".concat(value,": ").concat(count),color:assignedUserColorScale(count/tickets.length),filterValue:value})));return tdata.total=tickets.length,tdata},TicketsAssignedUsersDisplay=createDisplay({chartComponent:BubbleChart,dataTransform:transformUserAssignedData,displayComponent:DataDisplay,displayId:"tickets-by-assigned-users",displayName:"TicketsAssignedUsersDisplay",filtersFilter:TICKETS_FILTER_FILTER,loaderComponent:TicketsListLoader,title:({data:tdata})=>_("Tickets by Assigned User (Total: {{total}})",tdata),showToggleLegend:!1}),TicketsAssignedUsersTableDisplay=createDisplay({dataRow:row=>[row.label,row.value],dataTitles:[_l("Assigned To"),_l("# of Tickets")],dataTransform:transformUserAssignedData,displayComponent:DataTableDisplay,displayId:"tickets-by-assigned-users-table",displayName:"TicketsAssignedUsersTableDisplay",filtersFilter:TICKETS_FILTER_FILTER,loaderComponent:TicketsListLoader,title:({data:tdata={}})=>_("Tickets by Assigned User (Total: {{total}})",tdata)});registerDisplay(TicketsAssignedUsersDisplay.displayId,TicketsAssignedUsersDisplay,{title:_l("Chart: Tickets by Assigned User")}),registerDisplay(TicketsAssignedUsersTableDisplay.displayId,TicketsAssignedUsersTableDisplay,{title:_l("Table: Tickets by Assigned User")});const TICKETS_DASHBOARD_ID="70b0626f-a835-478e-8194-e09f97887a15",TICKETS_DISPLAYS=[TicketsAssignedUsersDisplay.displayId,TicketsCreatedDisplay.displayId,TicketsStatusDisplay.displayId,TicketsAssignedUsersTableDisplay.displayId,TicketsCreatedTableDisplay.displayId,TicketsStatusTableDisplay.displayId],TicketsDashboard=props=>jsxRuntimeExports.jsx(Dashboard,{...props,defaultDisplays:[[TicketsStatusDisplay.displayId,TicketsAssignedUsersDisplay.displayId,TicketsCreatedDisplay.displayId]],id:"70b0626f-a835-478e-8194-e09f97887a15",permittedDisplays:TICKETS_DISPLAYS});export{TICKETS_DISPLAYS as T,TICKETS_DASHBOARD_ID as a,TicketsDashboard as b};
