"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HomebridgeAPI = exports.InternalAPIEvent = exports.APIEvent = exports.PluginType = void 0;
const events_1 = require("events");
const hapNodeJs = __importStar(require("hap-nodejs"));
const semver_1 = __importDefault(require("semver"));
const logger_1 = require("./logger");
const platformAccessory_1 = require("./platformAccessory");
const pluginManager_1 = require("./pluginManager");
const user_1 = require("./user");
const version_1 = __importDefault(require("./version"));
const log = logger_1.Logger.internal;
var PluginType;
(function (PluginType) {
    PluginType["ACCESSORY"] = "accessory";
    PluginType["PLATFORM"] = "platform";
})(PluginType || (exports.PluginType = PluginType = {}));
var APIEvent;
(function (APIEvent) {
    /**
     * Event is fired once homebridge has finished with booting up and initializing all components and plugins.
     * When this event is fired it is possible that the Bridge accessory isn't published yet, if homebridge still needs
     * to wait for some {@see StaticPlatformPlugin | StaticPlatformPlugins} to finish accessory creation.
     */
    APIEvent["DID_FINISH_LAUNCHING"] = "didFinishLaunching";
    /**
     * This event is fired when homebridge gets shutdown. This could be a regular shutdown or an unexpected crash.
     * At this stage all Accessories are already unpublished and all PlatformAccessories are already saved to disk!
     */
    APIEvent["SHUTDOWN"] = "shutdown";
})(APIEvent || (exports.APIEvent = APIEvent = {}));
var InternalAPIEvent;
(function (InternalAPIEvent) {
    InternalAPIEvent["REGISTER_ACCESSORY"] = "registerAccessory";
    InternalAPIEvent["REGISTER_PLATFORM"] = "registerPlatform";
    InternalAPIEvent["PUBLISH_EXTERNAL_ACCESSORIES"] = "publishExternalAccessories";
    InternalAPIEvent["REGISTER_PLATFORM_ACCESSORIES"] = "registerPlatformAccessories";
    InternalAPIEvent["UPDATE_PLATFORM_ACCESSORIES"] = "updatePlatformAccessories";
    InternalAPIEvent["UNREGISTER_PLATFORM_ACCESSORIES"] = "unregisterPlatformAccessories";
})(InternalAPIEvent || (exports.InternalAPIEvent = InternalAPIEvent = {}));
class HomebridgeAPI extends events_1.EventEmitter {
    version = 2.7; // homebridge API version
    serverVersion = (0, version_1.default)(); // homebridge node module version
    // ------------------ LEGACY EXPORTS FOR PRE TYPESCRIPT  ------------------
    user = user_1.User;
    hap = hapNodeJs;
    hapLegacyTypes = hapNodeJs.LegacyTypes; // used for older accessories/platforms
    platformAccessory = platformAccessory_1.PlatformAccessory;
    // ------------------------------------------------------------------------
    constructor() {
        super();
    }
    versionGreaterOrEqual(version) {
        return semver_1.default.gte(this.serverVersion, version);
    }
    static isDynamicPlatformPlugin(platformPlugin) {
        return "configureAccessory" in platformPlugin;
    }
    static isStaticPlatformPlugin(platformPlugin) {
        return "accessories" in platformPlugin;
    }
    signalFinished() {
        this.emit("didFinishLaunching" /* APIEvent.DID_FINISH_LAUNCHING */);
    }
    signalShutdown() {
        this.emit("shutdown" /* APIEvent.SHUTDOWN */);
    }
    registerAccessory(pluginIdentifier, accessoryName, constructor) {
        if (typeof accessoryName === "function") {
            constructor = accessoryName;
            accessoryName = pluginIdentifier;
            this.emit("registerAccessory" /* InternalAPIEvent.REGISTER_ACCESSORY */, accessoryName, constructor);
        }
        else {
            this.emit("registerAccessory" /* InternalAPIEvent.REGISTER_ACCESSORY */, accessoryName, constructor, pluginIdentifier);
        }
    }
    registerPlatform(pluginIdentifier, platformName, constructor) {
        if (typeof platformName === "function") {
            constructor = platformName;
            platformName = pluginIdentifier;
            this.emit("registerPlatform" /* InternalAPIEvent.REGISTER_PLATFORM */, platformName, constructor);
        }
        else {
            this.emit("registerPlatform" /* InternalAPIEvent.REGISTER_PLATFORM */, platformName, constructor, pluginIdentifier);
        }
    }
    publishCameraAccessories(pluginIdentifier, accessories) {
        this.publishExternalAccessories(pluginIdentifier, accessories);
    }
    publishExternalAccessories(pluginIdentifier, accessories) {
        if (!pluginManager_1.PluginManager.isQualifiedPluginIdentifier(pluginIdentifier)) {
            log.info(`One of your plugins incorrectly registered an external accessory using the platform name (${pluginIdentifier}) and not the plugin identifier. Please report this to the developer!`);
        }
        accessories.forEach(accessory => {
            // noinspection SuspiciousTypeOfGuard
            if (!(accessory instanceof platformAccessory_1.PlatformAccessory)) {
                throw new Error(`${pluginIdentifier} attempt to register an accessory that isn't PlatformAccessory!`);
            }
            accessory._associatedPlugin = pluginIdentifier;
        });
        this.emit("publishExternalAccessories" /* InternalAPIEvent.PUBLISH_EXTERNAL_ACCESSORIES */, accessories);
    }
    registerPlatformAccessories(pluginIdentifier, platformName, accessories) {
        accessories.forEach(accessory => {
            // noinspection SuspiciousTypeOfGuard
            if (!(accessory instanceof platformAccessory_1.PlatformAccessory)) {
                throw new Error(`${pluginIdentifier} - ${platformName} attempt to register an accessory that isn't PlatformAccessory!`);
            }
            accessory._associatedPlugin = pluginIdentifier;
            accessory._associatedPlatform = platformName;
        });
        this.emit("registerPlatformAccessories" /* InternalAPIEvent.REGISTER_PLATFORM_ACCESSORIES */, accessories);
    }
    updatePlatformAccessories(accessories) {
        this.emit("updatePlatformAccessories" /* InternalAPIEvent.UPDATE_PLATFORM_ACCESSORIES */, accessories);
    }
    unregisterPlatformAccessories(pluginIdentifier, platformName, accessories) {
        accessories.forEach(accessory => {
            // noinspection SuspiciousTypeOfGuard
            if (!(accessory instanceof platformAccessory_1.PlatformAccessory)) {
                throw new Error(`${pluginIdentifier} - ${platformName} attempt to unregister an accessory that isn't PlatformAccessory!`);
            }
        });
        this.emit("unregisterPlatformAccessories" /* InternalAPIEvent.UNREGISTER_PLATFORM_ACCESSORIES */, accessories);
    }
}
exports.HomebridgeAPI = HomebridgeAPI;
//# sourceMappingURL=api.js.map