"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlatformAccessory = exports.PlatformAccessoryEvent = void 0;
const events_1 = require("events");
const hap_nodejs_1 = require("hap-nodejs");
var PlatformAccessoryEvent;
(function (PlatformAccessoryEvent) {
    PlatformAccessoryEvent["IDENTIFY"] = "identify";
})(PlatformAccessoryEvent || (exports.PlatformAccessoryEvent = PlatformAccessoryEvent = {}));
class PlatformAccessory extends events_1.EventEmitter {
    // somewhat ugly way to inject custom Accessory object, while not changing the publicly exposed constructor signature
    static injectedAccessory;
    _associatedPlugin; // present as soon as it is registered
    _associatedPlatform; // not present for external accessories
    _associatedHAPAccessory;
    // ---------------- HAP Accessory mirror ----------------
    displayName;
    UUID;
    category;
    services = [];
    /**
     * @deprecated reachability has no effect and isn't supported anymore
     */
    reachable = false;
    // ------------------------------------------------------
    /**
     * This is a way for Plugin developers to store custom data with their accessory
     */
    context = {}; // providing something to store
    constructor(displayName, uuid, category) {
        super();
        this._associatedHAPAccessory = PlatformAccessory.injectedAccessory
            ? PlatformAccessory.injectedAccessory
            : new hap_nodejs_1.Accessory(displayName, uuid);
        if (category) {
            this._associatedHAPAccessory.category = category;
        }
        this.displayName = this._associatedHAPAccessory.displayName;
        this.UUID = this._associatedHAPAccessory.UUID;
        this.category = category || 1 /* Categories.OTHER */;
        this.services = this._associatedHAPAccessory.services;
        // forward identify event
        this._associatedHAPAccessory.on("identify" /* AccessoryEventTypes.IDENTIFY */, (paired, callback) => {
            // eslint-disable-next-line @typescript-eslint/ban-ts-comment
            // @ts-ignore
            // eslint-disable-next-line @typescript-eslint/no-empty-function
            this.emit("identify" /* PlatformAccessoryEvent.IDENTIFY */, paired, () => { }); // empty callback for backwards compatibility
            callback();
        });
    }
    updateDisplayName(name) {
        if (name) {
            this.displayName = name;
            this._associatedHAPAccessory.displayName = name;
        }
    }
    addService(service, ...constructorArgs) {
        // @ts-expect-error: while the HAP-NodeJS interface was refined, the underlying implementation
        //  still only operates on an any[] array. Therefore, do not require any additional checks here
        //  we force the parameter unpack with expecting a ts-error.
        return this._associatedHAPAccessory.addService(service, ...constructorArgs);
    }
    removeService(service) {
        this._associatedHAPAccessory.removeService(service);
    }
    getService(name) {
        return this._associatedHAPAccessory.getService(name);
    }
    /**
     *
     * @param uuid
     * @param subType
     * @deprecated use {@link getServiceById} directly
     */
    getServiceByUUIDAndSubType(uuid, subType) {
        return this.getServiceById(uuid, subType);
    }
    getServiceById(uuid, subType) {
        return this._associatedHAPAccessory.getServiceById(uuid, subType);
    }
    /**
     *
     * @param reachable
     * @deprecated reachability has no effect and isn't supported anymore
     */
    updateReachability(reachable) {
        this.reachable = reachable;
    }
    /**
     *
     * @param cameraSource
     * @deprecated see {@link https://developers.homebridge.io/HAP-NodeJS/classes/accessory.html#configurecamerasource | Accessory.configureCameraSource}
     */
    configureCameraSource(cameraSource) {
        return this._associatedHAPAccessory.configureCameraSource(cameraSource);
    }
    /**
     * Configures a new controller for the given accessory.
     * See {@link https://developers.homebridge.io/HAP-NodeJS/classes/accessory.html#configurecontroller | Accessory.configureController}.
     *
     * @param controller
     */
    configureController(controller) {
        this._associatedHAPAccessory.configureController(controller);
    }
    /**
     * Removes a configured controller from the given accessory.
     * See {@link https://developers.homebridge.io/HAP-NodeJS/classes/accessory.html#removecontroller | Accessory.removeController}.
     *
     * @param controller
     */
    removeController(controller) {
        this._associatedHAPAccessory.removeController(controller);
    }
    // private
    static serialize(accessory) {
        accessory._associatedHAPAccessory.displayName = accessory.displayName;
        return {
            plugin: accessory._associatedPlugin,
            platform: accessory._associatedPlatform,
            context: accessory.context,
            ...hap_nodejs_1.Accessory.serialize(accessory._associatedHAPAccessory),
        };
    }
    static deserialize(json) {
        const accessory = hap_nodejs_1.Accessory.deserialize(json);
        PlatformAccessory.injectedAccessory = accessory;
        const platformAccessory = new PlatformAccessory(accessory.displayName, accessory.UUID);
        PlatformAccessory.injectedAccessory = undefined;
        platformAccessory._associatedPlugin = json.plugin;
        platformAccessory._associatedPlatform = json.platform;
        platformAccessory.context = json.context;
        platformAccessory.category = json.category;
        return platformAccessory;
    }
}
exports.PlatformAccessory = PlatformAccessory;
//# sourceMappingURL=platformAccessory.js.map