#include_next <drm/display/drm_dp.h>
#ifndef __BACKPORT_DRM_DP_H__
#define __BACKPORT_DRM_DP_H__

#if LINUX_VERSION_CODE < KERNEL_VERSION(6, 15, 0)
# define DP_EDP_15			    0x06    /* eDP 1.5 */
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(6, 16, 0)
# define DP_EDP_SMOOTH_BRIGHTNESS_CAPABLE		(1 << 6) /* eDP 2.0 */
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(6, 17, 0)
#define DP_PANEL_REPLAY_CAP_SUPPORT			0x0b0  /* DP 2.0 */
#define DP_PANEL_REPLAY_CAP_SIZE	7

#define DP_PANEL_REPLAY_CAP_CAPABILITY					0xb1
# define DP_PANEL_REPLAY_DSC_DECODE_CAPABILITY_IN_PR_SHIFT			1 /* DP 2.1a */
# define DP_PANEL_REPLAY_DSC_DECODE_CAPABILITY_IN_PR_MASK			(3 << DP_PANEL_REPLAY_DSC_DECODE_CAPABILITY_IN_PR_SHIFT)
# define DP_DSC_DECODE_CAPABILITY_IN_PR_SUPPORTED				0x00
# define DP_DSC_DECODE_CAPABILITY_IN_PR_FULL_FRAME_ONLY				0x01
# define DP_DSC_DECODE_CAPABILITY_IN_PR_NOT_SUPPORTED				0x02
# define DP_DSC_DECODE_CAPABILITY_IN_PR_RESERVED				0x03
# define DP_PANEL_REPLAY_ASYNC_VIDEO_TIMING_NOT_SUPPORTED_IN_PR			(1 << 3)
# define DP_PANEL_REPLAY_DSC_CRC_OF_MULTIPLE_SUS_SUPPORTED			(1 << 4)
# define DP_PANEL_REPLAY_SU_GRANULARITY_REQUIRED				(1 << 5)
# define DP_PANEL_REPLAY_SU_Y_GRANULARITY_EXTENDED_CAPABILITY_SUPPORTED		(1 << 6)
# define DP_PANEL_REPLAY_LINK_OFF_SUPPORTED_IN_PR_AFTER_ADAPTIVE_SYNC_SDP	(1 << 7)

#define DP_PANEL_REPLAY_CAP_X_GRANULARITY		0xb2
#define DP_PANEL_REPLAY_CAP_Y_GRANULARITY		0xb4
#endif

#endif /* __BACKPORT_DRM_DP_H__ */
