/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.animation;

import com.gluonhq.charm.glisten.animation.HideableTransition;
import com.gluonhq.charm.glisten.animation.MobileTransition;
import javafx.animation.Interpolator;
import javafx.animation.Timeline;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.util.Duration;

public class CachedTimelineTransition
extends MobileTransition {
    protected static final Interpolator WEB_EASE = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
    protected final Node node;
    protected Timeline timeline;
    private boolean oldCache = false;
    private CacheHint oldCacheHint = CacheHint.DEFAULT;
    private final boolean useCache;
    private final boolean opacityInterpolated;

    public CachedTimelineTransition(Node node, Timeline timeline) {
        this(node, timeline, true);
    }

    public CachedTimelineTransition(Node node, Timeline timeline, boolean useCache) {
        this(node, timeline, useCache, false);
    }

    public CachedTimelineTransition(Node node, Timeline timeline, boolean useCache, boolean opacityInterpolated) {
        this.node = node;
        this.timeline = timeline;
        this.useCache = useCache;
        this.opacityInterpolated = opacityInterpolated;
        if (this instanceof HideableTransition) {
            this.hideNode();
        }
    }

    @Override
    protected void starting() {
        super.starting();
        if (this.useCache) {
            this.oldCache = this.node.isCache();
            this.oldCacheHint = this.node.getCacheHint();
            this.node.setCache(true);
            this.node.setCacheHint(CacheHint.SPEED);
        }
    }

    @Override
    protected void stopping() {
        super.stopping();
        if (this.useCache) {
            this.node.setCache(this.oldCache);
            this.node.setCacheHint(this.oldCacheHint);
        }
    }

    public void pause() {
        if (this.timeline != null) {
            this.timeline.pause();
        }
        super.pause();
    }

    protected void interpolate(double d) {
        if (this.timeline != null) {
            this.timeline.playFrom(Duration.seconds((double)d));
            this.timeline.stop();
        }
    }

    public final void hideNode() {
        if (this.node != null) {
            this.node.setOpacity(0.0);
        }
    }

    protected boolean isOpacityInterpolated() {
        return this.opacityInterpolated;
    }
}

