/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.animation;

import com.gluonhq.charm.glisten.animation.CachedTimelineTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;

public class HingeTransition
extends CachedTimelineTransition {
    private Rotate rotate;

    public HingeTransition(Node node) {
        this(node, false);
    }

    public HingeTransition(Node node, boolean opacityInterpolated) {
        this(node, opacityInterpolated, Duration.seconds((double)1.0));
    }

    public HingeTransition(Node node, boolean opacityInterpolated, Duration duration) {
        super(node, null, true, opacityInterpolated);
        this.setCycleDuration(duration);
        this.setDelay(Duration.seconds((double)0.2));
    }

    @Override
    protected void starting() {
        double endY = this.node.getScene().getHeight() - this.node.localToScene(0.0, 0.0).getY();
        this.rotate = new Rotate(0.0, 0.0, 0.0);
        this.timeline = new Timeline();
        this.timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)80, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)60, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)600.0), new KeyValue[]{new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)80, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)800.0), new KeyValue[]{new KeyValue((WritableValue)this.node.opacityProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.node.translateYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)60, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.node.opacityProperty(), (Object)(this.isOpacityInterpolated() ? 0 : 1), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.node.translateYProperty(), (Object)endY, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.rotate.angleProperty(), (Object)60, Interpolator.EASE_BOTH)})});
        this.node.getTransforms().add((Object)this.rotate);
        super.starting();
    }

    @Override
    protected void stopping() {
        super.stopping();
        this.node.getTransforms().remove((Object)this.rotate);
        this.node.setTranslateY(0.0);
        this.node.setOpacity(1.0);
    }
}

