/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.animation;

import javafx.animation.Transition;
import javafx.scene.Node;
import javafx.util.Duration;

public final class ShrinkExpandAnimation
extends Transition {
    private final Node n;
    private final boolean expand;
    private final double startWidth;
    private final double startHeight;
    private final double startX;
    private final double startY;

    public ShrinkExpandAnimation(Node n, boolean expand) {
        this.setCycleDuration(Duration.millis((double)250.0));
        this.setCycleCount(1);
        this.n = n;
        this.expand = expand;
        this.startWidth = n.getLayoutBounds().getWidth();
        this.startHeight = n.getLayoutBounds().getHeight();
        this.startX = n.getLayoutX();
        this.startY = n.getLayoutY();
    }

    protected void interpolate(double frac) {
        double inv = 1.0 - frac;
        double a = this.expand ? frac : inv;
        double b = this.expand ? inv : frac;
        this.n.resize(this.startWidth * a, this.startHeight * a);
        this.n.setLayoutX(this.startX + this.startWidth / 2.0 * b);
        this.n.setLayoutY(this.startY + this.startHeight / 2.0 * b);
    }
}

