/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.application;

import com.gluonhq.attach.display.DisplayService;
import com.gluonhq.attach.lifecycle.LifecycleService;
import com.gluonhq.attach.util.Platform;
import com.gluonhq.charm.glisten.application.GlassPane;
import com.gluonhq.charm.glisten.application.StatusBar;
import com.gluonhq.charm.glisten.application.ViewStackPolicy;
import com.gluonhq.charm.glisten.control.AppBar;
import com.gluonhq.charm.glisten.control.LifecycleEvent;
import com.gluonhq.charm.glisten.control.NavigationDrawer;
import com.gluonhq.charm.glisten.control.Snackbar;
import com.gluonhq.charm.glisten.layout.Layer;
import com.gluonhq.charm.glisten.license.License;
import com.gluonhq.charm.glisten.mvc.SplashView;
import com.gluonhq.charm.glisten.mvc.View;
import com.gluonhq.charm.glisten.visual.Swatch;
import com.gluonhq.charm.glisten.visual.Theme;
import com.gluonhq.impl.charm.glisten.application.GlassPaneHelper;
import com.gluonhq.impl.charm.glisten.license.LicenseManager;
import com.gluonhq.impl.charm.glisten.tracking.TrackingManager;
import com.gluonhq.impl.charm.glisten.util.CachedFactory;
import com.gluonhq.impl.charm.glisten.util.DeviceSettings;
import com.gluonhq.impl.charm.glisten.util.GlistenSettings;
import com.gluonhq.impl.charm.glisten.util.NagScreenPresenter;
import com.gluonhq.impl.charm.glisten.util.StylesheetTools;
import com.gluonhq.impl.charm.glisten.util.ViewTools;
import java.lang.ref.WeakReference;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Dimension2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Screen;
import javafx.stage.Stage;

public final class AppManager {
    public static final String HOME_VIEW = "home";
    public static final String SPLASH_VIEW = "splash";
    private static final String CHARM_VERSION = "7.0.0";
    private static AppManager APPLICATION_MANAGER;
    private final Consumer<Scene> postInit;
    private Stage primaryStage;
    private Scene primaryScene;
    private GlassPane glassPane;
    private StatusBar statusBar;
    private AppBar appBar;
    private NavigationDrawer drawer;
    private final CachedFactory<View> viewFactory = new CachedFactory();
    private final CachedFactory<Layer> layerFactory = new CachedFactory();
    private final Deque<String> viewStack = new ArrayDeque<String>();
    private static final GlistenSettings settings;
    private final ReadOnlyObjectWrapper<View> viewProperty = new ReadOnlyObjectWrapper<View>(null, "view"){
        private WeakReference<View> viewRef;
        {
            this.viewRef = null;
        }

        public void invalidated() {
            View oldView = this.viewRef == null ? null : (View)((Object)this.viewRef.get());
            View newView = (View)((Object)this.get());
            if (oldView != null && oldView == newView) {
                return;
            }
            if (oldView != null) {
                Event.fireEvent((EventTarget)oldView, (Event)new LifecycleEvent((EventTarget)oldView, LifecycleEvent.HIDDEN));
            }
            this.viewRef = new WeakReference<View>(newView);
            if (newView != null) {
                if (AppManager.this.glassPane == null) {
                    throw new RuntimeException("The GlassPane was not initialized yet. Consider calling switchView() from postInit() instead");
                }
                AppManager.this.glassPane.setRoot((Node)newView);
                AppManager.this.doSwitchView(ViewTools.findViewName(newView), ViewStackPolicy.USE);
                Event.fireEvent((EventTarget)newView, (Event)new LifecycleEvent((EventTarget)newView, LifecycleEvent.SHOWING));
            }
        }
    };
    private final ObjectProperty<Swatch> swatchProperty = new SimpleObjectProperty<Swatch>((Object)this, "swatch"){

        protected void invalidated() {
            Swatch swatch = Optional.ofNullable(AppManager.this.getSwatch()).orElse(Swatch.getDefault());
            swatch.assignTo(AppManager.this.primaryScene);
        }
    };

    public static AppManager getInstance() {
        return APPLICATION_MANAGER;
    }

    public static AppManager initialize(Consumer<Scene> postInit) {
        if (APPLICATION_MANAGER != null) {
            throw new RuntimeException("The AppManager was initialized already.");
        }
        APPLICATION_MANAGER = new AppManager(postInit);
        return APPLICATION_MANAGER;
    }

    public static AppManager initialize() {
        return AppManager.initialize(null);
    }

    private AppManager(Consumer<Scene> postInit) {
        this.postInit = postInit;
    }

    public final void start(Stage primaryStage) {
        this.primaryStage = primaryStage;
        this.appBar = new AppBar();
        this.glassPane = new GlassPane();
        Dimension2D dim = DisplayService.create().map(DisplayService::getDefaultDimensions).orElse(new Dimension2D(this.getScreenWidth(), this.getScreenHeight()));
        this.primaryScene = new Scene((Parent)this.glassPane, dim.getWidth(), dim.getHeight());
        StylesheetTools.addStylesheet(this.primaryScene, this.getPlatformSpecificStylesheetName());
        Swatch.getDefault().assignTo(this.primaryScene);
        Theme.getDefault().assignTo(this.primaryScene);
        primaryStage.setScene(this.primaryScene);
        boolean splashInited = false;
        if (this.viewFactory.containsKey(SPLASH_VIEW) && this.viewFactory.get(SPLASH_VIEW).get() instanceof SplashView) {
            splashInited = true;
            this.switchView(SPLASH_VIEW);
        }
        if (splashInited) {
            boolean _splashInited = splashInited;
            javafx.application.Platform.runLater(() -> this.continueInit(_splashInited));
        } else {
            this.continueInit(splashInited);
        }
    }

    private void continueInit(boolean splashInited) {
        License licenseAnnotation;
        String licenseKey;
        this.glassPane.postInit();
        if (Platform.isAndroid()) {
            this.primaryScene.addEventHandler(KeyEvent.KEY_RELEASED, e -> {
                if (KeyCode.ESCAPE.equals((Object)e.getCode())) {
                    for (Layer layer : GlassPaneHelper.getLayers()) {
                        if (!layer.isShowing()) continue;
                        MobileEvent event = new MobileEvent((EventTarget)layer, MobileEvent.BACK_BUTTON_PRESSED);
                        Event.fireEvent((EventTarget)layer, (Event)event);
                        if (!event.isConsumed()) continue;
                        return;
                    }
                    boolean success = AppManager.getInstance().switchToPreviousView().isPresent();
                    if (!success && !AppManager.getInstance().existsPreviousView()) {
                        LifecycleService.create().ifPresent(LifecycleService::shutdown);
                    }
                }
            });
        }
        if ((licenseKey = LicenseManager.validateLicense(CHARM_VERSION, licenseAnnotation = this.getClass().getAnnotation(License.class), () -> new NagScreenPresenter().showDialog())) == null) {
            new NagScreenPresenter().showDialog();
        }
        TrackingManager.trackUsage(CHARM_VERSION, licenseKey);
        if (!splashInited) {
            this.switchView(HOME_VIEW);
        }
        try {
            if (this.postInit != null) {
                this.postInit.accept(this.primaryScene);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        this.primaryStage.show();
    }

    public final StringProperty titleProperty() {
        return this.primaryStage.titleProperty();
    }

    public final void setTitle(String title) {
        this.primaryStage.setTitle(title);
    }

    public final String getTitle() {
        return this.primaryStage.getTitle();
    }

    public final ReadOnlyObjectProperty<View> viewProperty() {
        return this.viewProperty.getReadOnlyProperty();
    }

    private void setView(View view) {
        this.viewProperty.set((Object)view);
    }

    public final View getView() {
        return (View)((Object)this.viewProperty.get());
    }

    public final ObjectProperty<Swatch> swatchProperty() {
        return this.swatchProperty;
    }

    public final Swatch getSwatch() {
        return (Swatch)((Object)this.swatchProperty.get());
    }

    public final void setSwatch(Swatch swatch) {
        this.swatchProperty.set((Object)swatch);
    }

    public final GlassPane getGlassPane() {
        return this.glassPane;
    }

    public final AppBar getAppBar() {
        return this.appBar;
    }

    public final NavigationDrawer getDrawer() {
        if (this.drawer == null) {
            this.drawer = new NavigationDrawer();
        }
        return this.drawer;
    }

    public final StatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new StatusBar();
        }
        return this.statusBar;
    }

    public final <T extends View> Optional<T> switchView(String viewName) {
        return this.switchView(viewName, ViewStackPolicy.USE);
    }

    public final <T extends View> Optional<T> switchView(String viewName, ViewStackPolicy viewStackPolicy) {
        if (this.getView() != null) {
            LifecycleEvent onCloseRequest = new LifecycleEvent((EventTarget)this.getView(), LifecycleEvent.CLOSE_REQUEST);
            Event.fireEvent((EventTarget)this.getView(), (Event)onCloseRequest);
            if (onCloseRequest.isConsumed()) {
                return Optional.empty();
            }
        }
        return this.doSwitchView(viewName, viewStackPolicy);
    }

    public final <T extends View> Optional<T> switchToPreviousView() {
        if (this.getView() != null) {
            LifecycleEvent onCloseRequest = new LifecycleEvent((EventTarget)this.getView(), LifecycleEvent.CLOSE_REQUEST);
            Event.fireEvent((EventTarget)this.getView(), (Event)onCloseRequest);
            if (onCloseRequest.isConsumed()) {
                return Optional.empty();
            }
        }
        if (this.viewStack.isEmpty()) {
            return Optional.empty();
        }
        String viewName = this.viewStack.pop();
        return Optional.ofNullable(viewName).flatMap(vn -> this.doSwitchView((String)vn, ViewStackPolicy.SKIP));
    }

    public final <T extends View> Optional<T> goHome() {
        return this.switchView(HOME_VIEW, ViewStackPolicy.CLEAR);
    }

    public final Optional<View> retrieveView(String viewName) {
        return this.viewFactory.get(viewName);
    }

    public final void addViewFactory(String viewName, Supplier<View> supplier) {
        if (this.viewFactory.containsKey(viewName)) {
            throw new IllegalArgumentException("View with name '" + viewName + "' already exists - names must be unique");
        }
        this.viewFactory.put(viewName, supplier);
    }

    public final boolean removeViewFactory(String viewName) {
        if (this.viewFactory.containsKey(viewName)) {
            this.viewFactory.remove(viewName);
            return true;
        }
        return false;
    }

    public final boolean isViewPresent(String viewName) {
        return this.viewFactory.containsKey(viewName);
    }

    public final void addLayerFactory(String layerName, Supplier<Layer> supplier) {
        if (this.layerFactory.containsKey(layerName)) {
            throw new IllegalArgumentException("Layer with name '" + layerName + "' already exists - names must be unique");
        }
        this.layerFactory.put(layerName, supplier);
    }

    public final boolean removeLayerFactory(String layerName) {
        if (this.layerFactory.containsKey(layerName)) {
            this.layerFactory.remove(layerName);
            return true;
        }
        return false;
    }

    public final boolean isLayerPresent(String layerName) {
        return this.layerFactory.containsKey(layerName);
    }

    public final void showLayer(String layerName) {
        this.layerFactory.get(layerName).ifPresent(layer -> {
            layer.setId(layerName);
            layer.show();
        });
    }

    public final void hideLayer(String layerName) {
        this.layerFactory.get(layerName).ifPresent(Layer::hide);
    }

    public final void hideAllLayers(boolean hideAllLayers) {
        GlassPaneHelper.setHideAllLayers(hideAllLayers);
    }

    public final double getScreenHeight() {
        return Screen.getPrimary().getVisualBounds().getHeight();
    }

    public final double getScreenWidth() {
        return Screen.getPrimary().getVisualBounds().getWidth();
    }

    public void showMessage(String message) {
        this.showMessage(message, null, null);
    }

    public void showMessage(String message, String buttonText, EventHandler<ActionEvent> evtHandler) {
        Snackbar snackbar = new Snackbar(message, buttonText, evtHandler);
        snackbar.show();
    }

    protected URLStreamHandlerFactory createUserURLStreamHandlerFactory() {
        return null;
    }

    private boolean existsPreviousView() {
        return !this.viewStack.isEmpty();
    }

    private <T extends View> Optional<T> doSwitchView(String viewName, ViewStackPolicy viewStackPolicy) {
        if (ViewStackPolicy.CLEAR == viewStackPolicy) {
            return this.viewFactory.get(viewName).map(newView -> {
                this.viewStack.clear();
                this.setView((View)((Object)newView));
                return newView;
            });
        }
        View currentView = this.getView();
        String currentViewName = ViewTools.findViewName(currentView);
        if (currentView != null && currentViewName != null && currentViewName.equalsIgnoreCase(viewName)) {
            return Optional.empty();
        }
        return this.viewFactory.get(viewName).map(newView -> {
            String newViewName = ViewTools.findViewName(newView);
            if (newViewName == null || newViewName.isEmpty()) {
                ViewTools.storeViewName(newView, viewName);
            }
            if (ViewStackPolicy.USE == viewStackPolicy && currentView != null) {
                this.viewStack.push(currentViewName);
            }
            if (currentView != null) {
                Event.fireEvent((EventTarget)currentView, (Event)new LifecycleEvent((EventTarget)currentView, LifecycleEvent.HIDING));
            }
            this.setView((View)((Object)newView));
            return newView;
        });
    }

    private String getPlatformSpecificStylesheetName() {
        Platform currentPlatform = Platform.getCurrent();
        String platformSuffix = Platform.isDesktop() ? "" : "_" + currentPlatform.toString().toLowerCase(Locale.ROOT);
        String formFactorSuffix = DeviceSettings.hasNotch() ? "_notch" : DisplayService.create().map(s -> s.isTablet() ? "_tablet" : "").orElse("");
        return String.format("glisten%s%s.css", platformSuffix, formFactorSuffix);
    }

    static {
        settings = new GlistenSettings();
    }

    public static class MobileEvent
    extends Event {
        public static final EventType<MobileEvent> ANY = new EventType(Event.ANY, "MOBILE_EVENT");
        public static final EventType<MobileEvent> BACK_BUTTON_PRESSED = new EventType(ANY, "BACK_BUTTON_PRESSED");

        public MobileEvent(EventTarget source, EventType<? extends Event> eventType) {
            super((Object)source, source, eventType);
        }
    }
}

