/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.application;

import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.application.StatusBar;
import com.gluonhq.charm.glisten.control.AppBar;
import com.gluonhq.charm.glisten.control.LifecycleEvent;
import com.gluonhq.charm.glisten.layout.Layer;
import com.gluonhq.charm.glisten.mvc.View;
import com.gluonhq.impl.charm.glisten.application.GlassPaneHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class GlassPane
extends BorderPane {
    private static ObservableList<Layer> layers = FXCollections.observableArrayList();
    private static boolean hideAllLayers;
    private static boolean opaqueLayerPressed;
    private Region opaqueLayer;
    private StatusBar statusBar;
    private AppBar appBar;
    private Transition viewTransition;
    private Node nodeInTransition;
    private Layer topLayer;
    private boolean shouldUpdateFade;
    private InvalidationListener showingListener = o -> {
        this.shouldUpdateFade = true;
        this.requestLayout();
    };
    private ObjectProperty<Node> rootProperty = new SimpleObjectProperty<Node>((Object)this, "root"){
        private Node oldRoot;
        {
            this.oldRoot = null;
        }

        private void replaceRoot(Node newRoot) {
            if (this.oldRoot != null) {
                GlassPane.this.getChildren().remove((Object)this.oldRoot);
            }
            this.oldRoot = newRoot;
        }

        protected void invalidated() {
            Node newRoot = (Node)this.get();
            if (GlassPane.this.getChildren().contains((Object)newRoot) && GlassPane.this.viewTransition != null && GlassPane.this.viewTransition.getStatus() == Animation.Status.RUNNING) {
                GlassPane.this.viewTransition.stop();
                this.onFinished(GlassPane.this.nodeInTransition);
            }
            GlassPane.this.getChildren().add(this.oldRoot == null ? 0 : 1, (Object)newRoot);
            if (newRoot instanceof View) {
                GlassPane.this.viewTransition = ((View)newRoot).getShowTransition();
                GlassPane.this.viewTransition.setOnFinished(e -> this.onFinished(newRoot));
                GlassPane.this.nodeInTransition = newRoot;
                GlassPane.this.layoutChildren();
                GlassPane.this.viewTransition.play();
            } else {
                this.replaceRoot(newRoot);
            }
        }

        private void onFinished(Node newRoot) {
            this.replaceRoot(newRoot);
            Event.fireEvent((EventTarget)newRoot, (Event)new LifecycleEvent((EventTarget)newRoot, LifecycleEvent.SHOWN));
        }
    };
    private DoubleProperty backgroundFade = new SimpleDoubleProperty((Object)this, "backgroundFade");
    private List<Node> toRemove = new ArrayList<Node>();

    GlassPane() {
        layers.addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    opaqueLayerPressed = false;
                    this.getChildren().addAll((Collection)c.getAddedSubList());
                    for (Layer layer : c.getAddedSubList()) {
                        layer.showingProperty().addListener(this.showingListener);
                    }
                    continue;
                }
                if (!c.wasRemoved()) continue;
                this.getChildren().removeAll((Collection)c.getRemoved());
                for (Layer layer : c.getRemoved()) {
                    layer.showingProperty().removeListener(this.showingListener);
                }
            }
            this.updateFadeLevel();
        });
    }

    void postInit() {
        this.statusBar = AppManager.getInstance().getStatusBar();
        this.appBar = AppManager.getInstance().getAppBar();
        this.appBar.visibleProperty().addListener(observable -> this.requestLayout());
        this.opaqueLayer = new Region();
        this.opaqueLayer.setMouseTransparent(true);
        this.opaqueLayer.setPickOnBounds(false);
        this.opaqueLayer.setOnMousePressed(e -> {
            Layer layer;
            opaqueLayerPressed = true;
            if (layers.size() > 0 && (layer = (Layer)((Object)((Object)layers.get(layers.size() - 1)))).isShowing() && layer.isAutoHide()) {
                layer.hide();
            }
        });
        this.opaqueLayer.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.opaqueLayer.opacityProperty().bind((ObservableValue)this.backgroundFade);
        this.getChildren().addAll((Object[])new Node[]{this.statusBar.fakeStatusBar, this.appBar, this.opaqueLayer});
    }

    final void setRoot(Node newRoot) {
        this.rootProperty.set((Object)newRoot);
    }

    public final Node getRoot() {
        return (Node)this.rootProperty.get();
    }

    final ObjectProperty<Node> rootProperty() {
        return this.rootProperty;
    }

    private final void setBackgroundFade(double fadeLevel) {
        this.backgroundFade.set(fadeLevel);
    }

    private final double getBackgroundFade() {
        return this.backgroundFade.get();
    }

    private final DoubleProperty backgroundFadeProperty() {
        return this.backgroundFade;
    }

    protected void layoutChildren() {
        Node root;
        double appBarHeight;
        if (this.shouldUpdateFade) {
            this.updateFadeLevel();
            this.shouldUpdateFade = false;
        }
        double w = this.getWidth();
        double h = this.getHeight();
        double d = appBarHeight = this.appBar != null && this.appBar.isVisible() ? this.appBar.prefHeight(w) : 0.0;
        if (this.appBar != null) {
            this.appBar.resizeRelocate(0.0, 0.0, w, appBarHeight);
        }
        if ((root = this.getRoot()) != null) {
            root.resizeRelocate(0.0, appBarHeight, w, h - appBarHeight);
        }
        if (this.opaqueLayer != null) {
            this.opaqueLayer.resizeRelocate(0.0, 0.0, w, h);
        }
        boolean isShowing = false;
        this.toRemove.clear();
        for (Layer layer : layers) {
            isShowing = isShowing || layer.isShowing() && !layer.isMouseTransparent();
            layer.layoutChildren();
            if (layer.isShowing() || layer.isVisible()) continue;
            this.toRemove.add((Node)layer);
        }
        layers.removeAll(this.toRemove);
        if (this.opaqueLayer != null) {
            if (this.topLayer != null && !this.topLayer.isAutoHide()) {
                this.opaqueLayer.setMouseTransparent(true);
            } else {
                this.opaqueLayer.setMouseTransparent(!isShowing);
            }
        }
    }

    private void updateFadeLevel() {
        if (!layers.isEmpty()) {
            Layer layer = (Layer)((Object)layers.get(layers.size() - 1));
            if (layer != this.topLayer) {
                this.topLayer = layer;
                this.backgroundFadeProperty().unbind();
                this.backgroundFadeProperty().bind((ObservableValue)layer.backgroundFadeProperty());
            }
        } else {
            if (this.topLayer != null) {
                this.backgroundFadeProperty().unbind();
                this.setBackgroundFade(0.0);
            }
            this.topLayer = null;
        }
    }

    static {
        GlassPaneHelper.setGlassPaneAccessor(new GlassPaneHelper.GlassPaneAccessor(){

            @Override
            public ObservableList<Layer> getLayers() {
                return layers;
            }

            @Override
            public boolean isHideAllLayers() {
                return hideAllLayers && opaqueLayerPressed;
            }

            @Override
            public void setHideAllLayers(boolean hideAllLayers) {
                GlassPane.hideAllLayers = hideAllLayers;
            }
        });
    }
}

