/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.application;

import com.gluonhq.attach.statusbar.StatusBarService;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.PseudoClass;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class StatusBar {
    Region fakeStatusBar;
    private ObjectProperty<Color> colorProperty = new SimpleObjectProperty<Color>((Object)this, "color", Color.BLACK){

        protected void invalidated() {
            StatusBar.this.setStatusBarColor(StatusBar.this.getColor());
        }
    };

    StatusBar() {
        this.fakeStatusBar = new Region();
        this.fakeStatusBar.getStyleClass().add((Object)"status-bar");
        this.fakeStatusBar.setVisible(false);
        this.fakeStatusBar.setManaged(false);
        this.fakeStatusBar.setMaxSize(0.0, 0.0);
        this.fakeStatusBar.backgroundProperty().addListener(o -> this.updateStatusBarFromCSS());
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.colorProperty;
    }

    public final void setColor(Color color) {
        this.colorProperty.set((Object)color);
    }

    public final Color getColor() {
        return (Color)this.colorProperty.get();
    }

    public final void pseudoClassStateChanged(PseudoClass pseudoClass, boolean active) {
        this.fakeStatusBar.pseudoClassStateChanged(pseudoClass, active);
    }

    private void updateStatusBarFromCSS() {
        if (this.fakeStatusBar.getBackground() == null) {
            this.setColor(Color.BLACK);
            return;
        }
        List fills = this.fakeStatusBar.getBackground().getFills();
        Color newFill = Color.BLACK;
        if (!fills.isEmpty()) {
            for (int i = 0; i < fills.size(); ++i) {
                Paint fill = ((BackgroundFill)fills.get(i)).getFill();
                if (!(fill instanceof Color)) continue;
                newFill = (Color)fill;
            }
        }
        this.setColor(newFill);
    }

    private void setStatusBarColor(Color color) {
        StatusBarService.create().ifPresent(s -> s.setColor(color));
    }
}

