/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.application;

import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.mvc.View;
import java.util.List;
import java.util.Optional;
import java.util.Stack;

class ViewStack {
    private final List<String> stack = new Stack<String>();

    ViewStack() {
    }

    public Optional<View> getCurrentView() {
        return this.getView(0);
    }

    public Optional<View> getPreviousView() {
        return this.getView(1);
    }

    public void back() {
        this.back(1);
    }

    public void back(int steps) {
        this.getViewName(steps).ifPresent(AppManager.getInstance()::switchView);
    }

    public void clear() {
        this.stack.clear();
    }

    public void add(String name) {
        this.stack.add(name);
    }

    private Optional<String> getViewName(int fromTop) {
        return Optional.ofNullable(this.stack.isEmpty() || this.stack.size() <= fromTop ? null : this.stack.get(this.stack.size() - fromTop - 1));
    }

    private Optional<View> getView(int fromTop) {
        Optional<String> viewName = this.getViewName(fromTop);
        if (viewName.isPresent()) {
            return viewName.flatMap(AppManager.getInstance()::retrieveView);
        }
        return Optional.empty();
    }
}

