/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.Dialog;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.Region;

public class Alert
extends Dialog<ButtonType> {
    private Region defaultGraphic;
    private Button cancelButton;
    private Button OKButton;
    private final ObjectProperty<Alert.AlertType> alertType = new SimpleObjectProperty<Alert.AlertType>((Object)this, "alertType"){

        protected void invalidated() {
            Alert.this.rootNode.getStyleClass().removeAll((Object[])new String[]{"warning", "error", "information", "confirmation"});
            switch ((Alert.AlertType)this.get()) {
                case CONFIRMATION: {
                    Alert.this.rootNode.getStyleClass().add((Object)"confirmation");
                    if (Alert.this.getButtons().contains((Object)Alert.this.cancelButton)) break;
                    Alert.this.getButtons().add(0, (Object)Alert.this.cancelButton);
                    break;
                }
                case ERROR: {
                    Alert.this.rootNode.getStyleClass().add((Object)"error");
                    Alert.this.getButtons().remove((Object)Alert.this.cancelButton);
                    break;
                }
                case INFORMATION: {
                    Alert.this.rootNode.getStyleClass().add((Object)"information");
                    Alert.this.getButtons().remove((Object)Alert.this.cancelButton);
                    break;
                }
                case WARNING: {
                    Alert.this.rootNode.getStyleClass().add((Object)"warning");
                    Alert.this.getButtons().remove((Object)Alert.this.cancelButton);
                    break;
                }
                case NONE: {
                    Alert.this.getButtons().remove((Object)Alert.this.cancelButton);
                }
            }
        }
    };

    public Alert(@NamedArg(value="alertType") Alert.AlertType alertType) {
        this.defaultGraphic = new Region();
        this.OKButton = new Button("OK");
        this.OKButton.setOnAction(event -> {
            this.setResult(ButtonType.OK);
            this.hide();
        });
        this.cancelButton = new Button("CANCEL");
        this.cancelButton.setOnAction(event -> {
            this.setResult(ButtonType.CANCEL);
            this.hide();
        });
        this.getButtons().add((Object)this.OKButton);
        this.setAlertType(alertType);
        this.defaultGraphic.getStyleClass().add((Object)"graphic");
        this.rootNode.getStyleClass().add((Object)"alert");
        this.setGraphic((Node)this.defaultGraphic);
    }

    public Alert(@NamedArg(value="alertType") Alert.AlertType type, @NamedArg(value="contentText") String contentText) {
        this(type);
        this.setContentText(contentText);
    }

    public final ObjectProperty<Alert.AlertType> alertTypeProperty() {
        return this.alertType;
    }

    public final Alert.AlertType getAlertType() {
        return (Alert.AlertType)this.alertType.get();
    }

    public final void setAlertType(Alert.AlertType value) {
        this.alertType.set((Object)value);
    }
}

