/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.skin.AppBarSkin;
import com.gluonhq.impl.charm.glisten.util.DeviceSettings;
import com.gluonhq.impl.charm.glisten.util.GlistenSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Skin;

public class AppBar
extends Control {
    private final ObjectProperty<Node> title = new SimpleObjectProperty((Object)this, "title");
    private final StringProperty titleText = new SimpleStringProperty((Object)this, "titleText"){

        protected void invalidated() {
            if (this.get() != null) {
                AppBar.this.setTitle((Node)new Label(this.get()));
            }
        }
    };
    private final ObservableList<Node> actionItems = FXCollections.observableArrayList();
    private final ObservableList<MenuItem> menuItems = FXCollections.observableArrayList();
    private final ObjectProperty<Node> navIcon = new SimpleObjectProperty((Object)this, "navIcon");
    private final DoubleProperty progress = new SimpleDoubleProperty((Object)this, "progress", -1.0);
    private final BooleanProperty progressBarVisible = new SimpleBooleanProperty((Object)this, "progressBarVisible", false);
    private final BooleanProperty autoHideProgressBar = new SimpleBooleanProperty((Object)this, "autoHideProgressBar", Boolean.FALSE.booleanValue());
    private StyleableDoubleProperty spacing = new SimpleStyleableDoubleProperty(SPACING, (Object)this, "spacing"){

        public void invalidated() {
            AppBar.this.requestLayout();
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "app-bar";
    private static final CssMetaData<AppBar, Number> SPACING = new CssMetaData<AppBar, Number>("-fx-spacing", SizeConverter.getInstance(), (Number)0.0){

        public boolean isSettable(AppBar node) {
            return node.spacing == null || !node.spacing.isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(AppBar node) {
            return node.spacingProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public AppBar() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        if (GlistenSettings.isExperimentalPerformance()) {
            this.setCache(true);
        }
        DeviceSettings.dedicatedSetup(this);
    }

    public final Node getTitle() {
        return (Node)this.title.get();
    }

    public final ObjectProperty<Node> titleProperty() {
        return this.title;
    }

    public final void setTitle(Node title) {
        this.title.set((Object)title);
    }

    public final String getTitleText() {
        return (String)this.titleText.get();
    }

    public final StringProperty titleTextProperty() {
        return this.titleText;
    }

    public final void setTitleText(String titleText) {
        this.titleText.set((Object)titleText);
    }

    public final ObservableList<Node> getActionItems() {
        return this.actionItems;
    }

    public final ObservableList<MenuItem> getMenuItems() {
        return this.menuItems;
    }

    public final Node getNavIcon() {
        return (Node)this.navIcon.get();
    }

    public final ObjectProperty<Node> navIconProperty() {
        return this.navIcon;
    }

    public final void setNavIcon(Node navIcon) {
        this.navIcon.set((Object)navIcon);
    }

    public final DoubleProperty progressProperty() {
        return this.progress;
    }

    public final double getProgress() {
        return this.progress.get();
    }

    public final void setProgress(double value) {
        this.progress.set(value);
    }

    public final BooleanProperty progressBarVisibleProperty() {
        return this.progressBarVisible;
    }

    public final boolean isProgressBarVisible() {
        return this.progressBarVisible.get();
    }

    public final void setProgressBarVisible(boolean progressBarVisible) {
        this.progressBarVisible.set(progressBarVisible);
    }

    public final BooleanProperty autoHideProgressBarProperty() {
        return this.autoHideProgressBar;
    }

    public final boolean isAutoHideProgressBar() {
        return this.autoHideProgressBar.get();
    }

    public final void setAutoHideProgressBar(boolean autoHideProgressBar) {
        this.autoHideProgressBar.set(autoHideProgressBar);
    }

    public final StyleableDoubleProperty spacingProperty() {
        return this.spacing;
    }

    public final void setSpacing(double value) {
        this.spacingProperty().set(value);
    }

    public final double getSpacing() {
        return this.spacing.get();
    }

    public void clear() {
        this.setNavIcon(null);
        this.setTitle(null);
        this.setTitleText(null);
        this.getActionItems().clear();
        this.getMenuItems().clear();
        this.setVisible(true);
    }

    protected Skin<?> createDefaultSkin() {
        return new AppBarSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return AppBar.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<AppBar, Number>> styleables = new ArrayList<CssMetaData<AppBar, Number>>(Control.getClassCssMetaData());
        styleables.add(SPACING);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

