/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.TextField;
import com.gluonhq.charm.glisten.control.skin.AutoCompleteTextFieldSkin;
import java.util.List;
import java.util.function.Function;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class AutoCompleteTextField<T>
extends TextField {
    private final ObjectProperty<Function<String, List<T>>> completer = new SimpleObjectProperty();
    private final ObjectProperty<CompleterMode> completerMode = new SimpleObjectProperty((Object)CompleterMode.SEARCH_AUTOMATICALLY);
    private final ObjectProperty<Duration> completerWaitDuration = new SimpleObjectProperty((Object)Duration.ZERO);
    private final ObjectProperty<Function<T, Node>> resultNodeFactory = new SimpleObjectProperty(this::defaultGetNodeForPopup);
    private final ReadOnlyObjectWrapper<T> value = new ReadOnlyObjectWrapper();
    private final ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");

    public AutoCompleteTextField() {
        this.getStyleClass().setAll((Object[])new String[]{"auto-complete-text-field"});
        this.getProperties().addListener(change -> {
            if (change.wasAdded() && "setValue".equals(change.getKey())) {
                Object value = change.getValueAdded();
                this.value.set(value);
            }
        });
    }

    public final void setCompleter(Function<String, List<T>> handler) {
        this.completer.set(handler);
    }

    public final Function<String, List<T>> getCompleter() {
        return (Function)this.completer.get();
    }

    public final ObjectProperty<Function<String, List<T>>> completerProperty() {
        return this.completer;
    }

    public final CompleterMode getCompleterMode() {
        return (CompleterMode)((Object)this.completerMode.get());
    }

    public final void setCompleterMode(CompleterMode value) {
        this.completerMode.set((Object)value);
    }

    public final ObjectProperty<CompleterMode> completerModeProperty() {
        return this.completerMode;
    }

    public final Duration getCompleterWaitDuration() {
        return (Duration)this.completerWaitDuration.get();
    }

    public final void setCompleterWaitDuration(Duration number) {
        this.completerWaitDuration.set((Object)number);
    }

    public final ObjectProperty<Duration> completerWaitDurationProperty() {
        return this.completerWaitDuration;
    }

    public final void setResultNodeFactory(Function<T, Node> factory) {
        this.resultNodeFactory.set(factory);
    }

    public final Function<T, Node> getResultNodeFactory() {
        return (Function)this.resultNodeFactory.get();
    }

    public final ObjectProperty<Function<T, Node>> resultNodeFactoryProperty() {
        return this.resultNodeFactory;
    }

    public final T getValue() {
        return (T)this.value.get();
    }

    public final ReadOnlyObjectProperty<T> valueProperty() {
        return this.value.getReadOnlyProperty();
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public final void setConverter(StringConverter<T> value) {
        this.converter.set(value);
    }

    public void search() {
        this.fireEvent(new AutoCompleteEvent((EventTarget)this, AutoCompleteEvent.ON_SEARCH));
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new AutoCompleteTextFieldSkin(this);
    }

    private Node defaultGetNodeForPopup(T value) {
        StackPane stackPane = new StackPane();
        Label label = new Label(this.getConverter() == null ? value.toString() : this.getConverter().toString(value));
        label.setWrapText(true);
        stackPane.setAlignment(Pos.CENTER_LEFT);
        stackPane.getChildren().add((Object)label);
        stackPane.setUserData((Object)"defaultResultNodeFactory");
        return stackPane;
    }

    public static class AutoCompleteEvent
    extends Event {
        public static final EventType<AutoCompleteEvent> ON_SEARCH = new EventType(ANY, "ON_AUTO_COMPLETE_SEARCH");

        public AutoCompleteEvent(@NamedArg(value="source") EventTarget sourceAndTarget, @NamedArg(value="eventType") EventType<? extends Event> eventType) {
            super((Object)sourceAndTarget, sourceAndTarget, eventType);
        }
    }

    public static enum CompleterMode {
        SEARCH_AUTOMATICALLY,
        SEARCH_ON_REQUEST;

    }
}

