/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.skin.AvatarSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;

@DefaultProperty(value="image")
public class Avatar
extends Control {
    private static final int DEFAULT_RADIUS = 18;
    private final DoubleProperty radiusProperty = new StyleableDoubleProperty(18.0){

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return RADIUS_META_DATA;
        }

        public Object getBean() {
            return Avatar.this;
        }

        public String getName() {
            return "radius";
        }
    };
    private final ObjectProperty<Image> imageProperty = new SimpleObjectProperty((Object)this, "image");
    private static final CssMetaData<Avatar, Number> RADIUS_META_DATA = new CssMetaData<Avatar, Number>("-charm-radius", StyleConverter.getSizeConverter(), (Number)0.0){

        public boolean isSettable(Avatar node) {
            return node.radiusProperty == null || !node.radiusProperty.isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(Avatar node) {
            return (StyleableProperty)node.radiusProperty;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public Avatar() {
        this(18.0);
    }

    public Avatar(double radius) {
        this(radius, null);
    }

    public Avatar(double radius, Image image) {
        this.setRadius(radius);
        this.setImage(image);
        this.getStyleClass().setAll((Object[])new String[]{"avatar"});
    }

    protected Skin<?> createDefaultSkin() {
        return new AvatarSkin(this);
    }

    public final DoubleProperty radiusProperty() {
        return this.radiusProperty;
    }

    public final double getRadius() {
        return this.radiusProperty().get();
    }

    public final void setRadius(double radius) {
        this.radiusProperty().set(radius);
    }

    public final ObjectProperty<Image> imageProperty() {
        return this.imageProperty;
    }

    public final void setImage(Image image) {
        this.imageProperty.set((Object)image);
    }

    public final Image getImage() {
        return (Image)this.imageProperty.get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Avatar.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<Avatar, Number>> styleables = new ArrayList<CssMetaData<Avatar, Number>>(Control.getClassCssMetaData());
        styleables.add(RADIUS_META_DATA);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

