/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.Avatar;
import com.gluonhq.charm.glisten.control.skin.AvatarPaneSkin;
import com.gluonhq.impl.charm.glisten.util.StylesheetTools;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;

@DefaultProperty(value="items")
public class AvatarPane<T>
extends Control {
    private final ListProperty<T> items = new SimpleListProperty((Object)this, "items");
    private final ObjectProperty<Callback<T, Avatar>> avatarFactory = new SimpleObjectProperty((Object)this, "avatarFactory");
    private final ObjectProperty<Callback<T, Node>> contentFactory = new SimpleObjectProperty((Object)this, "contentFactory");
    private final ObjectProperty<T> value = new SimpleObjectProperty((Object)this, "value");
    private BooleanProperty expanded = new SimpleBooleanProperty((Object)this, "expanded", true){

        protected void invalidated() {
            if (!AvatarPane.this.isCollapsible() && !AvatarPane.this.isExpanded()) {
                throw new IllegalStateException("Cannot set expanded to false when collapsible is false");
            }
        }
    };
    private BooleanProperty collapsible = new SimpleBooleanProperty((Object)this, "collapsible", false);
    private final ObjectProperty<Runnable> exitAction = new SimpleObjectProperty((Object)this, "exitAction");
    private static String userAgentStylesheet;

    public AvatarPane() {
        this(FXCollections.observableArrayList());
    }

    public AvatarPane(ObservableList<T> items) {
        this.getStyleClass().add((Object)"avatar-pane");
        this.items.setValue(items);
        if (!items.isEmpty()) {
            this.setValue(items.get(0));
        }
    }

    public final ListProperty<T> itemsProperty() {
        return this.items;
    }

    public final ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public final void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    public final ObjectProperty<Callback<T, Avatar>> avatarFactoryProperty() {
        return this.avatarFactory;
    }

    public final Callback<T, Avatar> getAvatarFactory() {
        return (Callback)this.avatarFactory.get();
    }

    public final void setAvatarFactory(Callback<T, Avatar> value) {
        this.avatarFactory.set(value);
    }

    public final ObjectProperty<Callback<T, Node>> contentFactoryProperty() {
        return this.contentFactory;
    }

    public final Callback<T, Node> getContentFactory() {
        return (Callback)this.contentFactory.get();
    }

    public final void setContentFactory(Callback<T, Node> value) {
        this.contentFactory.set(value);
    }

    public final ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public final T getValue() {
        return (T)this.value.get();
    }

    public final void setValue(T value) {
        this.value.set(value);
    }

    public final BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public final void setExpanded(boolean value) {
        this.expandedProperty().set(value);
    }

    public final boolean isExpanded() {
        return this.expanded.get();
    }

    public final BooleanProperty collapsibleProperty() {
        return this.collapsible;
    }

    public final void setCollapsible(boolean value) {
        this.collapsible.set(value);
    }

    public final boolean isCollapsible() {
        return this.collapsible.get();
    }

    public final ObjectProperty<Runnable> exitActionProperty() {
        return this.exitAction;
    }

    public final Runnable getExitAction() {
        return (Runnable)this.exitAction.get();
    }

    public final void setExitAction(Runnable value) {
        this.exitAction.set((Object)value);
    }

    protected Skin<?> createDefaultSkin() {
        return new AvatarPaneSkin(this);
    }

    public String getUserAgentStylesheet() {
        if (userAgentStylesheet == null) {
            userAgentStylesheet = StylesheetTools.asResource("avatarPane.css");
        }
        return userAgentStylesheet;
    }
}

