/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.CharmListCell;
import com.gluonhq.charm.glisten.control.skin.CharmListViewSkin;
import com.gluonhq.impl.charm.glisten.control.skin.util.HeadersList;
import java.util.Comparator;
import java.util.function.Function;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import javafx.util.StringConverter;

@DefaultProperty(value="items")
public class CharmListView<T, K extends Comparable>
extends Control {
    private HeadersList<T, K> headerList;
    private ListProperty<T> items;
    private ObjectProperty<Function<? super T, K>> headersFunction;
    private ObjectProperty<Comparator<? super T>> comparator;
    private ObjectProperty<Comparator<? super K>> headersComparator;
    private final ObjectProperty<StringConverter<K>> converter = new SimpleObjectProperty((Object)this, "converter");
    private ObjectProperty<Callback<CharmListView<T, K>, CharmListCell<T>>> cellFactory;
    private ObjectProperty<Callback<CharmListView<T, K>, CharmListCell<T>>> headerCellFactory;
    private BooleanProperty floatingHeaderVisible;
    private ObjectProperty<Node> placeholder;
    private final ObjectProperty<EventHandler<ActionEvent>> onPullToRefresh = new SimpleObjectProperty((Object)this, "swipeRefresh");
    private final BooleanProperty refreshIndicatorVisible = new SimpleBooleanProperty((Object)this, "refreshIndicatorVisible", false);
    private final ObjectProperty<T> selectedItem = new SimpleObjectProperty((Object)this, "selectedItem");

    public CharmListView() {
        this(FXCollections.observableArrayList());
    }

    public CharmListView(ObservableList<T> list) {
        this.itemsProperty().set(list);
        this.getStyleClass().add((Object)"charm-list-view");
    }

    public final ObservableList<T> getHeadersList() {
        return this.headerList;
    }

    public final void setItems(ObservableList<T> value) {
        this.itemsProperty().set(value);
    }

    public final ListProperty<T> itemsProperty() {
        if (this.items == null) {
            this.items = new SimpleListProperty<T>((Object)this, "items"){

                protected void invalidated() {
                    CharmListView.this.headerList = new HeadersList(new SortedList((ObservableList)CharmListView.this.items.get(), CharmListView.this.getBundledComparator()), CharmListView.this.getHeadersFunction());
                }
            };
        }
        return this.items;
    }

    public final ObjectProperty<Function<? super T, K>> headersFunctionProperty() {
        if (this.headersFunction == null) {
            this.headersFunction = new SimpleObjectProperty<Function<? super T, K>>((Object)this, "function"){

                protected void invalidated() {
                    CharmListView.this.headerList = new HeadersList(new SortedList((ObservableList)CharmListView.this.items.get(), CharmListView.this.getBundledComparator()), CharmListView.this.getHeadersFunction());
                }
            };
        }
        return this.headersFunction;
    }

    public final Function<? super T, K> getHeadersFunction() {
        return this.headersFunction == null ? null : (Function)this.headersFunction.get();
    }

    public final void setHeadersFunction(Function<? super T, K> function) {
        this.headersFunctionProperty().set(function);
    }

    public final ObjectProperty<Comparator<? super T>> comparatorProperty() {
        if (this.comparator == null) {
            this.comparator = new SimpleObjectProperty<Comparator<? super T>>((Object)this, "comparator"){

                protected void invalidated() {
                    CharmListView.this.headerList = new HeadersList(new SortedList((ObservableList)CharmListView.this.items.get(), CharmListView.this.getBundledComparator()), CharmListView.this.getHeadersFunction());
                }
            };
        }
        return this.comparator;
    }

    public final Comparator<? super T> getComparator() {
        return this.comparator == null ? null : (Comparator)this.comparator.get();
    }

    public final void setComparator(Comparator<? super T> comparator) {
        this.comparatorProperty().set(comparator);
    }

    public final ObjectProperty<Comparator<? super K>> headersComparatorProperty() {
        if (this.headersComparator == null) {
            this.headersComparator = new SimpleObjectProperty<Comparator<? super K>>((Object)this, "headersComparator"){

                protected void invalidated() {
                    CharmListView.this.headerList = new HeadersList(new SortedList((ObservableList)CharmListView.this.items.get(), CharmListView.this.getBundledComparator()), CharmListView.this.getHeadersFunction());
                }
            };
        }
        return this.headersComparator;
    }

    public final Comparator<? super K> getHeaderComparator() {
        return this.headersComparator == null ? null : (Comparator)this.headersComparator.get();
    }

    public final void setHeaderComparator(Comparator<? super K> headerComparator) {
        this.headersComparatorProperty().set(headerComparator);
    }

    private Comparator<? super T> getBundledComparator() {
        if (this.getHeadersFunction() == null) {
            return this.getComparator();
        }
        return (item1, item2) -> {
            if (this.getHeadersFunction() == null) {
                if (this.getComparator() != null) {
                    return this.getComparator().compare(item1, item2);
                }
                return 0;
            }
            Comparable func1 = (Comparable)this.getHeadersFunction().apply(item1);
            Comparable func2 = (Comparable)this.getHeadersFunction().apply(item2);
            if (func1 == null || func2 == null) {
                if (this.getComparator() != null) {
                    return this.getComparator().compare(item1, item2);
                }
                return 0;
            }
            if (this.getHeaderComparator() != null) {
                if (this.getComparator() != null && this.getHeaderComparator().compare(func1, func2) == 0) {
                    return this.getComparator().compare(item1, item2);
                }
                return this.getHeaderComparator().compare(func1, func2);
            }
            if (this.getComparator() != null && func1.compareTo(func2) == 0) {
                return this.getComparator().compare(item1, item2);
            }
            return func1.compareTo(func2);
        };
    }

    public final ObjectProperty<StringConverter<K>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<K> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<K> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final void setCellFactory(Callback<CharmListView<T, K>, CharmListCell<T>> value) {
        this.cellFactoryProperty().set(value);
    }

    public final Callback<CharmListView<T, K>, CharmListCell<T>> getCellFactory() {
        return this.cellFactory == null ? null : (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<CharmListView<T, K>, CharmListCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty((Object)this, "cellFactory");
        }
        return this.cellFactory;
    }

    public final void setHeaderCellFactory(Callback<CharmListView<T, K>, CharmListCell<T>> value) {
        this.cellHeaderFactoryProperty().set(value);
    }

    public final Callback<CharmListView<T, K>, CharmListCell<T>> getHeaderCellFactory() {
        return this.headerCellFactory == null ? null : (Callback)this.headerCellFactory.get();
    }

    public final ObjectProperty<Callback<CharmListView<T, K>, CharmListCell<T>>> cellHeaderFactoryProperty() {
        if (this.headerCellFactory == null) {
            this.headerCellFactory = new SimpleObjectProperty((Object)this, "headerCellFactory");
        }
        return this.headerCellFactory;
    }

    public final void setFloatingHeaderVisible(boolean visible) {
        this.floatingHeaderVisibleProperty().set(visible);
    }

    public final boolean isFloatingHeaderVisible() {
        return this.floatingHeaderVisible == null ? true : this.floatingHeaderVisible.get();
    }

    public final BooleanProperty floatingHeaderVisibleProperty() {
        if (this.floatingHeaderVisible == null) {
            this.floatingHeaderVisible = new SimpleBooleanProperty((Object)this, "floatingHeaderVisible", true);
        }
        return this.floatingHeaderVisible;
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty((Object)this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node value) {
        this.placeholderProperty().set((Object)value);
    }

    public final Node getPlaceholder() {
        return this.placeholder == null ? null : (Node)this.placeholder.get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onPullToRefreshProperty() {
        return this.onPullToRefresh;
    }

    public final void setOnPullToRefresh(EventHandler<ActionEvent> eventHandler) {
        this.onPullToRefresh.set(eventHandler);
    }

    public final EventHandler<ActionEvent> getOnPullToRefresh() {
        return (EventHandler)this.onPullToRefresh.get();
    }

    public final BooleanProperty refreshIndicatorVisibleProperty() {
        return this.refreshIndicatorVisible;
    }

    public final void setRefreshIndicatorVisible(boolean value) {
        this.refreshIndicatorVisible.set(value);
    }

    public final boolean isRefreshIndicatorVisible() {
        return this.refreshIndicatorVisible.get();
    }

    public final ObjectProperty<T> selectedItemProperty() {
        return this.selectedItem;
    }

    public final T getSelectedItem() {
        return (T)this.selectedItem.get();
    }

    public final void setSelectedItem(T value) {
        this.selectedItem.set(value);
    }

    public void scrollTo(T object) {
        Skin skin = this.getSkin();
        if (this.getHeadersList() != null && skin instanceof CharmListViewSkin) {
            int idx = this.getHeadersList().indexOf(object);
            if (this.isFloatingHeaderVisible()) {
                if (idx > 0) {
                    ((CharmListViewSkin)skin).scrollTo(idx - 1);
                }
            } else if (idx >= 0) {
                ((CharmListViewSkin)skin).scrollTo(idx);
            }
        }
    }

    public void scrollTo(int index) {
        if (this.items == null || this.items.size() < index) {
            return;
        }
        this.scrollTo(this.items.get(index));
    }

    public void scrollToHeader(T object) {
        Skin skin = this.getSkin();
        if (this.getHeadersList() != null && skin instanceof CharmListViewSkin) {
            int idx = this.getHeadersList().indexOf(object);
            int previousSetBit = this.headerList.getHeadersIndex().previousSetBit(idx);
            if (previousSetBit >= 0) {
                ((CharmListViewSkin)skin).scrollTo(previousSetBit);
            }
        }
    }

    public String toString(T item) {
        if (this.getHeadersFunction() == null || item == null) {
            return "";
        }
        Comparable k = (Comparable)this.getHeadersFunction().apply(item);
        if (k == null) {
            return "";
        }
        if (this.getConverter() != null) {
            return this.getConverter().toString((Object)k);
        }
        return k.toString();
    }

    public void refresh() {
        this.getProperties().put((Object)"listRecreateKey", (Object)Boolean.TRUE);
    }

    protected Skin<?> createDefaultSkin() {
        return new CharmListViewSkin(this);
    }
}

