/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.skin.ChipSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.css.converter.StringConverter;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;

@DefaultProperty(value="text")
public class Chip
extends Control {
    private BooleanProperty deletable = new SimpleBooleanProperty((Object)this, "deletable"){

        protected void invalidated() {
            Chip.this.pseudoClassStateChanged(PSEUDO_CLASS_DELETABLE, this.get());
        }
    };
    private StringProperty text = new SimpleStringProperty((Object)this, "text");
    private final ObjectProperty<EventHandler<ActionEvent>> onDeleteAction = new SimpleObjectProperty((Object)this, "onDeleteAction");
    private final StyleableObjectProperty<Image> graphic = new StyleableObjectProperty<Image>(){

        public CssMetaData getCssMetaData() {
            return GRAPHIC;
        }

        public Object getBean() {
            return Chip.this;
        }

        public String getName() {
            return "graphic";
        }

        protected void invalidated() {
            Chip.this.pseudoClassStateChanged(PSEUDO_CLASS_HAS_GRAPHIC, this.get() != null);
        }
    };
    private StyleableStringProperty imageUrl = new StyleableStringProperty(){
        StyleOrigin origin = StyleOrigin.USER;

        public void applyStyle(StyleOrigin origin, String v) {
            this.origin = origin;
            if (Chip.this.graphic == null || !Chip.this.graphic.isBound()) {
                super.applyStyle(origin, v);
            }
            this.origin = StyleOrigin.USER;
        }

        protected void invalidated() {
            Image img;
            String url = super.get();
            if (url == null) {
                ((StyleableProperty)Chip.this.graphicProperty()).applyStyle(this.origin, null);
            } else {
                String imageViewUrl;
                Image image = (Image)Chip.this.graphicProperty().get();
                if (image != null && url.equals(imageViewUrl = image.getUrl())) {
                    return;
                }
            }
            Image image = img = url == null ? null : new Image(url);
            if (img != null && !img.isError()) {
                ((StyleableProperty)Chip.this.graphicProperty()).applyStyle(this.origin, (Object)img);
            }
        }

        public String get() {
            Image image = Chip.this.getGraphic();
            if (image != null) {
                return image.getUrl();
            }
            return null;
        }

        public StyleOrigin getStyleOrigin() {
            return Chip.this.graphic != null ? ((StyleableProperty)Chip.this.graphic).getStyleOrigin() : null;
        }

        public Object getBean() {
            return Chip.this;
        }

        public String getName() {
            return "imageUrl";
        }

        public CssMetaData<Chip, String> getCssMetaData() {
            return GRAPHIC;
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "chip";
    private static final PseudoClass PSEUDO_CLASS_DELETABLE = PseudoClass.getPseudoClass((String)"deletable");
    private static final PseudoClass PSEUDO_CLASS_HAS_GRAPHIC = PseudoClass.getPseudoClass((String)"has-graphic");
    private static final CssMetaData<Chip, String> GRAPHIC = new CssMetaData<Chip, String>("-fx-graphic", StringConverter.getInstance()){

        public boolean isSettable(Chip n) {
            return n.graphic.get() == null || !n.graphic.isBound();
        }

        public StyleableProperty<String> getStyleableProperty(Chip n) {
            return n.imageUrlProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public Chip() {
        this("", false);
    }

    public Chip(String text) {
        this(text, false);
    }

    public Chip(String text, boolean isDeletable) {
        this.setText(text);
        this.setDeletable(isDeletable);
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final BooleanProperty deletableProperty() {
        return this.deletable;
    }

    public final void setDeletable(boolean value) {
        this.deletable.set(value);
    }

    public final boolean isDeletable() {
        return this.deletable.get();
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String value) {
        this.text.setValue(value);
    }

    public final String getText() {
        return this.text.getValue();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onDeleteActionProperty() {
        return this.onDeleteAction;
    }

    public final void setOnDeleteAction(EventHandler<ActionEvent> onClose) {
        this.onDeleteAction.set(onClose);
    }

    public final EventHandler<ActionEvent> getOnDeleteAction() {
        return (EventHandler)this.onDeleteAction.get();
    }

    public final StyleableObjectProperty<Image> graphicProperty() {
        return this.graphic;
    }

    public final void setGraphic(Image value) {
        this.graphic.setValue((Object)value);
    }

    public final Image getGraphic() {
        return (Image)this.graphic.getValue();
    }

    private StyleableStringProperty imageUrlProperty() {
        return this.imageUrl;
    }

    protected Skin<?> createDefaultSkin() {
        return new ChipSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Chip.getClassCssMetaData();
    }

    static {
        ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
        Collections.addAll(styleables, GRAPHIC);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }
}

