/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.application.GlassPane;
import com.gluonhq.charm.glisten.control.Dialog;
import com.gluonhq.charm.glisten.control.skin.HeaderDialogPanel;
import com.gluonhq.charm.glisten.visual.MaterialDesignIcon;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Month;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.DateCell;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ListViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class DatePicker
extends Dialog<LocalDate> {
    private static final Double WIDTH_OF_DIALOG = 0.8;
    private static final Locale LOCALE = Locale.getDefault();
    private final ObjectProperty<LocalDate> dateProperty = new SimpleObjectProperty((Object)this, "date");
    private static final String DEFAULT_STYLE_CLASS = "charm-date-picker";

    public DatePicker() {
        this(LocalDate.now());
    }

    public DatePicker(LocalDate date) {
        this.rootNode.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setDate(date != null ? date : LocalDate.now());
        this.setContent((Node)new DatePickerPanel(this.dateProperty()));
        Button okBtn = new Button("ACCEPT");
        okBtn.setOnAction(e -> {
            this.setResult(this.getDate());
            this.hide();
        });
        Button cancelBtn = new Button("CANCEL");
        cancelBtn.setOnAction(e -> this.hide());
        this.getButtons().addAll((Object[])new ButtonBase[]{cancelBtn, okBtn});
    }

    public final ObjectProperty<LocalDate> dateProperty() {
        return this.dateProperty;
    }

    public final LocalDate getDate() {
        return (LocalDate)this.dateProperty.get();
    }

    public final void setDate(LocalDate value) {
        this.dateProperty.set((Object)value);
    }

    static class YearVirtualFlow
    extends VirtualFlow<ListCell<String>> {
        YearVirtualFlow() {
        }

        protected ListCell<String> getFirstVisibleCellWithinViewport() {
            return (ListCell)super.getFirstVisibleCellWithinViewport();
        }

        protected ListCell<String> getLastVisibleCellWithinViewport() {
            return (ListCell)super.getLastVisibleCellWithinViewport();
        }

        protected void recreateCells() {
            super.recreateCells();
        }

        public ScrollBar getScrollBar() {
            return super.getVbar();
        }
    }

    private static class YearlyCalendar
    extends Region {
        public static final int YEAR_MIN = 1900;
        public static final int YEAR_MAX = 2100;
        private static final PseudoClass YEAR_SELECTED = PseudoClass.getPseudoClass((String)"year-selected");
        private int visibleYears = 3;
        private YearVirtualFlow flow;
        private ScrollBar scrollBar;
        private ListView<String> listView;
        private StackPane thumb;
        private Timeline timeline;
        private final ObjectProperty<Year> selectedYear = new SimpleObjectProperty();

        public YearlyCalendar(Year year) {
            this.getStyleClass().add((Object)"yearly-calendar");
            this.selectedYearProperty().set((Object)year);
            this.listView = new ListView();
            this.listView.setSkin((Skin)new ListViewSkin<String>(this.listView){

                protected VirtualFlow<ListCell<String>> createVirtualFlow() {
                    flow = new YearVirtualFlow();
                    scrollBar = flow.getScrollBar();
                    scrollBar.getStyleClass().add((Object)"calendar");
                    scrollBar.setMouseTransparent(true);
                    return flow;
                }
            });
            this.listView.setCellFactory(param -> new ListCell<String>(){
                private final Label label = new Label();
                private final HBox hBox = new HBox(new Node[]{this.label});
                private String year;
                {
                    this.hBox.setAlignment(Pos.CENTER);
                    this.hBox.getStyleClass().add((Object)"year-cell");
                    this.hBox.setMaxWidth(Double.MAX_VALUE);
                    this.hBox.setOnMouseClicked(e -> {
                        if (this.year != null) {
                            this.hBox.pseudoClassStateChanged(YEAR_SELECTED, true);
                            this.setSelectedYear(Year.parse(this.year));
                        }
                    });
                }

                protected void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.year = item;
                    if (item != null && !empty) {
                        this.hBox.pseudoClassStateChanged(YEAR_SELECTED, this.getSelectedYear().equals(Year.parse(item)));
                        this.label.setText(item);
                        this.setGraphic((Node)this.hBox);
                    } else {
                        this.setGraphic(null);
                    }
                }
            });
            for (int i = 1900; i < 2100; ++i) {
                this.listView.getItems().add((Object)Integer.toString(i));
            }
            this.listView.setOnScrollStarted(e -> {
                if (this.thumb == null) {
                    this.thumb = (StackPane)this.listView.lookup(".thumb");
                }
                if (this.thumb != null) {
                    this.thumb.setOpacity(1.0);
                }
            });
            this.listView.setOnScrollFinished(e -> {
                if (this.thumb != null && this.timeline == null) {
                    this.timeline = new Timeline();
                    this.timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.thumb.opacityProperty(), (Object)1.0)}), new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{new KeyValue((WritableValue)this.thumb.opacityProperty(), (Object)1.0)}), new KeyFrame(Duration.millis((double)2000.0), new KeyValue[]{new KeyValue((WritableValue)this.thumb.opacityProperty(), (Object)0.0)})});
                }
                if (this.timeline != null) {
                    this.timeline.play();
                }
            });
            this.opacityProperty().addListener((obs, ov, nv) -> {
                if (ov.doubleValue() == 0.0 && nv.doubleValue() > 0.0) {
                    ListCell<String> lastVisibleCellWithinViewPort = this.flow.getLastVisibleCellWithinViewport();
                    ListCell<String> firstVisibleCellWithinViewPort = this.flow.getFirstVisibleCellWithinViewport();
                    this.visibleYears = Math.max(0, (lastVisibleCellWithinViewPort != null ? lastVisibleCellWithinViewPort.getIndex() : -1) - (firstVisibleCellWithinViewPort != null ? firstVisibleCellWithinViewPort.getIndex() : -1) + 1);
                    this.listView.scrollTo((Object)Integer.toString(Math.max(1900, this.getSelectedYear().minusYears(this.visibleYears / 2).getValue())));
                }
            });
            this.getChildren().addAll((Object[])new Node[]{this.listView});
            this.listView.getSelectionModel().select((Object)this.getSelectedYear().toString());
            this.selectedYearProperty().addListener((obs, ov, nv) -> {
                this.listView.getSelectionModel().select((Object)nv.toString());
                this.listView.refresh();
            });
        }

        public final Year getSelectedYear() {
            return (Year)this.selectedYear.get();
        }

        public final void setSelectedYear(Year value) {
            this.selectedYear.set((Object)value);
        }

        public final ObjectProperty<Year> selectedYearProperty() {
            return this.selectedYear;
        }

        protected void layoutChildren() {
            double w = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
            double h = this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
            this.listView.resizeRelocate(this.snappedLeftInset(), this.snappedTopInset(), w, h);
        }

        protected double computePrefWidth(double height) {
            return this.prefSize();
        }

        protected double computePrefHeight(double width) {
            return this.prefSize();
        }

        private double prefSize() {
            double h;
            GlassPane glassPane = AppManager.getInstance().getGlassPane();
            double w = glassPane.getWidth();
            if (w > (h = glassPane.getHeight())) {
                return this.snapSize(h * WIDTH_OF_DIALOG);
            }
            return this.snapSize(w * WIDTH_OF_DIALOG);
        }
    }

    private static class MonthlyCalendarPane
    extends Region {
        private static final int DAYS_PER_WEEK = 7;
        private static final int NUMBER_OF_ROWS = 6;
        private static final DateTimeFormatter weekDayNameFormatter = DateTimeFormatter.ofPattern("eeeee");
        private static final DateTimeFormatter dayCellFormatter = DateTimeFormatter.ofPattern("d");
        private YearMonth yearMonth;
        private final YearMonth initialYearMonth;
        private final GridPane gridPane;
        private final HBox hBoxYearMonth;
        private final Label labelYearMonth;
        private final List<DateCell> dayNameCells = new ArrayList<DateCell>();
        protected List<DateCell> dayCells = new ArrayList<DateCell>();
        private LocalDate[] dayCellDates;
        private final double labelHeight = 45.0;
        private final Circle circle;
        private final ObjectProperty<LocalDate> selectedDate = new SimpleObjectProperty<LocalDate>(){

            protected void invalidated() {
                super.invalidated();
                for (int i = 0; i < 42; ++i) {
                    DateCell dayCell = dayCells.get(i);
                    if (!((LocalDate)dayCell.getItem()).equals(this.get())) continue;
                    this.updateSelection(dayCell);
                    break;
                }
            }
        };
        private final IntegerProperty offsetMonth = new SimpleIntegerProperty();

        public MonthlyCalendarPane(YearMonth yearMonth) {
            this.getStyleClass().add((Object)"monthly-calendar-pane");
            this.initialYearMonth = yearMonth;
            this.gridPane = new GridPane();
            this.gridPane.setFocusTraversable(true);
            this.gridPane.getStyleClass().add((Object)"calendar-grid");
            this.gridPane.setVgap(-1.0);
            this.gridPane.setHgap(-1.0);
            for (int i = 0; i < 7; ++i) {
                DateCell cell = new DateCell();
                cell.getStyleClass().add((Object)"day-name-cell");
                this.dayNameCells.add(cell);
            }
            this.circle = new Circle();
            this.circle.setVisible(false);
            this.circle.getStyleClass().add((Object)"circle");
            this.circle.radiusProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> Math.min(this.gridPane.getHeight() / 7.0, this.gridPane.getWidth() / 7.0) / 2.0, (Observable[])new Observable[]{this.gridPane.widthProperty(), this.gridPane.heightProperty()}));
            this.labelYearMonth = new Label();
            this.labelYearMonth.getStyleClass().add((Object)"year-month-label");
            this.hBoxYearMonth = new HBox(new Node[]{this.labelYearMonth});
            this.hBoxYearMonth.getStyleClass().add((Object)"year-month-hbox");
            this.hBoxYearMonth.setAlignment(Pos.CENTER);
            this.getChildren().addAll((Object[])new Node[]{this.circle, this.gridPane, this.hBoxYearMonth});
            this.offsetMonthProperty().addListener(o -> this.initialize());
            this.initialize();
        }

        public final LocalDate getSelectedDate() {
            return (LocalDate)this.selectedDate.get();
        }

        public final void setSelectedDate(LocalDate value) {
            this.selectedDate.set((Object)value);
        }

        public final ObjectProperty<LocalDate> selectedDateProperty() {
            return this.selectedDate;
        }

        public final int getOffsetMonth() {
            return this.offsetMonth.get();
        }

        public final void setOffsetMonth(int value) {
            this.offsetMonth.set(value);
        }

        public final IntegerProperty offsetMonthProperty() {
            return this.offsetMonth;
        }

        public void setDate(LocalDate date) {
            this.yearMonth = YearMonth.from(date);
            this.setOffsetMonth(0);
            this.setSelectedDate(date);
        }

        public YearMonth getYearMonth() {
            return this.initialYearMonth.plusMonths(this.offsetMonth.get());
        }

        private void initialize() {
            int row;
            this.createDayCells();
            this.gridPane.getColumnConstraints().clear();
            this.gridPane.getRowConstraints().clear();
            this.gridPane.getChildren().clear();
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setPercentWidth(14.285714285714286);
            for (int i = 0; i < 7; ++i) {
                this.gridPane.getColumnConstraints().add((Object)columnConstraints);
            }
            RowConstraints rowConstraints = new RowConstraints();
            rowConstraints.setPercentHeight(14.285714285714286);
            for (row = 0; row < 7; ++row) {
                this.gridPane.getRowConstraints().add((Object)rowConstraints);
            }
            for (int i = 0; i < 7; ++i) {
                this.gridPane.add((Node)this.dayNameCells.get(i), i, 0);
            }
            for (row = 0; row < 6; ++row) {
                for (int col = 0; col < 7; ++col) {
                    this.gridPane.add((Node)this.dayCells.get(row * 7 + col), col, row + 1);
                }
            }
            int firstDayOfWeek = WeekFields.of(LOCALE).getFirstDayOfWeek().getValue();
            LocalDate date = LocalDate.of(2009, 7, 12 + firstDayOfWeek);
            for (int i = 0; i < 7; ++i) {
                String name = weekDayNameFormatter.withLocale(LOCALE).format(date.plus(i, ChronoUnit.DAYS));
                this.dayNameCells.get(i).setText(this.titleCaseWord(name));
                this.dayNameCells.get(i).setAlignment(Pos.CENTER);
            }
            int firstOfMonthIdx = this.determineFirstOfMonthDayOfWeek();
            YearMonth prevMonth = null;
            YearMonth nextMonth = null;
            int daysInCurMonth = -1;
            int daysInPrevMonth = -1;
            IsoChronology chrono = null;
            if (chrono == null) {
                chrono = IsoChronology.INSTANCE;
            }
            for (int i = 0; i < 42; ++i) {
                DateCell dayCell = this.dayCells.get(i);
                dayCell.getStyleClass().setAll((Object[])new String[]{"cell", "date-cell", "day-cell"});
                dayCell.setDisable(false);
                dayCell.setStyle(null);
                dayCell.setGraphic(null);
                dayCell.setTooltip(null);
                dayCell.setAlignment(Pos.CENTER);
                try {
                    if (daysInCurMonth == -1) {
                        daysInCurMonth = this.yearMonth.lengthOfMonth();
                    }
                    YearMonth month = this.yearMonth;
                    int day = i - firstOfMonthIdx + 1;
                    if (i < firstOfMonthIdx) {
                        if (prevMonth == null) {
                            prevMonth = this.yearMonth.minusMonths(1L);
                            daysInPrevMonth = prevMonth.lengthOfMonth();
                        }
                        month = prevMonth;
                        day = i + daysInPrevMonth - firstOfMonthIdx + 1;
                        dayCell.getStyleClass().add((Object)"previous-month");
                    } else if (i >= firstOfMonthIdx + daysInCurMonth) {
                        if (nextMonth == null) {
                            nextMonth = this.yearMonth.plusMonths(1L);
                        }
                        month = nextMonth;
                        day = i - daysInCurMonth - firstOfMonthIdx + 1;
                        dayCell.getStyleClass().add((Object)"next-month");
                    }
                    this.dayCellDates[i] = date = month.atDay(day);
                    ChronoLocalDate cDate = chrono.date(date);
                    dayCell.setDisable(false);
                    if (this.isToday(date)) {
                        dayCell.getStyleClass().add((Object)"today");
                    }
                    if (date.equals(this.getSelectedDate()) && !dayCell.getStyleClass().contains((Object)"previous-month") && !dayCell.getStyleClass().contains((Object)"next-month")) {
                        dayCell.getStyleClass().add((Object)"picked");
                    }
                    dayCell.setText(dayCellFormatter.withLocale(LOCALE).withChronology(chrono).withDecimalStyle(DecimalStyle.of(LOCALE)).format(cDate));
                    dayCell.updateItem(date, false);
                    continue;
                }
                catch (DateTimeException ex) {
                    dayCell.setText(" ");
                    dayCell.setDisable(true);
                }
            }
            this.labelYearMonth.setText(this.yearMonth.format(DateTimeFormatter.ofPattern("MMMM yyyy")));
        }

        private String titleCaseWord(String str) {
            int firstChar;
            if (str.length() > 0 && !Character.isTitleCase(firstChar = str.codePointAt(0))) {
                str = new String(new int[]{Character.toTitleCase(firstChar)}, 0, 1) + str.substring(Character.offsetByCodePoints(str, 0, 1));
            }
            return str;
        }

        private int determineFirstOfMonthDayOfWeek() {
            int firstDayOfWeek = WeekFields.of(LOCALE).getFirstDayOfWeek().getValue();
            int firstOfMonthIdx = this.yearMonth.atDay(1).getDayOfWeek().getValue() - firstDayOfWeek;
            if (firstOfMonthIdx < 0) {
                firstOfMonthIdx += 7;
            }
            return firstOfMonthIdx;
        }

        private boolean isToday(LocalDate localDate) {
            return localDate.equals(LocalDate.now());
        }

        private void createDayCells() {
            EventHandler dayCellActionHandler = ev -> {
                if (ev.getButton() != MouseButton.PRIMARY) {
                    return;
                }
                DateCell date = (DateCell)ev.getSource();
                if (date.getStyleClass().contains((Object)"previous-month") || date.getStyleClass().contains((Object)"next-month")) {
                    return;
                }
                this.selectedDate.set((Object)((LocalDate)date.getItem()));
            };
            this.yearMonth = this.initialYearMonth.plusMonths(this.getOffsetMonth());
            this.dayCells.clear();
            for (int row = 0; row < 6; ++row) {
                for (int col = 0; col < 7; ++col) {
                    DateCell dayCell = new DateCell();
                    dayCell.addEventHandler(MouseEvent.MOUSE_CLICKED, dayCellActionHandler);
                    this.dayCells.add(dayCell);
                }
            }
            this.dayCellDates = new LocalDate[42];
        }

        private void updateSelection(DateCell selectedCell) {
            for (int i = 0; i < 42; ++i) {
                DateCell dayCell = this.dayCells.get(i);
                if (dayCell.equals(selectedCell)) {
                    if (dayCell.getStyleClass().contains((Object)"picked") || dayCell.getStyleClass().contains((Object)"previous-month") || dayCell.getStyleClass().contains((Object)"next-month")) continue;
                    dayCell.getStyleClass().add((Object)"picked");
                    continue;
                }
                if (!dayCell.getStyleClass().contains((Object)"picked")) continue;
                dayCell.getStyleClass().remove((Object)"picked");
            }
            this.requestLayout();
        }

        private void updateCircle() {
            if (this.selectedDate.get() == null || !YearMonth.from((TemporalAccessor)this.selectedDate.get()).equals(this.yearMonth)) {
                this.circle.setVisible(false);
                return;
            }
            DateCell date = (DateCell)this.gridPane.lookup(".picked");
            if (date != null) {
                Bounds bounds = date.getBoundsInParent();
                if (bounds.getWidth() > 0.0) {
                    this.circle.setCenterX(bounds.getMinX() + bounds.getWidth() / 2.0);
                    this.circle.setCenterY(45.0 + bounds.getMinY() + bounds.getHeight() / 2.0);
                    this.circle.setVisible(true);
                } else {
                    this.circle.setVisible(false);
                }
            } else {
                this.circle.setVisible(false);
            }
        }

        protected void layoutChildren() {
            double w = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
            double h = this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
            this.updateCircle();
            this.hBoxYearMonth.resizeRelocate(this.snappedLeftInset(), this.snappedTopInset(), w, 45.0);
            this.gridPane.resizeRelocate(this.snappedLeftInset(), this.snappedTopInset() + 45.0, w, h - 45.0);
            Platform.runLater(() -> this.updateCircle());
        }

        protected double computePrefWidth(double height) {
            return this.prefSize();
        }

        protected double computePrefHeight(double width) {
            return this.prefSize();
        }

        private double prefSize() {
            double h;
            GlassPane glassPane = AppManager.getInstance().getGlassPane();
            double w = glassPane.getWidth();
            if (w > (h = glassPane.getHeight())) {
                return this.snapSize(h * WIDTH_OF_DIALOG);
            }
            return this.snapSize(w * WIDTH_OF_DIALOG);
        }
    }

    private static class MonthlyCalendar
    extends Region {
        private final YearMonth yearMonth;
        private final MonthlyCalendarPane currentMonth;
        private final MonthlyCalendarPane newMonth;
        private final HBox rowYearMonth;
        private final AtomicInteger counter;
        private final Rectangle clip;
        private Dir forward = Dir.RIGHT;
        private final Interpolator WEB_EASE = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
        private double deltaX;
        private boolean scrolling = false;
        private boolean inScrollEvent = false;
        private boolean swipping = false;
        private boolean outOfRange = false;
        private double startTouchPos;
        private double lastTouchPos;
        private long startTouchTime;
        private long lastTouchTime;
        private double touchVelocity;
        private boolean touchThresholdBroken;
        private static final double SWIPE_THRESHOLD = 0.3;
        private static final double DELTA_THRESHOLD = 0.75;
        private static final double TOUCH_THRESHOLD = 15.0;

        public MonthlyCalendar(LocalDate localDate) {
            this.yearMonth = YearMonth.from(localDate);
            this.getStyleClass().add((Object)"monthly-calendar");
            Pane gap = new Pane();
            HBox.setHgrow((Node)gap, (Priority)Priority.ALWAYS);
            this.rowYearMonth = new HBox();
            this.rowYearMonth.getStyleClass().add((Object)"navigation");
            this.rowYearMonth.setAlignment(Pos.CENTER);
            this.currentMonth = new MonthlyCalendarPane(this.yearMonth);
            this.newMonth = new MonthlyCalendarPane(this.yearMonth);
            this.selectedDateProperty().set((Object)localDate);
            this.counter = new AtomicInteger();
            Button buttonPrevMonth = MaterialDesignIcon.CHEVRON_LEFT.button((EventHandler<ActionEvent>)((EventHandler)e -> this.swipeTransition(Dir.LEFT)));
            Button buttonNextMonth = MaterialDesignIcon.CHEVRON_RIGHT.button((EventHandler<ActionEvent>)((EventHandler)e -> this.swipeTransition(Dir.RIGHT)));
            this.rowYearMonth.getChildren().addAll((Object[])new Node[]{buttonPrevMonth, gap, buttonNextMonth});
            this.getChildren().addAll((Object[])new Node[]{this.newMonth, this.currentMonth, this.rowYearMonth});
            this.setOnScrollStarted(e -> {
                this.inScrollEvent = true;
                this.deltaX = e.getDeltaX();
                this.lastTouchPos = this.startTouchPos = e.getTotalDeltaX();
                this.lastTouchTime = this.startTouchTime = System.currentTimeMillis();
                this.touchThresholdBroken = false;
                this.scrolling = false;
                this.outOfRange = false;
                e.consume();
            });
            this.setOnScroll(e -> {
                if (this.outOfRange || this.swipping || !this.inScrollEvent) {
                    return;
                }
                double drag = e.getTotalDeltaX() - this.lastTouchPos;
                long time = System.currentTimeMillis() - this.lastTouchTime;
                this.touchVelocity = drag / (double)time;
                this.lastTouchPos = e.getTotalDeltaX();
                this.lastTouchTime = System.currentTimeMillis();
                double delta = e.getTotalDeltaX() - this.startTouchPos;
                if (!this.touchThresholdBroken && Math.abs(delta) > 15.0) {
                    this.touchThresholdBroken = true;
                }
                if (this.touchThresholdBroken) {
                    double d = this.deltaX = e.getTotalDeltaX() < 0.0 ? Math.max(e.getTotalDeltaX(), -this.currentMonth.getWidth()) : Math.min(e.getTotalDeltaX(), this.currentMonth.getWidth());
                    if (!this.scrolling) {
                        Dir dir = this.deltaX > 0.0 ? Dir.LEFT : Dir.RIGHT;
                        boolean bl = this.outOfRange = !this.isNewMonthInRange(dir);
                        if (!this.outOfRange) {
                            this.currentMonth.setCache(true);
                            this.newMonth.setCache(true);
                            this.newMonth.setOffsetMonth(this.counter.get() + (this.deltaX < 0.0 ? 1 : -1));
                            if (this.forward != dir) {
                                this.forward = dir;
                                double w = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
                                this.newMonth.relocate(this.snappedLeftInset() + (this.forward == Dir.RIGHT ? w : -w), this.snappedTopInset());
                            }
                        }
                        this.scrolling = true;
                    }
                    if (!this.outOfRange) {
                        this.currentMonth.setTranslateX(this.deltaX);
                        this.newMonth.setTranslateX(this.deltaX);
                    }
                }
                e.consume();
            });
            this.setOnScrollFinished(e -> {
                if (this.outOfRange || this.swipping) {
                    return;
                }
                if (this.scrolling) {
                    double drag = e.getTotalDeltaX() - this.startTouchPos;
                    long time = System.currentTimeMillis() - this.startTouchTime;
                    boolean quick = time < 300L;
                    double velocity = quick ? drag / (double)time : this.touchVelocity;
                    double distance = velocity * 500.0;
                    double width = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
                    double threshold = Math.abs(distance / width);
                    double delta = Math.abs(drag / width);
                    this.deltaX = e.getTotalDeltaX() < 0.0 ? Math.max(e.getTotalDeltaX(), -this.currentMonth.getWidth()) : Math.min(e.getTotalDeltaX(), this.currentMonth.getWidth());
                    double startX = Math.abs(this.deltaX) * (double)(this.forward == Dir.RIGHT ? 1 : -1);
                    double endX = threshold > 0.3 || delta > 0.75 ? this.currentMonth.getWidth() * (double)(this.forward == Dir.RIGHT ? 1 : -1) : 0.0;
                    Timeline timeline = new Timeline();
                    timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.currentMonth.translateXProperty(), (Object)(-startX), this.WEB_EASE), new KeyValue((WritableValue)this.newMonth.translateXProperty(), (Object)(-startX), this.WEB_EASE)}), new KeyFrame(Duration.millis((double)(300.0 / this.currentMonth.getWidth() * Math.abs(endX - startX))), new KeyValue[]{new KeyValue((WritableValue)this.currentMonth.translateXProperty(), (Object)(-endX), this.WEB_EASE), new KeyValue((WritableValue)this.newMonth.translateXProperty(), (Object)(-endX), this.WEB_EASE)})});
                    timeline.setOnFinished(p -> {
                        if (endX != 0.0) {
                            this.counter.getAndAdd(this.forward == Dir.RIGHT ? 1 : -1);
                            this.updateMonths();
                        }
                        this.currentMonth.setCache(false);
                        this.newMonth.setCache(false);
                        this.inScrollEvent = false;
                    });
                    timeline.play();
                }
                e.consume();
            });
            this.clip = new Rectangle();
            this.setClip((Node)this.clip);
        }

        protected void layoutChildren() {
            double w = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
            double h = this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
            double labelHeight = 45.0;
            this.rowYearMonth.resizeRelocate(this.snappedLeftInset(), this.snappedTopInset(), w, labelHeight);
            this.currentMonth.resizeRelocate(this.snappedLeftInset(), this.snappedTopInset(), w, h);
            this.newMonth.resizeRelocate(this.snappedLeftInset() + (this.forward == Dir.RIGHT ? w : -w), this.snappedTopInset(), w, h);
            double padding = ((Insets)this.currentMonth.paddingProperty().get()).getLeft();
            this.clip.setX(this.snappedLeftInset() + padding);
            this.clip.setY(this.snappedTopInset());
            this.clip.setWidth(w - 2.0 * padding);
            this.clip.setHeight(h);
        }

        protected double computePrefWidth(double height) {
            return this.prefSize();
        }

        protected double computePrefHeight(double width) {
            return this.prefSize();
        }

        private double prefSize() {
            double h;
            GlassPane glassPane = AppManager.getInstance().getGlassPane();
            double w = glassPane.getWidth();
            if (w > (h = glassPane.getHeight())) {
                return this.snapSize(h * WIDTH_OF_DIALOG);
            }
            return this.snapSize(w * WIDTH_OF_DIALOG);
        }

        private boolean isNewMonthInRange(Dir dir) {
            return !(dir.equals((Object)Dir.LEFT) && this.currentMonth.getYearMonth().equals(YearMonth.of(1900, Month.JANUARY)) || dir.equals((Object)Dir.RIGHT) && this.currentMonth.getYearMonth().equals(YearMonth.of(2099, Month.DECEMBER)));
        }

        private void swipeTransition(Dir dir) {
            if (this.swipping || !this.isNewMonthInRange(dir)) {
                return;
            }
            this.swipping = true;
            this.currentMonth.setCache(true);
            this.newMonth.setCache(true);
            double startX = Math.abs(this.currentMonth.getTranslateX()) * (double)(dir == Dir.RIGHT ? 1 : -1);
            double endX = this.currentMonth.getWidth() * (double)(dir == Dir.RIGHT ? 1 : -1);
            this.newMonth.setOffsetMonth(this.counter.get() + (dir == Dir.RIGHT ? 1 : -1));
            if (this.forward != dir) {
                this.forward = dir;
                double w = this.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
                this.newMonth.relocate(this.snappedLeftInset() + (this.forward == Dir.RIGHT ? w : -w), this.snappedTopInset());
            }
            Timeline timeline = new Timeline();
            timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.currentMonth.translateXProperty(), (Object)(-startX), this.WEB_EASE), new KeyValue((WritableValue)this.newMonth.translateXProperty(), (Object)(-startX), this.WEB_EASE)}), new KeyFrame(Duration.millis((double)(300.0 / this.currentMonth.getWidth() * Math.abs(endX - startX))), new KeyValue[]{new KeyValue((WritableValue)this.currentMonth.translateXProperty(), (Object)(-endX), this.WEB_EASE), new KeyValue((WritableValue)this.newMonth.translateXProperty(), (Object)(-endX), this.WEB_EASE)})});
            timeline.setOnFinished(p -> {
                this.counter.getAndAdd(this.forward == Dir.RIGHT ? 1 : -1);
                this.updateMonths();
                this.swipping = false;
                this.currentMonth.setCache(false);
                this.newMonth.setCache(false);
            });
            timeline.play();
        }

        private void updateMonths() {
            this.currentMonth.setOffsetMonth(this.counter.get());
            this.newMonth.setOffsetMonth(this.counter.get());
            this.currentMonth.setTranslateX(0.0);
            this.newMonth.setTranslateX(0.0);
        }

        public final void setDate(LocalDate newDate) {
            this.counter.getAndAdd((int)Period.between(((LocalDate)this.currentMonth.selectedDate.get()).withDayOfMonth(1), newDate.withDayOfMonth(1)).toTotalMonths());
            this.updateMonths();
            this.selectedDateProperty().set((Object)newDate);
        }

        public final ObjectProperty<LocalDate> selectedDateProperty() {
            return this.currentMonth.selectedDateProperty();
        }

        private static enum Dir {
            LEFT,
            RIGHT;

        }
    }

    private static class DatePickerPanel
    extends HeaderDialogPanel {
        private static final PseudoClass PSEUDO_CLASS_UNSELECTED = PseudoClass.getPseudoClass((String)"unselected");
        private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("EEE, MMM d", LOCALE);
        private final VBox dateBox;
        private final Label yearLabel;
        private final Label dateLabel;
        private final ObjectProperty<LocalDate> dateProperty;
        private final MonthlyCalendar currentMonthCalendar;
        private final YearlyCalendar currentYearCalendar;
        private CalendarView view = CalendarView.MONTHS;

        public DatePickerPanel(ObjectProperty<LocalDate> dateProperty) {
            this.currentMonthCalendar = new MonthlyCalendar((LocalDate)dateProperty.get());
            this.currentYearCalendar = new YearlyCalendar(Year.from((TemporalAccessor)dateProperty.get()));
            this.dateProperty = dateProperty;
            dateProperty.addListener((obs, ov, nv) -> {
                this.currentMonthCalendar.setDate((LocalDate)nv);
                this.currentYearCalendar.setSelectedYear(Year.from(nv));
            });
            this.yearLabel = new Label();
            this.yearLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> "" + ((LocalDate)this.dateProperty.get()).getYear(), (Observable[])new Observable[]{this.dateProperty}));
            this.yearLabel.getStyleClass().addAll((Object[])new String[]{"year"});
            this.yearLabel.setOnMouseClicked(e -> this.setView(CalendarView.YEARS));
            this.dateLabel = new Label();
            this.dateLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> dateFormatter.format((TemporalAccessor)this.dateProperty.get()), (Observable[])new Observable[]{this.dateProperty}));
            this.dateLabel.getStyleClass().addAll((Object[])new String[]{"date"});
            this.dateLabel.setOnMouseClicked(e -> this.setView(CalendarView.MONTHS));
            this.yearLabel.pseudoClassStateChanged(PSEUDO_CLASS_UNSELECTED, true);
            this.dateLabel.pseudoClassStateChanged(PSEUDO_CLASS_UNSELECTED, false);
            this.currentMonthCalendar.selectedDateProperty().addListener((obs, ov, nv) -> {
                if (this.dateProperty.isBound()) {
                    throw new RuntimeException(DatePicker.class.getName() + ": A bound value cannot be set.");
                }
                this.dateProperty.set((Object)((LocalDate)this.currentMonthCalendar.selectedDateProperty().get()));
                this.currentYearCalendar.selectedYearProperty().set((Object)Year.from((TemporalAccessor)this.dateProperty.get()));
            });
            this.currentYearCalendar.selectedYearProperty().addListener((obs, ov, nv) -> {
                block8: {
                    if (this.dateProperty.isBound()) {
                        throw new RuntimeException(DatePicker.class.getName() + ": A bound value cannot be set.");
                    }
                    try {
                        LocalDate newDate = LocalDate.of(((Year)this.currentYearCalendar.selectedYearProperty().get()).getValue(), ((LocalDate)this.currentMonthCalendar.selectedDateProperty().get()).getMonthValue(), ((LocalDate)this.currentMonthCalendar.selectedDateProperty().get()).getDayOfMonth());
                        this.dateProperty.set((Object)newDate);
                    }
                    catch (DateTimeException dte) {
                        int maxDays = 31;
                        switch (((LocalDate)this.currentMonthCalendar.selectedDateProperty().get()).getMonthValue()) {
                            case 2: {
                                maxDays = IsoChronology.INSTANCE.isLeapYear(((Year)this.currentYearCalendar.selectedYearProperty().get()).getValue()) ? 29 : 28;
                                break;
                            }
                            case 4: 
                            case 6: 
                            case 9: 
                            case 11: {
                                maxDays = 30;
                            }
                        }
                        if (((LocalDate)this.currentMonthCalendar.selectedDateProperty().get()).getDayOfMonth() <= maxDays) break block8;
                        LocalDate newDate = LocalDate.of(((Year)this.currentYearCalendar.selectedYearProperty().get()).getValue(), ((LocalDate)this.currentMonthCalendar.selectedDateProperty().get()).getMonthValue(), maxDays);
                        this.dateProperty.set((Object)newDate);
                    }
                }
                if (ov != null) {
                    this.setView(CalendarView.MONTHS);
                }
            });
            this.dateBox = new VBox(new Node[]{this.yearLabel, this.dateLabel});
            this.dateBox.setAlignment(Pos.CENTER_LEFT);
            this.dateBox.setMaxWidth(Double.MAX_VALUE);
            this.setHeader((Node)this.dateBox);
            this.setCenter((Node)new StackPane(new Node[]{this.currentYearCalendar, this.currentMonthCalendar}));
            this.currentYearCalendar.setOpacity(0.0);
            this.currentYearCalendar.setMouseTransparent(true);
        }

        public void setView(CalendarView view) {
            if (this.view.equals((Object)view)) {
                return;
            }
            this.view = view;
            if (view.equals((Object)CalendarView.YEARS)) {
                this.currentYearCalendar.setSelectedYear(Year.from((TemporalAccessor)this.dateProperty.get()));
            } else {
                this.currentMonthCalendar.setDate((LocalDate)this.dateProperty.get());
            }
            this.yearLabel.pseudoClassStateChanged(PSEUDO_CLASS_UNSELECTED, view.equals((Object)CalendarView.MONTHS));
            this.dateLabel.pseudoClassStateChanged(PSEUDO_CLASS_UNSELECTED, view.equals((Object)CalendarView.YEARS));
            Interpolator WEB_EASE = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
            Timeline timeline = new Timeline();
            timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{new KeyValue((WritableValue)this.currentMonthCalendar.opacityProperty(), (Object)(view.equals((Object)CalendarView.YEARS) ? 1 : 0), WEB_EASE), new KeyValue((WritableValue)this.currentYearCalendar.opacityProperty(), (Object)(view.equals((Object)CalendarView.YEARS) ? 0 : 1), WEB_EASE)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.currentMonthCalendar.opacityProperty(), (Object)(view.equals((Object)CalendarView.YEARS) ? 0 : 1), WEB_EASE), new KeyValue((WritableValue)this.currentYearCalendar.opacityProperty(), (Object)(view.equals((Object)CalendarView.YEARS) ? 1 : 0), WEB_EASE)})});
            timeline.setOnFinished(e -> {
                if (view.equals((Object)CalendarView.YEARS)) {
                    this.currentMonthCalendar.toBack();
                    this.currentMonthCalendar.setMouseTransparent(true);
                    this.currentYearCalendar.setMouseTransparent(false);
                } else {
                    this.currentYearCalendar.toBack();
                    this.currentYearCalendar.setMouseTransparent(true);
                    this.currentMonthCalendar.setMouseTransparent(false);
                }
            });
            timeline.play();
        }
    }

    private static enum CalendarView {
        YEARS,
        MONTHS;

    }
}

