/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.attach.display.DisplayService;
import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.control.DialogView;
import com.gluonhq.charm.glisten.control.FullScreenDialogView;
import com.gluonhq.charm.glisten.control.LifecycleEvent;
import com.gluonhq.charm.glisten.mvc.View;
import com.gluonhq.impl.charm.glisten.event.DialogEventDispatcher;
import java.util.Optional;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Dimension2D;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class Dialog<T>
implements EventTarget {
    private T result = null;
    private final ObservableList<ButtonBase> buttons = FXCollections.observableArrayList();
    private FullScreenDialogView fullScreenDialogView;
    private DialogView dialogView;
    boolean isFullscreen;
    protected BorderPane rootNode = new BorderPane(){

        protected double computePrefWidth(double height) {
            return DisplayService.create().map(service -> {
                Dimension2D dim = service.getDefaultDimensions();
                double minWidth = dim.getWidth() * (service.isTablet() ? 0.6 : 0.75);
                Node content = Dialog.this.getContent();
                if (content != null) {
                    double prefWidth = content.prefWidth(-1.0);
                    return prefWidth < minWidth ? minWidth : prefWidth;
                }
                return minWidth;
            }).orElse(400.0);
        }
    };
    private final ReadOnlyBooleanWrapper showingProperty = new ReadOnlyBooleanWrapper(false);
    private final ObjectProperty<Node> titleProperty = new SimpleObjectProperty<Node>(){
        private Node oldTitle;

        protected void invalidated() {
            Labeled lbl;
            Node title;
            if (this.oldTitle != null) {
                this.oldTitle.getStyleClass().remove((Object)"dialog-title");
            }
            this.oldTitle = title = (Node)this.get();
            if (title != null && !title.getStyleClass().contains((Object)"dialog-title")) {
                title.getStyleClass().add((Object)"dialog-title");
            }
            if (title instanceof Labeled && !(lbl = (Labeled)title).wrapTextProperty().isBound()) {
                lbl.setWrapText(true);
            }
        }
    };
    private final StringProperty titleTextProperty = new SimpleStringProperty(this, "titleText"){

        protected void invalidated() {
            if (this.get() != null) {
                Dialog.this.setTitle((Node)new Label(this.get()));
            }
        }
    };
    private final StringProperty contentTextProperty = new SimpleStringProperty(this, "contentText"){

        protected void invalidated() {
            if (this.get() != null) {
                Dialog.this.setContent((Node)new Label(this.get()));
            }
        }
    };
    private final ObjectProperty<Node> contentProperty = new SimpleObjectProperty<Node>(){
        private Node oldContent;

        protected void invalidated() {
            Labeled lbl;
            Node content;
            if (this.oldContent != null) {
                this.oldContent.getStyleClass().remove((Object)"dialog-content");
            }
            this.oldContent = content = (Node)this.get();
            if (content != null && !content.getStyleClass().contains((Object)"dialog-content")) {
                content.getStyleClass().add((Object)"dialog-content");
            }
            if (content instanceof Labeled && !(lbl = (Labeled)content).wrapTextProperty().isBound()) {
                lbl.setWrapText(true);
            }
        }
    };
    private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic");
    private final BooleanProperty autoHide = new SimpleBooleanProperty((Object)this, "autoHide", true);
    private final StringProperty id = new SimpleStringProperty();
    private final DialogEventDispatcher<LifecycleEvent> dialogEventDispatcher = new DialogEventDispatcher(this);
    private final ObjectProperty<EventHandler<LifecycleEvent>> onShowing = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onShowing"){

        protected void invalidated() {
            Dialog.this.dialogEventDispatcher.setEventHandler(LifecycleEvent.SHOWING, (EventHandler<LifecycleEvent>)((EventHandler)this.get()));
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onShown = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onShown"){

        protected void invalidated() {
            Dialog.this.dialogEventDispatcher.setEventHandler(LifecycleEvent.SHOWN, (EventHandler<LifecycleEvent>)((EventHandler)this.get()));
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onHiding = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onHiding"){

        protected void invalidated() {
            Dialog.this.dialogEventDispatcher.setEventHandler(LifecycleEvent.HIDING, (EventHandler<LifecycleEvent>)((EventHandler)this.get()));
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onHidden = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onHidden"){

        protected void invalidated() {
            Dialog.this.dialogEventDispatcher.setEventHandler(LifecycleEvent.HIDDEN, (EventHandler<LifecycleEvent>)((EventHandler)this.get()));
        }
    };
    private final ObjectProperty<EventHandler<LifecycleEvent>> onCloseRequest = new SimpleObjectProperty<EventHandler<LifecycleEvent>>((Object)this, "onCloseRequest"){

        protected void invalidated() {
            Dialog.this.dialogEventDispatcher.setEventHandler(LifecycleEvent.CLOSE_REQUEST, (EventHandler<LifecycleEvent>)((EventHandler)this.get()));
        }
    };

    public Dialog() {
        this(false);
    }

    public Dialog(String contentText) {
        this(false);
        this.setContent((Node)new Label(contentText));
    }

    public Dialog(String title, String contentText) {
        this(false);
        this.setTitle((Node)new Label(title));
        this.setContent((Node)new Label(contentText));
    }

    public Dialog(@NamedArg(value="fullscreen") boolean fullscreen) {
        this.isFullscreen = fullscreen;
        if (!this.isFullscreen) {
            this.rootNode.setId(this.generateId());
            this.dialogView = new DialogView(this.rootNode, this);
            Dialog.installIntoMobileApplication(this.dialogView, this.rootNode, (BooleanProperty)this.showingProperty);
            this.rootNode.getStyleClass().add((Object)"dialog");
        } else {
            this.fullScreenDialogView = new FullScreenDialogView(this.generateId());
            this.showingProperty.bind((ObservableValue)this.fullScreenDialogView.showingProperty());
            this.showingProperty.addListener((o, ov, showing) -> {
                if (showing.booleanValue()) {
                    this.fullScreenDialogView.getScene().getWindow().setOnCloseRequest(event -> Platform.exitNestedEventLoop((Object)((Object)this.fullScreenDialogView), null));
                    Platform.enterNestedEventLoop((Object)((Object)this.fullScreenDialogView));
                } else {
                    this.fullScreenDialogView.getScene().getWindow().setOnCloseRequest(event -> {});
                    Platform.exitNestedEventLoop((Object)((Object)this.fullScreenDialogView), null);
                }
            });
            AppManager.getInstance().addViewFactory(this.fullScreenDialogView.getName(), () -> this.fullScreenDialogView);
            this.fullScreenDialogView.setOnCloseButtonPressed((EventHandler<MouseEvent>)((EventHandler)event -> this.hide()));
        }
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showingProperty.getReadOnlyProperty();
    }

    public final boolean isShowing() {
        return this.showingProperty.get();
    }

    public final ObjectProperty<Node> titleProperty() {
        return this.titleProperty;
    }

    public final Node getTitle() {
        return (Node)this.titleProperty.get();
    }

    public final void setTitle(Node title) {
        this.titleProperty.set((Object)title);
    }

    public final StringProperty titleTextProperty() {
        return this.titleTextProperty;
    }

    public final void setTitleText(String text) {
        this.titleTextProperty.set((Object)text);
    }

    public final String getTitleText() {
        return (String)this.titleTextProperty.get();
    }

    public final StringProperty contentTextProperty() {
        return this.contentTextProperty;
    }

    public final void setContentText(String text) {
        this.contentTextProperty.set((Object)text);
    }

    public final String getContentText() {
        return (String)this.contentTextProperty.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.contentProperty;
    }

    public final Node getContent() {
        return (Node)this.contentProperty.get();
    }

    public final void setContent(Node content) {
        this.contentProperty.set((Object)content);
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphic;
    }

    public final void setGraphic(Node graphic) {
        this.graphic.set((Object)graphic);
    }

    public final Node getGraphic() {
        return (Node)this.graphic.get();
    }

    public final BooleanProperty autoHideProperty() {
        return this.autoHide;
    }

    public final void setAutoHide(boolean value) {
        this.autoHide.set(value);
    }

    public final boolean isAutoHide() {
        return this.autoHide.get();
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final void setId(String id) {
        this.id.setValue(id);
    }

    public final String getId() {
        return (String)this.id.get();
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.prepend(this.dialogEventDispatcher);
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onShowingProperty() {
        return this.onShowing;
    }

    public final void setOnShowing(EventHandler<LifecycleEvent> value) {
        this.onShowing.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnShowing() {
        return (EventHandler)this.onShowing.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onShownProperty() {
        return this.onShown;
    }

    public final void setOnShown(EventHandler<LifecycleEvent> value) {
        this.onShown.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnShown() {
        return (EventHandler)this.onShown.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onHidingProperty() {
        return this.onHiding;
    }

    public final void setOnHiding(EventHandler<LifecycleEvent> value) {
        this.onHiding.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnHiding() {
        return (EventHandler)this.onHiding.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onHiddenProperty() {
        return this.onHidden;
    }

    public final void setOnHidden(EventHandler<LifecycleEvent> value) {
        this.onHidden.set(value);
    }

    public final EventHandler<LifecycleEvent> getOnHidden() {
        return (EventHandler)this.onHidden.get();
    }

    public final ObjectProperty<EventHandler<LifecycleEvent>> onCloseRequestProperty() {
        if (this.isFullscreen()) {
            return this.fullScreenDialogView.onCloseRequestProperty();
        }
        return this.onCloseRequest;
    }

    public final void setOnCloseRequest(EventHandler<LifecycleEvent> value) {
        if (this.isFullscreen()) {
            this.fullScreenDialogView.setOnCloseRequest(value);
        } else {
            this.onCloseRequest.set(value);
        }
    }

    public final EventHandler<LifecycleEvent> getOnCloseRequest() {
        if (this.isFullscreen()) {
            return this.fullScreenDialogView.getOnCloseRequest();
        }
        return (EventHandler)this.onCloseRequest.get();
    }

    public final ObservableList<ButtonBase> getButtons() {
        return this.buttons;
    }

    public final boolean isFullscreen() {
        return this.isFullscreen;
    }

    public final Optional<T> showAndWait() {
        if (!this.isFullscreen && this.rootNode.getScene() != null && !this.rootNode.getScene().getWindow().isShowing()) {
            throw new IllegalStateException("Stage must be showing before making the Dialog visible.");
        }
        if (this.isFullscreen) {
            View showingView = AppManager.getInstance().getView();
            if (showingView == null) {
                throw new IllegalStateException("A View needs to be showing before showing the full screen Dialog");
            }
            if (!showingView.getScene().getWindow().isShowing()) {
                throw new IllegalStateException("Stage must be showing before making the Dialog visible.");
            }
        }
        Event.fireEvent((EventTarget)this, (Event)new LifecycleEvent(this, LifecycleEvent.SHOWING));
        this.rebuild();
        Event.fireEvent((EventTarget)this, (Event)new LifecycleEvent(this, LifecycleEvent.SHOWN));
        if (!this.isFullscreen()) {
            this.dialogView.show();
        } else {
            AppManager.getInstance().switchView(this.fullScreenDialogView.getName());
        }
        return Optional.ofNullable(this.result);
    }

    public final void setResult(T result) {
        this.result = result;
    }

    public final void hide() {
        Event.fireEvent((EventTarget)this, (Event)new LifecycleEvent(this, LifecycleEvent.HIDING));
        LifecycleEvent closeRequestEvent = new LifecycleEvent(this, LifecycleEvent.CLOSE_REQUEST);
        Event.fireEvent((EventTarget)this, (Event)closeRequestEvent);
        if (closeRequestEvent.isConsumed()) {
            return;
        }
        if (!this.isFullscreen()) {
            this.dialogView.hide();
        } else if (this.isShowing()) {
            AppManager.getInstance().switchToPreviousView();
        }
        Event.fireEvent((EventTarget)this, (Event)new LifecycleEvent(this, LifecycleEvent.HIDDEN));
    }

    static void installIntoMobileApplication(DialogView dialogView, BorderPane rootNode, BooleanProperty showingProperty) {
        showingProperty.bind((ObservableValue)dialogView.showingProperty());
        showingProperty.addListener((o, ov, showing) -> {
            if (showing.booleanValue()) {
                rootNode.getScene().getWindow().setOnCloseRequest(event -> Platform.exitNestedEventLoop((Object)rootNode, null));
                Platform.enterNestedEventLoop((Object)rootNode);
            } else {
                rootNode.getScene().getWindow().setOnCloseRequest(event -> {});
                Platform.exitNestedEventLoop((Object)rootNode, null);
            }
        });
    }

    private String generateId() {
        return "dialog-" + UUID.randomUUID().toString();
    }

    private void rebuild() {
        if (!this.isFullscreen()) {
            Node content;
            this.rootNode.getChildren().clear();
            if (this.getGraphic() != null) {
                StackPane pane = new StackPane(new Node[]{this.getGraphic()});
                pane.getStyleClass().add((Object)"graphic-container");
                this.rootNode.setTop((Node)pane);
            }
            VBox container = new VBox();
            container.getStyleClass().add((Object)"container");
            Node title = (Node)this.titleProperty.get();
            if (title != null) {
                container.getChildren().add((Object)title);
            }
            if ((content = (Node)this.contentProperty.get()) != null) {
                container.getChildren().add((Object)content);
                VBox.setVgrow((Node)content, (Priority)Priority.ALWAYS);
            }
            this.rootNode.setCenter((Node)container);
            FlowPane buttonBar = new FlowPane();
            buttonBar.getStyleClass().add((Object)"dialog-button-bar");
            for (ButtonBase btn : this.buttons) {
                btn.getStyleClass().addAll((Object[])new String[]{"flat", "light"});
                buttonBar.getChildren().add((Object)btn);
            }
            this.rootNode.setBottom((Node)buttonBar);
        } else {
            Node content;
            Node title = (Node)this.titleProperty.get();
            if (title != null) {
                this.fullScreenDialogView.setTitle(title);
            }
            if ((content = (Node)this.contentProperty.get()) != null) {
                this.fullScreenDialogView.setContent(content);
            }
            this.fullScreenDialogView.getButtons().setAll(this.getButtons());
        }
    }
}

