/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.application.GlassPane;
import com.gluonhq.charm.glisten.control.Dialog;
import com.gluonhq.charm.glisten.layout.Layer;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

class DialogView
extends Layer {
    private final BorderPane rootNode;
    private final GlassPane glassPane;
    private final Dialog dialog;

    public DialogView(BorderPane rootNode, Dialog dialog) {
        this.dialog = dialog;
        this.rootNode = rootNode;
        this.rootNode.setVisible(false);
        this.getChildren().add((Object)rootNode);
        this.setBackgroundFade(0.5);
        this.glassPane = AppManager.getInstance().getGlassPane();
        this.autoHideProperty().bind((ObservableValue)this.dialog.autoHideProperty());
        this.addEventHandler(AppManager.MobileEvent.BACK_BUTTON_PRESSED, this::onBackButtonPressed);
    }

    protected void onBackButtonPressed(Event event) {
        this.dialog.hide();
        event.consume();
    }

    @Override
    public void layoutChildren() {
        boolean isShowing = this.isShowing();
        this.rootNode.setVisible(isShowing);
        if (!isShowing) {
            return;
        }
        double glassPaneWidth = this.snapSizeX(this.glassPane.getWidth());
        double glassPaneHeight = this.snapSizeY(this.glassPane.getHeight());
        VBox container = (VBox)this.rootNode.getCenter();
        double dialogPrefWidth = container.getPadding().getLeft() + this.rootNode.prefWidth(-1.0) + container.getPadding().getRight();
        double dialogWidth = this.snapSizeX(Math.min(glassPaneWidth * 0.96, dialogPrefWidth));
        double dialogPrefHeight = this.rootNode.prefHeight(dialogWidth);
        double dialogHeight = this.snapSizeY(Math.min(glassPaneHeight * 0.96, dialogPrefHeight));
        this.rootNode.resizeRelocate(glassPaneWidth / 2.0 - dialogWidth / 2.0, glassPaneHeight / 2.0 - dialogHeight / 2.0, dialogWidth, dialogHeight);
        super.layoutChildren();
    }
}

