/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.skin.DropdownButtonSkin;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Skin;

@DefaultProperty(value="items")
public class DropdownButton
extends Control {
    private final ObservableList<MenuItem> menuItems;
    private final ObjectProperty<MenuItem> selectedItem = new SimpleObjectProperty<MenuItem>((Object)this, "selectedItem"){

        protected void invalidated() {
            if (!DropdownButton.this.menuItems.contains(this.get())) {
                throw new RuntimeException("MenuItem must exist in the items collection");
            }
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "dropdown-button";

    public DropdownButton() {
        this.menuItems = FXCollections.observableArrayList();
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final ObjectProperty<MenuItem> selectedItemProperty() {
        return this.selectedItem;
    }

    public final void setSelectedItem(MenuItem value) {
        this.selectedItem.set((Object)value);
    }

    public final MenuItem getSelectedItem() {
        return (MenuItem)this.selectedItem.get();
    }

    public final ObservableList<MenuItem> getItems() {
        return this.menuItems;
    }

    protected Skin<?> createDefaultSkin() {
        return new DropdownButtonSkin(this);
    }
}

