/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.Dialog;
import java.io.PrintWriter;
import java.io.StringWriter;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ExceptionDialog
extends Dialog {
    private Label introText;
    private Label exceptionMessage;
    private TextArea textArea;
    private final BorderPane exceptionMessageArea;
    private final Region defaultGraphic;
    private StackPane graphicContainer;
    private final ObjectProperty<Exception> exception = new SimpleObjectProperty<Exception>((Object)this, "exception"){

        protected void invalidated() {
            ExceptionDialog.this.exceptionMessage.setText(((Exception)this.get()).getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ((Exception)this.get()).printStackTrace(pw);
            ExceptionDialog.this.textArea.setText(sw.toString());
        }
    };
    private final StringProperty introTextProperty = new SimpleStringProperty(this, "introText"){

        protected void invalidated() {
            ExceptionDialog.this.introText.setText(this.get());
        }
    };

    public ExceptionDialog() {
        super(true);
        this.introText = new Label();
        this.exceptionMessage = new Label();
        this.textArea = new TextArea();
        this.exceptionMessageArea = new BorderPane();
        this.defaultGraphic = new Region();
        this.graphicContainer = new StackPane();
        this.textArea.setEditable(false);
        VBox messageContainer = new VBox();
        messageContainer.getChildren().addAll((Object[])new Node[]{this.introText, this.exceptionMessage});
        this.exceptionMessageArea.setCenter((Node)messageContainer);
        this.exceptionMessageArea.setLeft((Node)this.graphicContainer);
        VBox mainContainer = new VBox();
        mainContainer.getChildren().addAll((Object[])new Node[]{this.exceptionMessageArea, this.textArea});
        VBox.setVgrow((Node)this.textArea, (Priority)Priority.ALWAYS);
        mainContainer.getStyleClass().add((Object)"exception-dialog-content");
        this.defaultGraphic.getStyleClass().add((Object)"graphic");
        this.graphicContainer.getStyleClass().add((Object)"graphic-container");
        messageContainer.getStyleClass().add((Object)"message-container");
        this.textArea.getStyleClass().add((Object)"stacktrace-text");
        this.introText.setWrapText(true);
        this.exceptionMessage.setWrapText(true);
        this.graphicProperty().addListener(observable -> this.graphicContainer.getChildren().setAll((Object[])new Node[]{this.getGraphic()}));
        this.setGraphic((Node)this.defaultGraphic);
        this.setContent((Node)mainContainer);
        this.setIntroText("Unhandled exception occurred in your application.");
        this.setTitle((Node)new Label("Exception"));
    }

    public final ObjectProperty<Exception> exceptionProperty() {
        return this.exception;
    }

    public final void setException(Exception ex) {
        this.exception.set((Object)ex);
    }

    public final Exception getException() {
        return (Exception)this.exception.get();
    }

    public final StringProperty introTextProperty() {
        return this.introTextProperty;
    }

    public final void setIntroText(String text) {
        this.introTextProperty.set((Object)text);
    }

    public final String getIntroText() {
        return (String)this.introTextProperty.get();
    }
}

