/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.skin.ExpansionPanelSkin;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Control;
import javafx.scene.control.Separator;
import javafx.scene.control.Skin;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Region;

public class ExpansionPanel
extends Control {
    private final ObjectProperty<Node> collapsedContentProperty = new SimpleObjectProperty();
    private final ObjectProperty<Node> expandedContentProperty = new SimpleObjectProperty();
    private final BooleanProperty expandedProperty = new SimpleBooleanProperty(false);
    private static final String DEFAULT_STYLE_CLASS = "expansion-panel";

    public ExpansionPanel() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public ExpansionPanel(Node collapsedNode, Node expandedNode) {
        this();
        this.setCollapsedContent(collapsedNode);
        this.setExpandedContent(expandedNode);
    }

    public final ObjectProperty<Node> collapsedContentProperty() {
        return this.collapsedContentProperty;
    }

    public final void setCollapsedContent(Node content) {
        this.collapsedContentProperty.set((Object)content);
    }

    public final Node getCollapsedContent() {
        return (Node)this.collapsedContentProperty.get();
    }

    public final ObjectProperty<Node> expandedContentProperty() {
        return this.expandedContentProperty;
    }

    public final void setExpandedContent(Node content) {
        this.expandedContentProperty.set((Object)content);
    }

    public final Node getExpandedContent() {
        return (Node)this.expandedContentProperty.get();
    }

    public final BooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    public final void setExpanded(boolean expanded) {
        this.expandedProperty.set(expanded);
    }

    public final boolean isExpanded() {
        return this.expandedProperty.get();
    }

    protected Skin<?> createDefaultSkin() {
        return new ExpansionPanelSkin(this);
    }

    public static class ExpandedPanel
    extends Region {
        private static final String DEFAULT_STYLE_CLASS = "expanded-panel";
        private FlowPane buttonBar;
        private ObjectProperty<Node> contentProperty = new SimpleObjectProperty();
        private final ObservableList<ButtonBase> buttons = FXCollections.observableArrayList();

        public ExpandedPanel() {
            this.buttonBar = new FlowPane();
            this.buttonBar.getStyleClass().add((Object)"button-bar");
            this.getChildren().add((Object)new Separator(Orientation.HORIZONTAL));
            this.getChildren().add((Object)this.buttonBar);
            this.buttonBar.setAlignment(Pos.CENTER_RIGHT);
            this.contentProperty.addListener(listener -> {
                Node content = this.getContent();
                content.getStyleClass().add((Object)"content");
                this.getChildren().add(0, (Object)content);
            });
            this.buttons.addListener(c -> {
                this.buttonBar.getChildren().clear();
                for (ButtonBase button : this.buttons) {
                    button.getStyleClass().addAll((Object[])new String[]{"flat", "light"});
                    this.buttonBar.getChildren().add((Object)button);
                }
                Node lastButton = (Node)this.buttonBar.getChildren().get(this.buttonBar.getChildren().size() - 1);
                if (!lastButton.getStyleClass().contains((Object)"default-button")) {
                    lastButton.getStyleClass().add((Object)"default-button");
                }
            });
            this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        }

        public final ObjectProperty<Node> contentProperty() {
            return this.contentProperty;
        }

        public final Node getContent() {
            return (Node)this.contentProperty.get();
        }

        public final void setContent(Node content) {
            this.contentProperty.set((Object)content);
        }

        public final ObservableList<ButtonBase> getButtons() {
            return this.buttons;
        }

        protected void layoutChildren() {
            double width = this.getWidth() - this.snappedRightInset() - this.snappedLeftInset();
            double y = this.snappedTopInset();
            double x = this.snappedLeftInset();
            for (Node child : this.getChildren()) {
                double prefHeight = child.prefHeight(width);
                child.resizeRelocate(x, y, width, prefHeight);
                y += prefHeight;
            }
        }
    }

    @DefaultProperty(value="titleNodes")
    public static class CollapsedPanel
    extends Region {
        private static final String DEFAULT_STYLE_CLASS = "collapsed-panel";
        private ObservableList<Node> titleNodes = FXCollections.observableArrayList();

        public CollapsedPanel() {
            this.titleNodes.addListener(c -> {
                this.getChildren().clear();
                for (int i = 0; i < this.titleNodes.size(); ++i) {
                    Node titleNode = (Node)this.titleNodes.get(i);
                    this.getChildren().add((Object)titleNode);
                    if (i != 1) continue;
                    titleNode.getStyleClass().add((Object)"center-text");
                }
            });
            this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        }

        public ObservableList<Node> getTitleNodes() {
            return this.titleNodes;
        }

        protected void layoutChildren() {
            double x = this.snappedLeftInset();
            double y = this.snappedTopInset();
            double width = this.getWidth() - this.snappedRightInset() - this.snappedLeftInset();
            double height = this.getHeight() - this.snappedBottomInset() - this.snappedTopInset();
            for (int i = 0; i < this.getChildren().size(); ++i) {
                Node node = (Node)this.getChildren().get(i);
                node.setLayoutX(x);
                node.setLayoutY(y);
                double nodeWidth = i == 0 ? 0.33 * width : 0.67 / (double)(this.getChildren().size() - 1) * width;
                node.resize(nodeWidth, height);
                x += nodeWidth;
            }
        }

        protected double computePrefHeight(double width) {
            double height = 0.0;
            for (Node node : this.getChildren()) {
                height = Math.max(node.prefHeight(width), height);
            }
            return height + this.snappedTopInset() + this.snappedBottomInset();
        }
    }
}

