/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.animation.ShrinkExpandAnimation;
import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.application.GlassPane;
import com.gluonhq.charm.glisten.control.AppBar;
import com.gluonhq.charm.glisten.control.LifecycleEvent;
import com.gluonhq.charm.glisten.layout.Layer;
import com.gluonhq.charm.glisten.mvc.View;
import com.gluonhq.charm.glisten.visual.MaterialDesignIcon;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.Transition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.util.Duration;

public class FloatingActionButton {
    private static final double ACTION_BUTTON_PADDING = 24.0;
    private static final double SECONDARY_BUTTON_SPACE = 12.0;
    public static final String STYLE_CLASS_MINI = "mini";
    public static final Function<FloatingActionButton, Point2D> TOP_LEFT = fab -> {
        AppBar appBar = AppManager.getInstance().getAppBar();
        Button btn = fab.floatingActionButton;
        if (node != null) {
            return FloatingActionButton.boundsWithNode((Node)btn, Pos.TOP_LEFT);
        }
        return new Point2D(24.0, 24.0 + appBar.getHeight());
    };
    public static final Function<FloatingActionButton, Point2D> TOP_RIGHT = fab -> {
        GlassPane glassPane = AppManager.getInstance().getGlassPane();
        AppBar appBar = AppManager.getInstance().getAppBar();
        double w = glassPane.getWidth();
        Button btn = fab.floatingActionButton;
        double actionButtonWidth = btn.prefWidth(-1.0);
        if (node != null) {
            return FloatingActionButton.boundsWithNode((Node)btn, Pos.TOP_RIGHT);
        }
        return new Point2D(w - actionButtonWidth - 24.0, 24.0 + appBar.getHeight());
    };
    public static final Function<FloatingActionButton, Point2D> BOTTOM_LEFT = fab -> {
        GlassPane glassPane = AppManager.getInstance().getGlassPane();
        double h = glassPane.getHeight();
        Button btn = fab.floatingActionButton;
        double actionButtonWidth = btn.prefWidth(-1.0);
        double actionButtonHeight = btn.prefHeight(actionButtonWidth);
        if (node != null) {
            return FloatingActionButton.boundsWithNode((Node)btn, Pos.BOTTOM_LEFT);
        }
        return new Point2D(24.0, h - actionButtonHeight - 24.0);
    };
    public static final Function<FloatingActionButton, Point2D> BOTTOM_CENTER = fab -> {
        GlassPane glassPane = AppManager.getInstance().getGlassPane();
        double w = glassPane.getWidth();
        double h = glassPane.getHeight();
        Button btn = fab.floatingActionButton;
        double actionButtonWidth = btn.prefWidth(-1.0);
        double actionButtonHeight = btn.prefHeight(actionButtonWidth);
        if (node != null) {
            return FloatingActionButton.boundsWithNode((Node)btn, Pos.BOTTOM_CENTER);
        }
        return new Point2D(w / 2.0 - actionButtonWidth / 2.0, h - actionButtonHeight - 24.0);
    };
    public static final Function<FloatingActionButton, Point2D> BOTTOM_RIGHT = fab -> {
        GlassPane glassPane = AppManager.getInstance().getGlassPane();
        double w = glassPane.getWidth();
        double h = glassPane.getHeight();
        Button btn = fab.floatingActionButton;
        double actionButtonWidth = btn.prefWidth(-1.0);
        double actionButtonHeight = btn.prefHeight(actionButtonWidth);
        if (node != null) {
            return FloatingActionButton.boundsWithNode((Node)btn, Pos.BOTTOM_RIGHT);
        }
        return new Point2D(w - actionButtonWidth - 24.0, h - actionButtonHeight - 24.0);
    };
    private static Node node;
    private static Point2D defaultTxy;
    private final Button floatingActionButton;
    private FABLayer floatingActionLayer;
    private Side secondarySide;
    private Function<FloatingActionButton, Point2D> actionButtonHandler;
    private boolean isNewActionButtonHandler = false;
    private final StringProperty textProperty;
    private final ObjectProperty<EventHandler<ActionEvent>> onActionProperty;
    private final ReadOnlyBooleanWrapper showing;
    private final StringProperty id;

    public static final void attachTo(Node node) {
        FloatingActionButton.node = node;
        node.sceneProperty().addListener((observable, oldValue, newValue) -> {
            defaultTxy = new Point2D(node.getLocalToSceneTransform().getTx(), node.getLocalToSceneTransform().getTy());
        });
    }

    public FloatingActionButton() {
        this.textProperty = new SimpleStringProperty((Object)this, "text", MaterialDesignIcon.ADD.text);
        this.onActionProperty = new SimpleObjectProperty((Object)this, "onAction");
        this.showing = new ReadOnlyBooleanWrapper((Object)this, "showing");
        this.id = new SimpleStringProperty();
        this.actionButtonHandler = BOTTOM_RIGHT;
        this.isNewActionButtonHandler = true;
        this.floatingActionButton = new Button();
        this.floatingActionButton.getStyleClass().addAll((Object[])new String[]{"round", "action", "icon-text", "fab"});
        this.floatingActionButton.onActionProperty().bind(this.onActionProperty());
        this.floatingActionButton.setText(this.getText());
        this.floatingActionButton.textProperty().bind((ObservableValue)this.textProperty());
    }

    public FloatingActionButton(String text, EventHandler<ActionEvent> onAction) {
        this();
        if (text != null && !text.isEmpty()) {
            this.setText(text);
        }
        if (onAction != null) {
            this.setOnAction(onAction);
        }
    }

    public final StringProperty textProperty() {
        return this.textProperty;
    }

    public final String getText() {
        return (String)this.textProperty.get();
    }

    public final void setText(String text) {
        this.textProperty.set((Object)text);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onActionProperty;
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty.get();
    }

    public final void setOnAction(EventHandler<ActionEvent> onAction) {
        this.onActionProperty.set(onAction);
    }

    public void show() {
        if (this.floatingActionLayer == null) {
            this.createLayer();
        }
        this.showing.set(true);
        this.floatingActionLayer.show();
    }

    public void hide() {
        this.showing.set(false);
        if (this.floatingActionLayer != null) {
            this.floatingActionLayer.hide();
        }
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final StringProperty idProperty() {
        return this.id;
    }

    public final void setId(String id) {
        this.id.setValue(id);
    }

    public final String getId() {
        return (String)this.id.get();
    }

    public final void setFloatingActionButtonHandler(Function<FloatingActionButton, Point2D> c) {
        if (this.actionButtonHandler != null && c != null) {
            this.isNewActionButtonHandler = true;
        }
        this.actionButtonHandler = c;
        if (this.floatingActionLayer == null) {
            this.createLayer();
        }
        this.floatingActionLayer.requestLayout();
    }

    public final void attachTo(FloatingActionButton primaryFAB, Side pos) {
        this.floatingActionLayer = primaryFAB.getLayer();
        primaryFAB.secondarySide = pos;
        if (this.floatingActionLayer.getChildren().size() > 1) {
            throw new IllegalStateException("Cannot attach more than 2 FloatingActionButton to a layer");
        }
        this.floatingActionLayer.getChildren().add((Object)this.floatingActionButton);
    }

    public final void showOn(View view) {
        view.addEventHandler(LifecycleEvent.SHOWN, event -> this.show());
        view.addEventHandler(LifecycleEvent.HIDING, event -> this.hide());
    }

    public final ObservableList<String> getStyleClass() {
        return this.floatingActionButton.getStyleClass();
    }

    private void createLayer() {
        this.floatingActionLayer = new FABLayer();
        this.floatingActionLayer.getChildren().add((Object)this.floatingActionButton);
    }

    private FABLayer getLayer() {
        if (this.floatingActionLayer == null) {
            this.createLayer();
        }
        return this.floatingActionLayer;
    }

    private static Point2D boundsWithNode(Node floatingActionButton, Pos position) {
        Node node = FloatingActionButton.node;
        double nodeHeight = node.getLayoutBounds().getHeight();
        double nodeWidth = node.getLayoutBounds().getWidth();
        double nodeX = node.getLayoutX();
        double nodeY = node.getLayoutY();
        double actionButtonWidth = floatingActionButton.prefWidth(-1.0);
        double actionButtonHeight = floatingActionButton.prefHeight(actionButtonWidth);
        node.localToSceneTransformProperty().addListener((observable, oldValue, newValue) -> {
            floatingActionButton.setTranslateX(newValue.getTx() - nodeX - defaultTxy.getX());
            floatingActionButton.setTranslateY(newValue.getTy() - nodeY - defaultTxy.getY());
        });
        if (position == Pos.TOP_LEFT) {
            return new Point2D(nodeX + 24.0, nodeY - actionButtonHeight / 2.0);
        }
        if (position == Pos.TOP_RIGHT) {
            return new Point2D(nodeWidth + nodeX - actionButtonWidth - 24.0, nodeY - actionButtonHeight / 2.0);
        }
        if (position == Pos.BOTTOM_LEFT) {
            return new Point2D(24.0, nodeY + nodeHeight - actionButtonHeight / 2.0);
        }
        if (position == Pos.BOTTOM_CENTER) {
            return new Point2D((nodeX + nodeWidth) / 2.0 - actionButtonWidth / 2.0, nodeY + nodeHeight - actionButtonHeight / 2.0);
        }
        return new Point2D(nodeWidth - actionButtonWidth - 24.0, nodeY + nodeHeight - actionButtonHeight / 2.0);
    }

    private class FABLayer
    extends Layer {
        private Transition showTransition;
        private Map<Button, FABPosition> positionMap = new HashMap<Button, FABPosition>();
        private Animation actionAnimation = new MovingAnimation(this.positionMap);
        private boolean firstShow = true;

        FABLayer() {
            this.setAutoHide(false);
            this.setShowTransitionFactory(layer -> {
                ParallelTransition parallelTransition = new ParallelTransition();
                for (Node button : layer.getChildren()) {
                    ShrinkExpandAnimation showTransition = new ShrinkExpandAnimation(button, true);
                    parallelTransition.getChildren().add((Object)showTransition);
                }
                this.showTransition = parallelTransition;
                return parallelTransition;
            });
            this.setHideTransitionFactory(layer -> {
                ParallelTransition parallelTransition = new ParallelTransition();
                for (Node button : layer.getChildren()) {
                    double startWidth = button.getLayoutBounds().getWidth();
                    double startHeight = button.getLayoutBounds().getHeight();
                    double startX = button.getLayoutX();
                    double startY = button.getLayoutY();
                    ShrinkExpandAnimation hideTransition = new ShrinkExpandAnimation(button, false);
                    hideTransition.setOnFinished(e -> button.resizeRelocate(startX, startY, startWidth, startHeight));
                    parallelTransition.getChildren().add((Object)hideTransition);
                }
                parallelTransition.setOnFinished(e -> {
                    this.firstShow = true;
                });
                return parallelTransition;
            });
        }

        @Override
        public void layoutChildren() {
            if (FloatingActionButton.this.actionButtonHandler != null) {
                Point2D primaryPos = FloatingActionButton.this.actionButtonHandler.apply(FloatingActionButton.this);
                double primaryWidth = FloatingActionButton.this.floatingActionButton.prefWidth(-1.0);
                double primaryHeight = FloatingActionButton.this.floatingActionButton.prefHeight(primaryWidth);
                Size primarySize = new Size(primaryWidth, primaryHeight);
                Point2D secondaryPos = primaryPos;
                Size secondarySize = primarySize;
                if (this.getChildren().size() > 1 && ((Node)this.getChildren().get(0)).isVisible()) {
                    Node secondaryFAB = (Node)this.getChildren().get(1);
                    double secondaryWidth = secondaryFAB.prefWidth(-1.0);
                    double secondaryHeight = secondaryFAB.prefHeight(secondaryWidth);
                    secondarySize = new Size(secondaryWidth, secondaryHeight);
                    secondaryPos = this.positionForSecondaryButton(primaryPos, primarySize, secondarySize, FloatingActionButton.this.secondarySide == null ? Side.TOP : FloatingActionButton.this.secondarySide);
                }
                if (this.firstShow) {
                    this.resizeRelocate(primaryPos, primarySize, secondaryPos, secondarySize);
                    this.firstShow = false;
                } else if (FloatingActionButton.this.isNewActionButtonHandler && this.actionAnimation.getStatus() != Animation.Status.RUNNING) {
                    this.positionMap.clear();
                    this.positionMap.put(FloatingActionButton.this.floatingActionButton, new FABPosition((Node)FloatingActionButton.this.floatingActionButton, primaryPos));
                    if (this.getChildren().size() > 1) {
                        Button secondaryButton = (Button)this.getChildren().get(1);
                        this.positionMap.put(secondaryButton, new FABPosition((Node)secondaryButton, secondaryPos));
                    }
                    FloatingActionButton.this.isNewActionButtonHandler = false;
                    this.actionAnimation.playFromStart();
                } else if (this.showTransition.getStatus() != Animation.Status.RUNNING && this.actionAnimation.getStatus() != Animation.Status.RUNNING) {
                    this.resizeRelocate(primaryPos, primarySize, secondaryPos, secondarySize);
                }
            }
            super.layoutChildren();
        }

        private void resizeRelocate(Point2D primaryPos, Size primarySize, Point2D secondaryPos, Size secondarySize) {
            FloatingActionButton.this.floatingActionButton.resizeRelocate(primaryPos.getX(), primaryPos.getY(), primarySize.getWidth(), primarySize.getHeight());
            if (this.getChildren().size() > 1) {
                Node secondaryFAB = (Node)this.getChildren().get(1);
                secondaryFAB.resizeRelocate(secondaryPos.getX(), secondaryPos.getY(), secondarySize.getWidth(), secondarySize.getHeight());
            }
        }

        private Point2D positionForSecondaryButton(Point2D primaryPosition, Size primarySize, Size secondarySize, Side pos) {
            double widthDifference = primarySize.getWidth() - secondarySize.getWidth();
            double heightDifference = primarySize.getHeight() - secondarySize.getHeight();
            double maxWidth = Math.max(primarySize.getWidth(), secondarySize.getWidth());
            double maxHeight = Math.max(primarySize.getHeight(), secondarySize.getHeight());
            double xSpacing = 12.0;
            double ySpacing = 12.0;
            switch (pos) {
                case RIGHT: {
                    if (widthDifference < 0.0) {
                        xSpacing = 0.0;
                    }
                    return new Point2D(primaryPosition.getX() + maxWidth + xSpacing, primaryPosition.getY() + heightDifference / 2.0);
                }
                case BOTTOM: {
                    if (heightDifference < 0.0) {
                        ySpacing = 0.0;
                    }
                    return new Point2D(primaryPosition.getX() + widthDifference / 2.0, primaryPosition.getY() + maxHeight + ySpacing);
                }
                case LEFT: {
                    if (widthDifference > 0.0) {
                        xSpacing = 0.0;
                    }
                    return new Point2D(primaryPosition.getX() - maxWidth - xSpacing, primaryPosition.getY() + heightDifference / 2.0);
                }
            }
            if (heightDifference > 0.0) {
                ySpacing = 0.0;
            }
            return new Point2D(primaryPosition.getX() + widthDifference / 2.0, primaryPosition.getY() - maxHeight - ySpacing);
        }

        private class Size {
            private double width;
            private double height;

            Size(double width, double height) {
                this.width = width;
                this.height = height;
            }

            double getWidth() {
                return this.width;
            }

            double getHeight() {
                return this.height;
            }
        }

        private class FABPosition {
            final double startX;
            final double startY;
            final double deltaX;
            final double deltaY;

            FABPosition(Node node, Point2D position) {
                this.startX = node.getLayoutX();
                this.startY = node.getLayoutY();
                this.deltaX = position.getX() - this.startX;
                this.deltaY = position.getY() - this.startY;
            }
        }

        class MovingAnimation
        extends Transition {
            private Map<Button, FABPosition> positionMap;

            MovingAnimation(Map<Button, FABPosition> positionMap) {
                this.positionMap = positionMap;
                this.setCycleDuration(Duration.millis((double)250.0));
                this.setCycleCount(1);
            }

            protected void interpolate(double frac) {
                for (Map.Entry<Button, FABPosition> entry : this.positionMap.entrySet()) {
                    Button button = entry.getKey();
                    FABPosition value = entry.getValue();
                    button.setLayoutX(value.startX + frac * value.deltaX);
                    button.setLayoutY(value.startY + frac * value.deltaY);
                }
            }
        }
    }

    private static enum Pos {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

