/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.control.AppBar;
import com.gluonhq.charm.glisten.control.LifecycleEvent;
import com.gluonhq.charm.glisten.mvc.View;
import com.gluonhq.charm.glisten.visual.MaterialDesignIcon;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

class FullScreenDialogView
extends View {
    private Node title;
    private final Region closeButton;
    private String name;
    private final ObservableList<ButtonBase> buttons;

    public FullScreenDialogView(String name) {
        this.name = name;
        this.closeButton = MaterialDesignIcon.CLEAR.button();
        this.buttons = FXCollections.observableArrayList();
        this.getStyleClass().add((Object)"dialog-fullscreen");
        this.closeButton.getStyleClass().add((Object)"close-button");
        this.addEventHandler(LifecycleEvent.HIDDEN, event -> AppManager.getInstance().getAppBar().getStyleClass().remove((Object)"dialog-fullscreen"));
    }

    @Override
    protected void updateAppBar(AppBar appBar) {
        appBar.getStyleClass().add((Object)"dialog-fullscreen");
        appBar.setNavIcon((Node)this.closeButton);
        appBar.setTitle(this.title);
        appBar.getActionItems().setAll(this.buttons);
    }

    String getName() {
        return this.name;
    }

    public final ObservableList<ButtonBase> getButtons() {
        return this.buttons;
    }

    public final void setTitle(Node title) {
        this.title = title;
    }

    public final void setContent(Node content) {
        this.setCenter(content);
    }

    public final void setOnCloseButtonPressed(EventHandler<MouseEvent> eventHandler) {
        this.closeButton.setOnMousePressed(eventHandler);
    }
}

