/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.impl.charm.glisten.util.GlistenSettings;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class ListTile
extends BorderPane {
    private final ObjectProperty<Node> primaryGraphicProperty = new SimpleObjectProperty();
    private final ObservableList<String> textProperty = FXCollections.observableArrayList();
    private final ObjectProperty<Node> secondaryGraphicProperty = new SimpleObjectProperty();
    private final BooleanProperty wrapText = new SimpleBooleanProperty();
    private final Label primaryTextLabel = new Label();
    private final VBox textBox = new VBox();
    private String currentTileStyleClass = null;

    public ListTile() {
        this.getStyleClass().setAll((Object[])new String[]{"list-tile"});
        this.textBox.getStyleClass().setAll((Object[])new String[]{"text-box"});
        this.primaryTextLabel.getStyleClass().setAll((Object[])new String[]{"primary-text"});
        this.primaryTextLabel.setMaxHeight(Double.MAX_VALUE);
        this.primaryGraphicProperty.addListener((o, old, node) -> this.replaceGraphic((Node)node, true));
        this.secondaryGraphicProperty.addListener((o, old, node) -> this.replaceGraphic((Node)node, false));
        this.textProperty.addListener(c -> this.updateText());
        this.wrapText.addListener((obs, ov, nv) -> this.updateWrap());
        this.setCenter((Node)this.textBox);
        BorderPane.setAlignment((Node)this.textBox, (Pos)Pos.CENTER_LEFT);
        if (GlistenSettings.isExperimentalPerformance()) {
            this.setCache(true);
        }
    }

    public final ObjectProperty<Node> primaryGraphicProperty() {
        return this.primaryGraphicProperty;
    }

    public final Node getPrimaryGraphic() {
        return (Node)this.primaryGraphicProperty.get();
    }

    public final void setPrimaryGraphic(Node graphic) {
        this.primaryGraphicProperty.set((Object)graphic);
    }

    public final ObservableList<String> textProperty() {
        return this.textProperty;
    }

    public void setTextLine(int i, String v) {
        while (this.textProperty.size() < i) {
            this.textProperty.add((Object)"");
        }
        if (this.textProperty.size() == i) {
            this.textProperty.add((Object)v);
        } else {
            this.textProperty.set(i, (Object)v);
        }
    }

    public final ObjectProperty<Node> secondaryGraphicProperty() {
        return this.secondaryGraphicProperty;
    }

    public final Node getSecondaryGraphic() {
        return (Node)this.secondaryGraphicProperty.get();
    }

    public final void setSecondaryGraphic(Node graphic) {
        this.secondaryGraphicProperty.set((Object)graphic);
    }

    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    public final boolean isWrapText() {
        return this.wrapText.get();
    }

    public final void setWrapText(boolean value) {
        this.wrapText.set(value);
    }

    private void replaceGraphic(Node newNode, boolean primary) {
        Optional.ofNullable(primary ? this.getLeft() : this.getRight()).ifPresent(n -> this.getChildren().remove(n));
        Optional.ofNullable(newNode).ifPresent(n -> {
            n.getStyleClass().add((Object)(primary ? "primary-graphic" : "secondary-graphic"));
            BorderPane.setAlignment((Node)n, (Pos)Pos.CENTER);
            if (primary) {
                this.setLeft((Node)n);
            } else {
                this.setRight((Node)n);
            }
        });
    }

    private void updateText() {
        if (this.textProperty.size() == this.textBox.getChildren().size()) {
            for (int i = 0; i < this.textProperty.size(); ++i) {
                Label label = (Label)this.textBox.getChildren().get(i);
                label.setText((String)this.textProperty.get(i));
            }
        } else {
            this.textBox.getChildren().clear();
            this.primaryTextLabel.setText(this.textProperty.isEmpty() ? "" : (String)this.textProperty.get(0));
            this.textBox.getChildren().add((Object)this.primaryTextLabel);
            VBox.setVgrow((Node)this.primaryTextLabel, (Priority)Priority.ALWAYS);
            for (int i = 1; i <= 2; ++i) {
                if (this.textProperty.size() <= i) continue;
                Label secondaryLine = new Label((String)this.textProperty.get(i));
                secondaryLine.setMaxHeight(Double.MAX_VALUE);
                secondaryLine.setAlignment(Pos.TOP_LEFT);
                secondaryLine.getStyleClass().add((Object)(i == 1 ? "secondary-text" : "tertiary-text"));
                this.textBox.getChildren().add((Object)secondaryLine);
                VBox.setVgrow((Node)secondaryLine, (Priority)Priority.ALWAYS);
            }
            String newTileStyleClass = this.getTileStyle();
            if (this.currentTileStyleClass != null && !newTileStyleClass.equals(this.currentTileStyleClass)) {
                this.getStyleClass().remove((Object)this.currentTileStyleClass);
                this.getStyleClass().add((Object)newTileStyleClass);
                this.currentTileStyleClass = newTileStyleClass;
            }
        }
        this.updateWrap();
    }

    private void updateWrap() {
        for (int i = 0; i < this.textProperty.size(); ++i) {
            Label label = (Label)this.textBox.getChildren().get(i);
            label.setWrapText(this.isWrapText());
        }
    }

    private String getTileStyle() {
        switch (this.textProperty.size()) {
            case 0: 
            case 1: {
                return "single-line-tile";
            }
            case 2: {
                return "dual-line-tile";
            }
        }
        return "triple-line-tile";
    }
}

