/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.application.AppManager;
import com.gluonhq.charm.glisten.application.ViewStackPolicy;
import com.gluonhq.charm.glisten.control.skin.NavigationDrawerSkin;
import com.gluonhq.charm.glisten.control.skin.navigationdrawer.FooterSkin;
import com.gluonhq.charm.glisten.control.skin.navigationdrawer.HeaderSkin;
import com.gluonhq.charm.glisten.control.skin.navigationdrawer.ItemSkin;
import com.gluonhq.charm.glisten.layout.layer.SidePopupView;
import com.gluonhq.impl.charm.glisten.util.DeviceSettings;
import com.gluonhq.impl.charm.glisten.util.ViewTools;
import java.util.Objects;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Side;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

@DefaultProperty(value="items")
public class NavigationDrawer
extends Control {
    public static final EventType<Event> ITEM_SELECTED = new EventType("ITEM_SELECTED");
    private SidePopupView sidePopupView;
    private final ObjectProperty<Node> header = new SimpleObjectProperty((Object)this, "header");
    private final ObjectProperty<Node> footer = new SimpleObjectProperty((Object)this, "footer");
    private final ObservableList<Node> items = FXCollections.observableArrayList();
    private ReadOnlyObjectWrapper<Node> selectedItem = new ReadOnlyObjectWrapper<Node>((Object)this, "selectedItem"){
        {
            this.addListener((o, prevSelection, currentSelection) -> {
                if (prevSelection instanceof Item) {
                    ((Item)((Object)prevSelection)).setSelected(false);
                }
                if (currentSelection instanceof Item) {
                    ((Item)((Object)currentSelection)).setSelected(true);
                }
            });
        }
    };
    private final ObjectProperty<Side> side = new SimpleObjectProperty((Object)this, "side", (Object)Side.LEFT);
    private static final String DEFAULT_STYLE_CLASS = "navigation-drawer";

    public NavigationDrawer() {
        this(null);
    }

    public NavigationDrawer(ObservableList<Node> items) {
        this(null, items);
    }

    public NavigationDrawer(Node header, ObservableList<Node> items) {
        this(header, null, items);
    }

    public NavigationDrawer(Node header, Node footer, ObservableList<Node> items) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setHeader(header);
        this.setFooter(footer);
        if (items != null) {
            this.items.setAll(items);
        }
        DeviceSettings.dedicatedSetup(this);
        this.sidePopupView = new SidePopupView((Node)this);
        this.sidePopupView.sideProperty().bindBidirectional(this.sideProperty());
    }

    public void open() {
        this.sidePopupView.show();
    }

    public void close() {
        this.sidePopupView.hide();
    }

    public final Node getHeader() {
        return (Node)this.header.get();
    }

    public final ObjectProperty<Node> headerProperty() {
        return this.header;
    }

    public final void setHeader(Node header) {
        this.header.set((Object)header);
    }

    public final Node getFooter() {
        return (Node)this.footer.get();
    }

    public final ObjectProperty<Node> footerProperty() {
        return this.footer;
    }

    public final void setFooter(Node footer) {
        this.footer.set((Object)footer);
    }

    public final ObservableList<Node> getItems() {
        return this.items;
    }

    public final ReadOnlyObjectProperty<Node> selectedItemProperty() {
        return this.selectedItem.getReadOnlyProperty();
    }

    public final void setSelectedItem(Node value) {
        this.selectedItem.set((Object)value);
    }

    public final Node getSelectedItem() {
        return (Node)this.selectedItemProperty().get();
    }

    public final ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    public final Side getSide() {
        return (Side)this.side.get();
    }

    public final void setSide(Side value) {
        this.side.set((Object)value);
    }

    public final ReadOnlyBooleanProperty openProperty() {
        return this.sidePopupView.showingProperty();
    }

    public final boolean isOpen() {
        return this.sidePopupView.isShowing();
    }

    protected Skin<?> createDefaultSkin() {
        return new NavigationDrawerSkin(this);
    }

    public static class ViewItem
    extends Item {
        private final String viewName;
        private final ViewStackPolicy viewStackPolicy;

        public ViewItem(String title, String viewName) {
            this(title, viewName, (ViewStackPolicy)null);
        }

        public ViewItem(String title, String viewName, ViewStackPolicy viewStackPolicy) {
            this(title, null, viewName, viewStackPolicy);
        }

        public ViewItem(String title, Node graphic, String viewName) {
            this(title, graphic, viewName, null);
        }

        public ViewItem(String title, Node graphic, String viewName, ViewStackPolicy viewStackPolicy) {
            super(title, graphic);
            this.viewName = Objects.requireNonNull(viewName, "view cannot be null");
            this.viewStackPolicy = viewStackPolicy == null ? ViewStackPolicy.USE : viewStackPolicy;
            this.selectedProperty().addListener((obs, ov, selected) -> {
                if (selected.booleanValue()) {
                    ViewStackPolicy currentViewStackPolicy = ViewStackPolicy.USE;
                    if (AppManager.getInstance().getView() != null) {
                        String currentViewName = ViewTools.findViewName(AppManager.getInstance().getView());
                        for (Node item : AppManager.getInstance().getDrawer().getItems()) {
                            if (!(item instanceof ViewItem) || !((ViewItem)item).getViewName().equals(currentViewName)) continue;
                            ViewStackPolicy itemViewStackPolicy = ((ViewItem)item).getViewStackPolicy();
                            if (itemViewStackPolicy == null) break;
                            currentViewStackPolicy = itemViewStackPolicy;
                            break;
                        }
                    }
                    AppManager.getInstance().switchView(viewName, currentViewStackPolicy);
                }
            });
        }

        public String getViewName() {
            return this.viewName;
        }

        public ViewStackPolicy getViewStackPolicy() {
            return this.viewStackPolicy;
        }
    }

    public static class Item
    extends Control {
        private static final String DEFAULT_STYLE_CLASS = "item";
        private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass((String)"selected");
        private final StringProperty title = new SimpleStringProperty((Object)this, "title");
        private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic");
        private final BooleanProperty selected = new SimpleBooleanProperty((Object)this, "selected"){

            protected void invalidated() {
                boolean selected = this.get();
                this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, selected);
                this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTED);
            }
        };
        private final BooleanProperty autoClose = new SimpleBooleanProperty((Object)this, "autoClose", true);

        public Item(String title) {
            this(title, null);
        }

        public Item(String title, Node graphic) {
            this.getStyleClass().addAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
            this.setTitle(title);
            this.setGraphic(graphic);
        }

        public final String getTitle() {
            return (String)this.title.get();
        }

        public final StringProperty titleProperty() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title.set((Object)title);
        }

        public final Node getGraphic() {
            return (Node)this.graphic.get();
        }

        public final ObjectProperty<Node> graphicProperty() {
            return this.graphic;
        }

        public final void setGraphic(Node graphic) {
            this.graphic.set((Object)graphic);
        }

        public final void setSelected(boolean value) {
            this.selectedProperty().set(value);
        }

        public final boolean isSelected() {
            return this.selected.get();
        }

        public final BooleanProperty selectedProperty() {
            return this.selected;
        }

        public final BooleanProperty autoCloseProperty() {
            return this.autoClose;
        }

        public final boolean isAutoClose() {
            return this.autoClose.get();
        }

        public final void setAutoClose(boolean value) {
            this.autoClose.set(value);
        }

        protected Skin<?> createDefaultSkin() {
            return new ItemSkin(this);
        }
    }

    public static final class Footer
    extends Control {
        private final StringProperty title = new SimpleStringProperty((Object)this, "title");
        private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic");

        public Footer(String title) {
            this(title, null);
        }

        public Footer(String title, Node graphic) {
            this.getStyleClass().addAll((Object[])new String[]{"footer"});
            this.setTitle(title);
            this.setGraphic(graphic);
        }

        public final String getTitle() {
            return (String)this.title.get();
        }

        public final StringProperty titleProperty() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title.set((Object)title);
        }

        public final Node getGraphic() {
            return (Node)this.graphic.get();
        }

        public final ObjectProperty<Node> graphicProperty() {
            return this.graphic;
        }

        public final void setGraphic(Node graphic) {
            this.graphic.set((Object)graphic);
        }

        protected Skin<?> createDefaultSkin() {
            return new FooterSkin(this);
        }
    }

    public static final class Header
    extends Control {
        private final StringProperty title = new SimpleStringProperty((Object)this, "title");
        private final StringProperty subtitle = new SimpleStringProperty((Object)this, "subtitle");
        private final ObjectProperty<Node> graphic = new SimpleObjectProperty((Object)this, "graphic");
        private ObjectProperty<EventHandler<ActionEvent>> onAction = new SimpleObjectProperty((Object)this, "onAction");

        public Header(String title) {
            this(title, null);
        }

        public Header(String title, String subtitle) {
            this(title, subtitle, null);
        }

        public Header(String title, String subtitle, Node graphic) {
            this.getStyleClass().addAll((Object[])new String[]{NavigationDrawer.DEFAULT_STYLE_CLASS, "header"});
            this.setTitle(title);
            this.setSubtitle(subtitle);
            this.setGraphic(graphic);
            DeviceSettings.dedicatedSetup(this);
        }

        public final String getTitle() {
            return (String)this.title.get();
        }

        public final StringProperty titleProperty() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title.set((Object)title);
        }

        public final String getSubtitle() {
            return (String)this.subtitle.get();
        }

        public final StringProperty subtitleProperty() {
            return this.subtitle;
        }

        public final void setSubtitle(String subtitle) {
            this.subtitle.set((Object)subtitle);
        }

        public final Node getGraphic() {
            return (Node)this.graphic.get();
        }

        public final ObjectProperty<Node> graphicProperty() {
            return this.graphic;
        }

        public final void setGraphic(Node graphic) {
            this.graphic.set((Object)graphic);
        }

        public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
            return this.onAction;
        }

        public final void setOnAction(EventHandler<ActionEvent> value) {
            this.onActionProperty().set(value);
        }

        public final EventHandler<ActionEvent> getOnAction() {
            return (EventHandler)this.onActionProperty().get();
        }

        protected Skin<?> createDefaultSkin() {
            return new HeaderSkin(this);
        }
    }
}

