/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.control.Message;
import com.gluonhq.charm.glisten.control.SnackbarLayer;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;

public class Snackbar
extends Message {
    private static final SnackbarLayer snackBarLayer = new SnackbarLayer();
    static final List<Snackbar> pendingMessages = new LinkedList<Snackbar>();
    private final StringProperty actionText = new SimpleStringProperty((Object)this, "actionText");
    private final ObjectProperty<EventHandler<ActionEvent>> onAction = new SimpleObjectProperty((Object)this, "onAction");

    public Snackbar(String message) {
        this(message, "", null);
    }

    public Snackbar(String message, String actionText, EventHandler<ActionEvent> eventHandler) {
        this.setMessage(message);
        this.setActionText(actionText);
        this.setOnAction(eventHandler);
        this.setDuration(Message.LENGTH_LONG);
    }

    public final StringProperty actionTextProperty() {
        return this.actionText;
    }

    public final String getActionText() {
        return (String)this.actionText.get();
    }

    public final void setActionText(String value) {
        this.actionText.set((Object)value);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onAction.get();
    }

    public final void setOnAction(EventHandler<ActionEvent> value) {
        this.onAction.set(value);
    }

    @Override
    public void show() {
        if (snackBarLayer.isShowing()) {
            pendingMessages.add(this);
        } else {
            snackBarLayer.show(this);
        }
    }

    @Override
    public void cancel() {
        if (pendingMessages.contains(this)) {
            pendingMessages.remove(this);
        } else {
            snackBarLayer.cancel(this);
        }
    }
}

