/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.glisten.control;

import com.gluonhq.charm.glisten.animation.FadeOutDownBigTransition;
import com.gluonhq.charm.glisten.control.Message;
import com.gluonhq.charm.glisten.control.Snackbar;
import com.gluonhq.charm.glisten.layout.layer.SidePopupView;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.animation.Transition;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Duration;

class SnackbarLayer
extends SidePopupView {
    private final HBox rootHBox;
    private final Label label;
    private final Button actionButton;
    private Transition autoHideTransition;
    private Message currentSnackbar;

    SnackbarLayer() {
        super((Node)new HBox(), Side.BOTTOM, false);
        this.setAutoHide(false);
        this.label = new Label();
        this.actionButton = new Button();
        this.actionButton.getStyleClass().add((Object)"flat");
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.rootHBox = (HBox)this.getChildren().get(0);
        this.rootHBox.getStyleClass().setAll((Object[])new String[]{"snackbar"});
        this.rootHBox.setAlignment(Pos.CENTER);
        this.rootHBox.getChildren().addAll((Object[])new Node[]{this.label, spacer, this.actionButton});
    }

    public void show(Snackbar snackbar) {
        this.currentSnackbar = snackbar;
        String buttonText = snackbar.getActionText();
        this.label.setText(snackbar.getMessage());
        this.actionButton.setText(buttonText);
        this.actionButton.setOnAction(e -> {
            if (snackbar.getOnAction() != null) {
                snackbar.getOnAction().handle(e);
            }
            this.cancel(snackbar);
        });
        this.actionButton.setVisible(buttonText != null && !buttonText.isEmpty());
        this.actionButton.setManaged(this.actionButton.isVisible());
        this.setHideTransitionFactory(layer -> {
            FadeOutDownBigTransition hideTransition = new FadeOutDownBigTransition((Node)this.rootHBox, false);
            hideTransition.setDelay(Duration.ZERO);
            hideTransition.setOnFinished(e -> this.showNext());
            return hideTransition;
        });
        this.autoHideTransition = new PauseTransition(snackbar.getDuration());
        this.autoHideTransition.setOnFinished(e -> this.hide());
        this.show();
        this.autoHideTransition.playFromStart();
    }

    public void cancel(Snackbar snackbar) {
        if (snackbar.equals(this.currentSnackbar) && this.autoHideTransition != null && this.autoHideTransition.getStatus() == Animation.Status.RUNNING) {
            this.autoHideTransition.stop();
            this.hide();
        }
    }

    private void showNext() {
        if (!Snackbar.pendingMessages.isEmpty()) {
            this.show(Snackbar.pendingMessages.remove(0));
        }
    }
}

